/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.regexp.ClassicRegexp;
import org.jruby.truffle.core.regexp.RegexpNodes;
import org.jruby.truffle.core.regexp.RegexpOptions;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.parser.BodyTranslator;

public class InterpolatedRegexpNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] children;
    private final RegexpOptions options;
    @Node.Child
    private CallDispatchHeadNode toS = DispatchHeadNodeFactory.createMethodCall();

    public InterpolatedRegexpNode(RubyNode[] children, RegexpOptions options) {
        this.children = children;
        this.options = options;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.createRegexp(this.executeChildren(frame));
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject createRegexp(DynamicObject[] parts) {
        Rope[] strings = new Rope[this.children.length];
        for (int n = 0; n < this.children.length; ++n) {
            strings[n] = StringOperations.rope(parts[n]);
        }
        ByteList preprocessed = ClassicRegexp.preprocessDRegexp(this.getContext(), strings, this.options);
        DynamicObject regexp = RegexpNodes.createRubyRegexp(this.getContext(), this, this.coreLibrary().getRegexpFactory(), RopeOperations.ropeFromByteList(preprocessed), this.options);
        if (this.options.isEncodingNone()) {
            Rope source = Layouts.REGEXP.getSource(regexp);
            if (!BodyTranslator.all7Bit(preprocessed.bytes())) {
                Layouts.REGEXP.setSource(regexp, RopeOperations.withEncodingVerySlow(source, (Encoding)ASCIIEncoding.INSTANCE));
            } else {
                Layouts.REGEXP.setSource(regexp, RopeOperations.withEncodingVerySlow(source, (Encoding)USASCIIEncoding.INSTANCE));
            }
        }
        return regexp;
    }

    @ExplodeLoop
    protected DynamicObject[] executeChildren(VirtualFrame frame) {
        DynamicObject[] values = new DynamicObject[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            Object value = this.children[i].execute(frame);
            values[i] = (DynamicObject)this.toS.call(frame, value, "to_s", new Object[0]);
        }
        return values;
    }
}

