/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.hash.BucketsStrategy;
import org.jruby.truffle.core.hash.Entry;
import org.jruby.truffle.core.hash.HashNode;
import org.jruby.truffle.core.hash.PackedArrayStrategy;
import org.jruby.truffle.core.hash.SetNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.IsFrozenNode;
import org.jruby.truffle.language.objects.IsFrozenNodeGen;

public abstract class HashLiteralNode
extends RubyNode {
    @Node.Children
    protected final RubyNode[] keyValues;
    @Node.Child
    protected CallDispatchHeadNode dupNode = DispatchHeadNodeFactory.createMethodCall();
    @Node.Child
    protected CallDispatchHeadNode freezeNode = DispatchHeadNodeFactory.createMethodCall();

    protected HashLiteralNode(RubyNode[] keyValues) {
        assert (keyValues.length % 2 == 0);
        this.keyValues = keyValues;
    }

    public int size() {
        return this.keyValues.length / 2;
    }

    public RubyNode getKey(int index) {
        return this.keyValues[2 * index];
    }

    public RubyNode getValue(int index) {
        return this.keyValues[2 * index + 1];
    }

    public static HashLiteralNode create(RubyContext context, RubyNode[] keyValues) {
        if (keyValues.length == 0) {
            return new EmptyHashLiteralNode();
        }
        if (keyValues.length <= context.getOptions().HASH_PACKED_ARRAY_MAX * 2) {
            return new SmallHashLiteralNode(keyValues);
        }
        return new GenericHashLiteralNode(keyValues);
    }

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame) {
        for (RubyNode child : this.keyValues) {
            child.executeVoid(frame);
        }
    }

    public static class GenericHashLiteralNode
    extends HashLiteralNode {
        @Node.Child
        SetNode setNode;

        public GenericHashLiteralNode(RubyNode[] keyValues) {
            super(keyValues);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            if (this.setNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setNode = (SetNode)this.insert(SetNode.create());
            }
            int bucketsCount = BucketsStrategy.capacityGreaterThan(this.keyValues.length / 2) * 4;
            Entry[] newEntries = new Entry[bucketsCount];
            DynamicObject hash = Layouts.HASH.createHash(this.coreLibrary().getHashFactory(), newEntries, 0, null, null, null, null, false);
            for (int n = 0; n < this.keyValues.length; n += 2) {
                Object key = this.keyValues[n].execute(frame);
                Object value = this.keyValues[n + 1].execute(frame);
                this.setNode.executeSet(frame, hash, key, value, false);
            }
            return hash;
        }
    }

    public static class SmallHashLiteralNode
    extends HashLiteralNode {
        private final ConditionProfile stringKeyProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private HashNode hashNode = new HashNode();
        @Node.Child
        private CallDispatchHeadNode equalNode = DispatchHeadNodeFactory.createMethodCall();
        @Node.Child
        private IsFrozenNode isFrozenNode;

        public SmallHashLiteralNode(RubyNode[] keyValues) {
            super(keyValues);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            Object[] store = PackedArrayStrategy.createStore(this.getContext());
            int size = 0;
            block0: for (int n = 0; n < this.keyValues.length / 2; ++n) {
                Object key = this.keyValues[n * 2].execute(frame);
                if (this.stringKeyProfile.profile(RubyGuards.isRubyString(key)) && !this.isFrozen(key)) {
                    key = this.freezeNode.call(frame, this.dupNode.call(frame, key, "dup", new Object[0]), "freeze", new Object[0]);
                }
                int hashed = this.hashNode.hash(frame, key, false);
                Object value = this.keyValues[n * 2 + 1].execute(frame);
                for (int i = 0; i < n; ++i) {
                    if (i >= size || hashed != PackedArrayStrategy.getHashed(store, i) || !this.equalNode.callBoolean(frame, key, "eql?", null, PackedArrayStrategy.getKey(store, i))) continue;
                    PackedArrayStrategy.setKey(store, i, key);
                    PackedArrayStrategy.setValue(store, i, value);
                    continue block0;
                }
                PackedArrayStrategy.setHashedKeyValue(store, size, hashed, key, value);
                ++size;
            }
            return Layouts.HASH.createHash(this.coreLibrary().getHashFactory(), store, size, null, null, null, null, false);
        }

        protected boolean isFrozen(Object object) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(null));
            }
            return this.isFrozenNode.executeIsFrozen(object);
        }
    }

    public static class EmptyHashLiteralNode
    extends HashLiteralNode {
        public EmptyHashLiteralNode() {
            super(new RubyNode[0]);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            return Layouts.HASH.createHash(this.coreLibrary().getHashFactory(), null, 0, null, null, null, null, false);
        }
    }
}

