/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.unpack;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.format.FormatFrameDescriptor;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.unpack.ArrayResult;
import org.jruby.truffle.language.backtrace.InternalRootNode;

public class UnpackRootNode
extends RootNode
implements InternalRootNode {
    private final RubyContext context;
    @Node.Child
    private FormatNode child;
    @CompilerDirectives.CompilationFinal
    private int expectedLength;

    public UnpackRootNode(RubyContext context, SourceSection sourceSection, FormatNode child) {
        super(RubyLanguage.class, sourceSection, FormatFrameDescriptor.FRAME_DESCRIPTOR);
        this.context = context;
        this.child = child;
        this.expectedLength = context.getOptions().ARRAY_UNINITIALIZED_SIZE;
    }

    public Object execute(VirtualFrame frame) {
        boolean taint;
        Object[] output;
        int outputLength;
        frame.setObject(FormatFrameDescriptor.SOURCE_SLOT, frame.getArguments()[0]);
        frame.setInt(FormatFrameDescriptor.SOURCE_LENGTH_SLOT, ((Integer)frame.getArguments()[1]).intValue());
        frame.setInt(FormatFrameDescriptor.SOURCE_POSITION_SLOT, 0);
        frame.setObject(FormatFrameDescriptor.OUTPUT_SLOT, (Object)new Object[this.expectedLength]);
        frame.setInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT, 0);
        frame.setBoolean(FormatFrameDescriptor.TAINT_SLOT, false);
        this.child.execute(frame);
        try {
            outputLength = frame.getInt(FormatFrameDescriptor.OUTPUT_POSITION_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        if (outputLength > this.expectedLength) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.expectedLength = ArrayUtils.capacity(this.context, this.expectedLength, outputLength);
        }
        try {
            output = (Object[])frame.getObject(FormatFrameDescriptor.OUTPUT_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        try {
            taint = frame.getBoolean(FormatFrameDescriptor.TAINT_SLOT);
        }
        catch (FrameSlotTypeException e) {
            throw new IllegalStateException(e);
        }
        return new ArrayResult(output, outputLength, taint);
    }

    public boolean isCloningAllowed() {
        return true;
    }

    public String getName() {
        return "unpack";
    }

    public String toString() {
        return this.getName();
    }
}

