/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.unpack;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.RootNode;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.LoopRecovery;
import org.jruby.truffle.core.format.pack.SimplePackParser;
import org.jruby.truffle.core.format.unpack.SimpleUnpackTreeBuilder;
import org.jruby.truffle.core.format.unpack.UnpackRootNode;
import org.jruby.truffle.language.RubyNode;

public class UnpackCompiler {
    private final RubyContext context;
    private final RubyNode currentNode;

    public UnpackCompiler(RubyContext context, RubyNode currentNode) {
        this.context = context;
        this.currentNode = currentNode;
    }

    public CallTarget compile(String format) {
        if (format.length() > this.context.getOptions().PACK_RECOVER_LOOP_MIN) {
            format = LoopRecovery.recoverLoop(format);
        }
        SimpleUnpackTreeBuilder builder = new SimpleUnpackTreeBuilder(this.context, this.currentNode);
        builder.enterSequence();
        SimplePackParser parser = new SimplePackParser(builder, format.getBytes(StandardCharsets.US_ASCII));
        parser.parse();
        builder.exitSequence();
        return Truffle.getRuntime().createCallTarget((RootNode)new UnpackRootNode(this.context, this.currentNode.getEncapsulatingSourceSection(), builder.getNode()));
    }
}

