/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.format.FormatGuards;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.convert.ToLongNode;
import org.jruby.truffle.core.format.convert.ToLongNodeGen;
import org.jruby.truffle.core.format.read.SourceNode;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadLongOrBigIntegerNode
extends FormatNode {
    @Node.Child
    private ToLongNode toLongNode;
    private final ConditionProfile bignumProfile = ConditionProfile.createBinaryProfile();

    @Specialization(guards={"isNull(source)"})
    public void read(VirtualFrame frame, Object source) {
        this.advanceSourcePosition(frame);
        throw new IllegalStateException();
    }

    @Specialization
    public int read(VirtualFrame frame, int[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public long read(VirtualFrame frame, long[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public Object read(VirtualFrame frame, Object[] source) {
        Object value = source[this.advanceSourcePosition(frame)];
        if (this.bignumProfile.profile(FormatGuards.isRubyBignum(value))) {
            return value;
        }
        if (this.toLongNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toLongNode = (ToLongNode)this.insert(ToLongNodeGen.create(false, null));
        }
        return this.toLongNode.executeToLong(frame, value);
    }
}

