/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.convert.ToDoubleNode;
import org.jruby.truffle.core.format.convert.ToDoubleNodeGen;
import org.jruby.truffle.core.format.read.SourceNode;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadDoubleNode
extends FormatNode {
    @Node.Child
    private ToDoubleNode toDoubleNode;

    @Specialization(guards={"isNull(source)"})
    public double read(VirtualFrame frame, Object source) {
        this.advanceSourcePosition(frame);
        throw new IllegalStateException();
    }

    @Specialization
    public double read(VirtualFrame frame, int[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public double read(VirtualFrame frame, long[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public double read(VirtualFrame frame, double[] source) {
        return source[this.advanceSourcePosition(frame)];
    }

    @Specialization
    public double read(VirtualFrame frame, Object[] source) {
        if (this.toDoubleNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toDoubleNode = (ToDoubleNode)this.insert(ToDoubleNodeGen.create(null));
        }
        return this.toDoubleNode.executeToDouble(frame, source[this.advanceSourcePosition(frame)]);
    }
}

