/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.printf;

import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.LiteralFormatNode;
import org.jruby.truffle.core.format.control.SequenceNode;
import org.jruby.truffle.core.format.convert.ToDoubleWithCoercionNodeGen;
import org.jruby.truffle.core.format.convert.ToIntegerNodeGen;
import org.jruby.truffle.core.format.convert.ToStringNodeGen;
import org.jruby.truffle.core.format.format.FormatCharacterNodeGen;
import org.jruby.truffle.core.format.format.FormatFloatNodeGen;
import org.jruby.truffle.core.format.format.FormatIntegerBinaryNodeGen;
import org.jruby.truffle.core.format.format.FormatIntegerNodeGen;
import org.jruby.truffle.core.format.printf.SprintfConfig;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.format.read.array.ReadArgumentIndexValueNodeGen;
import org.jruby.truffle.core.format.read.array.ReadHashValueNodeGen;
import org.jruby.truffle.core.format.read.array.ReadIntegerNodeGen;
import org.jruby.truffle.core.format.read.array.ReadStringNodeGen;
import org.jruby.truffle.core.format.read.array.ReadValueNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBytesNodeGen;
import org.jruby.truffle.core.format.write.bytes.WritePaddedBytesNodeGen;
import org.jruby.truffle.core.rope.CodeRange;

public class PrintfSimpleTreeBuilder {
    private final RubyContext context;
    private final List<FormatNode> sequence = new ArrayList<FormatNode>();
    private final List<SprintfConfig> configs;
    public static final int DEFAULT = -1;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public PrintfSimpleTreeBuilder(RubyContext context, List<SprintfConfig> configs) {
        this.context = context;
        this.configs = configs;
    }

    private void buildTree() {
        for (SprintfConfig config : this.configs) {
            FormatNode node;
            if (config.isLiteral()) {
                node = WriteBytesNodeGen.create(new LiteralFormatNode(config.getLiteralBytes()));
            } else {
                FormatNode valueNode;
                if (config.getNamesBytes() != null) {
                    DynamicObject key = this.context.getSymbolTable().getSymbol(this.context.getRopeTable().getRope(config.getNamesBytes(), (Encoding)USASCIIEncoding.INSTANCE, CodeRange.CR_7BIT));
                    valueNode = ReadHashValueNodeGen.create(key, new SourceNode());
                } else {
                    valueNode = config.getAbsoluteArgumentIndex() != null ? ReadArgumentIndexValueNodeGen.create(config.getAbsoluteArgumentIndex(), new SourceNode()) : ReadValueNodeGen.create(new SourceNode());
                }
                FormatNode widthNode = config.isWidthStar() ? ReadIntegerNodeGen.create(new SourceNode()) : (config.isArgWidth() ? ReadArgumentIndexValueNodeGen.create(config.getWidth(), new SourceNode()) : new LiteralFormatNode(config.getWidth() == null ? -1 : config.getWidth()));
                FormatNode precisionNode = config.isPrecisionStar() ? ReadIntegerNodeGen.create(new SourceNode()) : (config.isPrecisionArg() ? ReadArgumentIndexValueNodeGen.create(config.getPrecision(), new SourceNode()) : new LiteralFormatNode(config.getPrecision() == null ? -1 : config.getPrecision()));
                block0 : switch (config.getFormatType()) {
                    case INTEGER: {
                        char format;
                        switch (config.getFormat()) {
                            case 'B': 
                            case 'b': {
                                format = config.getFormat();
                                break;
                            }
                            case 'd': 
                            case 'i': 
                            case 'u': {
                                format = 'd';
                                break;
                            }
                            case 'o': {
                                format = 'o';
                                break;
                            }
                            case 'X': 
                            case 'x': {
                                format = config.getFormat();
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException();
                            }
                        }
                        if (config.getFormat() == 'b' || config.getFormat() == 'B') {
                            node = WriteBytesNodeGen.create(FormatIntegerBinaryNodeGen.create(format, config.isPlus(), config.isFsharp(), config.isMinus(), config.isHasSpace(), config.isZero(), widthNode, precisionNode, ToIntegerNodeGen.create(valueNode)));
                            break;
                        }
                        node = WriteBytesNodeGen.create(FormatIntegerNodeGen.create(format, config.isHasSpace(), config.isZero(), config.isPlus(), config.isMinus(), config.isFsharp(), widthNode, precisionNode, ToIntegerNodeGen.create(valueNode)));
                        break;
                    }
                    case FLOAT: {
                        switch (config.getFormat()) {
                            case 'E': 
                            case 'G': 
                            case 'e': 
                            case 'f': 
                            case 'g': {
                                node = WriteBytesNodeGen.create(FormatFloatNodeGen.create(config.getFormat(), config.isHasSpace(), config.isZero(), config.isPlus(), config.isMinus(), config.isFsharp(), widthNode, precisionNode, ToDoubleWithCoercionNodeGen.create(valueNode)));
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                    case OTHER: {
                        switch (config.getFormat()) {
                            case 'c': {
                                node = WriteBytesNodeGen.create(FormatCharacterNodeGen.create(config.isMinus(), widthNode, valueNode));
                                break block0;
                            }
                            case 'p': 
                            case 's': {
                                String conversionMethodName = config.getFormat() == 's' ? "to_s" : "inspect";
                                FormatNode conversionNode = config.getAbsoluteArgumentIndex() == null && config.getNamesBytes() == null ? ReadStringNodeGen.create(true, conversionMethodName, false, EMPTY_BYTES, new SourceNode()) : ToStringNodeGen.create(true, conversionMethodName, false, EMPTY_BYTES, valueNode);
                                if (config.getWidth() != null || config.isWidthStar()) {
                                    node = WritePaddedBytesNodeGen.create(config.isMinus(), widthNode, conversionNode);
                                    break block0;
                                }
                                node = WriteBytesNodeGen.create(conversionNode);
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                    default: {
                        throw new UnsupportedOperationException("unsupported type: " + config.getFormatType().toString());
                    }
                }
            }
            this.sequence.add(node);
        }
    }

    public FormatNode getNode() {
        this.buildTree();
        return new SequenceNode(this.sequence.toArray(new FormatNode[this.sequence.size()]));
    }
}

