/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.core.format.FormatNode;

@NodeChildren(value={@NodeChild(value="value", type=FormatNode.class)})
public abstract class FormatFloatHumanReadableNode
extends FormatNode {
    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isInteger(value)"})
    public byte[] formatInteger(double value) {
        return String.valueOf((long)value).getBytes(StandardCharsets.US_ASCII);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!isInteger(value)"})
    public byte[] format(double value) {
        return String.valueOf(value).getBytes(StandardCharsets.US_ASCII);
    }

    protected boolean isInteger(double value) {
        return value - Math.rint(value) == 0.0;
    }
}

