/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.Ptr;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvResult;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscodingManager;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.Visibility;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;

@CoreClass(value="Encoding::Converter")
public abstract class EncodingConverterNodes {

    @Primitive(name="encoding_converter_primitive_errinfo")
    public static abstract class EncodingConverterErrinfoNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object encodingConverterLastError(DynamicObject encodingConverter) {
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            Object[] ret = new Object[]{this.getSymbol(ec.lastError.getResult().symbolicName()), this.nil(), this.nil(), this.nil(), this.nil()};
            if (ec.lastError.getSource() != null) {
                ret[1] = this.createString(new ByteList(ec.lastError.getSource()));
            }
            if (ec.lastError.getDestination() != null) {
                ret[2] = this.createString(new ByteList(ec.lastError.getDestination()));
            }
            if (ec.lastError.getErrorBytes() != null) {
                ret[3] = this.createString(new ByteList(ec.lastError.getErrorBytes(), ec.lastError.getErrorBytesP(), ec.lastError.getErrorBytesLength()));
                ret[4] = this.createString(new ByteList(ec.lastError.getErrorBytes(), ec.lastError.getErrorBytesP() + ec.lastError.getErrorBytesLength(), ec.lastError.getReadAgainLength()));
            }
            return this.createArray(ret, ret.length);
        }
    }

    @Primitive(name="encoding_converter_last_error")
    public static abstract class EncodingConverterLastErrorNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object encodingConverterLastError(DynamicObject encodingConverter) {
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            EConv.LastError lastError = ec.lastError;
            if (lastError.getResult() != EConvResult.InvalidByteSequence && lastError.getResult() != EConvResult.IncompleteInput && lastError.getResult() != EConvResult.UndefinedConversion) {
                return this.nil();
            }
            boolean readAgain = lastError.getReadAgainLength() != 0;
            int size = readAgain ? 5 : 4;
            Object[] store = new Object[size];
            store[0] = this.eConvResultToSymbol(lastError.getResult());
            store[1] = this.createString(new ByteList(lastError.getSource()));
            store[2] = this.createString(new ByteList(lastError.getDestination()));
            store[3] = this.createString(new ByteList(lastError.getErrorBytes(), lastError.getErrorBytesP(), lastError.getErrorBytesP() + lastError.getErrorBytesLength()));
            if (readAgain) {
                store[4] = this.createString(new ByteList(lastError.getErrorBytes(), lastError.getErrorBytesLength() + lastError.getErrorBytesP(), lastError.getReadAgainLength()));
            }
            return this.createArray(store, size);
        }

        private DynamicObject eConvResultToSymbol(EConvResult result) {
            switch (result) {
                case InvalidByteSequence: {
                    return this.getSymbol("invalid_byte_sequence");
                }
                case UndefinedConversion: {
                    return this.getSymbol("undefined_conversion");
                }
                case DestinationBufferFull: {
                    return this.getSymbol("destination_buffer_full");
                }
                case SourceBufferEmpty: {
                    return this.getSymbol("source_buffer_empty");
                }
                case Finished: {
                    return this.getSymbol("finished");
                }
                case AfterOutput: {
                    return this.getSymbol("after_output");
                }
                case IncompleteInput: {
                    return this.getSymbol("incomplete_input");
                }
            }
            throw new UnsupportedOperationException(StringUtils.format("Unknown EConv result: %s", result));
        }
    }

    @Primitive(name="encoding_converter_putback")
    public static abstract class EncodingConverterPutbackNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject encodingConverterPutback(DynamicObject encodingConverter, int maxBytes) {
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            int putbackable = ec.putbackable();
            return this.putback(encodingConverter, putbackable < maxBytes ? putbackable : maxBytes);
        }

        @Specialization
        public DynamicObject encodingConverterPutback(DynamicObject encodingConverter, NotProvided maxBytes) {
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            return this.putback(encodingConverter, ec.putbackable());
        }

        private DynamicObject putback(DynamicObject encodingConverter, int n) {
            assert (RubyGuards.isRubyEncodingConverter(encodingConverter));
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            ByteList bytes = new ByteList(n);
            ec.putback(bytes.getUnsafeBytes(), bytes.getBegin(), n);
            bytes.setRealSize(n);
            if (ec.sourceEncoding != null) {
                bytes.setEncoding(ec.sourceEncoding);
            }
            return this.createString(bytes);
        }
    }

    @Primitive(name="encoding_converter_primitive_convert")
    public static abstract class PrimitiveConvertNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        @Specialization(guards={"isRubyString(source)", "isRubyString(target)", "isRubyHash(options)"})
        public Object encodingConverterPrimitiveConvert(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, DynamicObject options) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Specialization(guards={"isNil(source)", "isRubyString(target)"})
        public Object primitiveConvertNilSource(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, int options) {
            return this.primitiveConvertHelper(encodingConverter, source, target, offset, size, options);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyString(target)"})
        public Object encodingConverterPrimitiveConvert(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, int options) {
            return this.primitiveConvertHelper(encodingConverter, source, target, offset, size, options);
        }

        @CompilerDirectives.TruffleBoundary
        private Object primitiveConvertHelper(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, int options) {
            EConvResult res;
            boolean growOutputBuffer;
            boolean nonNullSource = source != this.nil();
            Rope sourceRope = nonNullSource ? StringOperations.rope(source) : RopeConstants.EMPTY_UTF8_ROPE;
            Rope targetRope = StringOperations.rope(target);
            ByteList outBytes = RopeOperations.toByteListCopy(targetRope);
            Ptr inPtr = new Ptr();
            Ptr outPtr = new Ptr();
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            boolean changeOffset = offset == 0;
            boolean bl = growOutputBuffer = size == -1;
            if (size == -1) {
                size = 16;
                if (nonNullSource && size < sourceRope.byteLength()) {
                    size = sourceRope.byteLength();
                }
            }
            while (true) {
                if (changeOffset) {
                    offset = outBytes.getRealSize();
                }
                if (outBytes.getRealSize() < offset) {
                    throw new RaiseException(this.coreExceptions().argumentError("output offset too big", (Node)this));
                }
                long outputByteEnd = offset + size;
                if (outputByteEnd > Integer.MAX_VALUE) {
                    throw new RaiseException(this.coreExceptions().argumentError("output offset + bytesize too big", (Node)this));
                }
                outBytes.ensure((int)outputByteEnd);
                inPtr.p = 0;
                outPtr.p = offset;
                int os = outPtr.p + size;
                res = TranscodingManager.convert(ec, sourceRope.getBytes(), inPtr, sourceRope.byteLength() + inPtr.p, outBytes.getUnsafeBytes(), outPtr, os, options);
                outBytes.setRealSize(outPtr.p - outBytes.begin());
                if (nonNullSource) {
                    sourceRope = this.makeSubstringNode.executeMake(sourceRope, inPtr.p, sourceRope.byteLength() - inPtr.p);
                    StringOperations.setRope(source, sourceRope);
                }
                if (!growOutputBuffer || res != EConvResult.DestinationBufferFull) break;
                if (0x3FFFFFFF < size) {
                    throw new RaiseException(this.coreExceptions().argumentError("too long conversion result", (Node)this));
                }
                size *= 2;
            }
            if (ec.destinationEncoding != null) {
                outBytes.setEncoding(ec.destinationEncoding);
            }
            StringOperations.setRope(target, RopeOperations.ropeFromByteList(outBytes));
            return this.getSymbol(res.symbolicName());
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            Object econv = null;
            return this.allocateNode.allocate(rubyClass, econv);
        }
    }

    @CoreMethod(names={"each_transcoder"}, onSingleton=true, needsBlock=true)
    public static abstract class EachTranscoderNode
    extends YieldingCoreMethodNode {
        @Specialization
        public Object transcodingMap(VirtualFrame frame, DynamicObject block) {
            for (Map.Entry<String, Map<String, Transcoder>> sourceEntry : TranscodingManager.allTranscoders.entrySet()) {
                DynamicObject source = this.getContext().getSymbolTable().getSymbol(sourceEntry.getKey());
                int size = sourceEntry.getValue().size();
                Object[] destinations = new Object[size];
                int i = 0;
                for (Map.Entry<String, Transcoder> destinationEntry : sourceEntry.getValue().entrySet()) {
                    destinations[i++] = this.getContext().getSymbolTable().getSymbol(destinationEntry.getKey());
                }
                this.yield(frame, block, source, this.createArray(destinations, size));
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize_jruby"}, required=2, optional=1, lowerFixnum={3}, visibility=Visibility.PRIVATE)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyEncoding(source)", "isRubyEncoding(destination)"})
        public DynamicObject initialize(DynamicObject self, DynamicObject source, DynamicObject destination, int options) {
            Encoding sourceEncoding = Layouts.ENCODING.getEncoding(source);
            Encoding destinationEncoding = Layouts.ENCODING.getEncoding(destination);
            EConv econv = TranscodingManager.create(sourceEncoding, destinationEncoding, options);
            econv.sourceEncoding = sourceEncoding;
            econv.destinationEncoding = destinationEncoding;
            Layouts.ENCODING_CONVERTER.setEconv(self, econv);
            return this.nil();
        }
    }
}

