/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.objects.IsTaintedNode;
import org.jruby.truffle.language.objects.TaintNode;

public class TaintResultNode
extends RubyNode {
    private final boolean taintFromSelf;
    private final int taintFromParameter;
    private final ConditionProfile taintProfile = ConditionProfile.createBinaryProfile();
    @Node.Child
    private RubyNode method;
    @Node.Child
    private IsTaintedNode isTaintedNode;
    @Node.Child
    private TaintNode taintNode;

    public TaintResultNode(boolean taintFromSelf, int taintFromParameter, RubyNode method) {
        this.taintFromSelf = taintFromSelf;
        this.taintFromParameter = taintFromParameter;
        this.method = method;
        this.isTaintedNode = IsTaintedNode.create();
    }

    public TaintResultNode() {
        this.taintFromSelf = false;
        this.taintFromParameter = -1;
        this.isTaintedNode = IsTaintedNode.create();
    }

    public Object maybeTaint(Object source, Object result) {
        if (this.taintProfile.profile(this.isTaintedNode.executeIsTainted(source))) {
            if (this.taintNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.taintNode = (TaintNode)this.insert(TaintNode.create());
            }
            this.taintNode.executeTaint(result);
        }
        return result;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject result;
        try {
            result = this.method.executeDynamicObject(frame);
        }
        catch (DoNotTaint e) {
            return e.getResult();
        }
        catch (UnexpectedResultException e) {
            throw new UnsupportedOperationException(e);
        }
        if (result != this.nil()) {
            Object argument;
            if (this.taintFromSelf) {
                this.maybeTaint(RubyArguments.getSelf((Frame)frame), result);
            }
            if (this.taintFromParameter != -1 && this.taintFromParameter < RubyArguments.getArgumentsCount((Frame)frame) && (argument = RubyArguments.getArgument((Frame)frame, this.taintFromParameter)) instanceof DynamicObject) {
                DynamicObject taintSource = (DynamicObject)argument;
                this.maybeTaint(taintSource, result);
            }
        }
        return result;
    }

    public static class DoNotTaint
    extends ControlFlowException {
        private static final long serialVersionUID = 5321304910918469059L;
        private final Object result;

        public DoNotTaint(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }
    }
}

