/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.MissingBehavior;
import org.jruby.truffle.language.objects.IsANode;
import org.jruby.truffle.language.objects.IsANodeGen;

@NodeChild(value="value", type=RubyNode.class)
public abstract class NumericToFloatNode
extends RubyNode {
    @Node.Child
    private IsANode isANode = IsANodeGen.create(null, null);
    @Node.Child
    private CallDispatchHeadNode toFloatCallNode;
    private final String method;

    public NumericToFloatNode(String method) {
        this.method = method;
    }

    public abstract double executeDouble(VirtualFrame var1, DynamicObject var2);

    private Object callToFloat(VirtualFrame frame, DynamicObject value) {
        if (this.toFloatCallNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toFloatCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(MissingBehavior.RETURN_MISSING));
        }
        return this.toFloatCallNode.call(frame, value, this.method, new Object[0]);
    }

    @Specialization(guards={"isNumeric(frame, value)"})
    protected double castNumeric(VirtualFrame frame, DynamicObject value, @Cached(value="create()") BranchProfile errorProfile) {
        Object result = this.callToFloat(frame, value);
        if (result instanceof Double) {
            return (Double)result;
        }
        errorProfile.enter();
        throw new RaiseException(this.coreExceptions().typeErrorCantConvertTo(value, "Float", this.method, result, this));
    }

    @Fallback
    protected double fallback(Object value) {
        throw new RaiseException(this.coreExceptions().typeErrorCantConvertInto(value, "Float", this));
    }

    protected boolean isNumeric(VirtualFrame frame, Object value) {
        return this.isANode.executeIsA(value, this.coreLibrary().getNumericClass());
    }
}

