/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.cast.CmpIntNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=CmpIntNode.class)
public final class CmpIntNodeGen
extends CmpIntNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @Node.Child
    private RubyNode receiver_;
    @Node.Child
    private RubyNode other_;
    @CompilerDirectives.CompilationFinal
    private Class<?> valueType_;
    @Node.Child
    private BaseNode_ specialization_;

    private CmpIntNodeGen(RubyNode value, RubyNode receiver, RubyNode other) {
        this.value_ = value;
        this.receiver_ = receiver;
        this.other_ = other;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public int executeCmpInt(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
        return this.specialization_.executeInt1(frameValue, valueValue, receiverValue, otherValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) {
        return this.specialization_.executeInt0(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static CmpIntNode create(RubyNode value, RubyNode receiver, RubyNode other) {
        return new CmpIntNodeGen(value, receiver, other);
    }

    @GeneratedBy(methodName="cmpObject(VirtualFrame, Object, Object, Object)", value=CmpIntNode.class)
    private static final class CmpObjectNode_
    extends BaseNode_ {
        CmpObjectNode_(CmpIntNodeGen root) {
            super(root, 5);
        }

        @Override
        public int executeInt0(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            Object receiverValue_ = this.root.receiver_.execute(frameValue);
            Object otherValue_ = this.root.other_.execute(frameValue);
            if (!(RubyGuards.isInteger(valueValue_) || RubyGuards.isLong(valueValue_) || RubyGuards.isRubyBignum(valueValue_) || this.root.isNil(valueValue_))) {
                return this.root.cmpObject(frameValue, valueValue_, receiverValue_, otherValue_);
            }
            return this.getNext().executeInt1(frameValue, valueValue_, receiverValue_, otherValue_);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            if (!(RubyGuards.isInteger(valueValue) || RubyGuards.isLong(valueValue) || RubyGuards.isRubyBignum(valueValue) || this.root.isNil(valueValue))) {
                return this.root.cmpObject(frameValue, valueValue, receiverValue, otherValue);
            }
            return this.getNext().executeInt1(frameValue, valueValue, receiverValue, otherValue);
        }

        static BaseNode_ create(CmpIntNodeGen root) {
            return new CmpObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="cmpNil(Object, Object, Object)", value=CmpIntNode.class)
    private static final class CmpNilNode_
    extends BaseNode_ {
        CmpNilNode_(CmpIntNodeGen root) {
            super(root, 4);
        }

        @Override
        public int executeInt0(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            Object receiverValue_ = this.root.receiver_.execute(frameValue);
            Object otherValue_ = this.root.other_.execute(frameValue);
            if (this.root.isNil(valueValue_)) {
                return this.root.cmpNil(valueValue_, receiverValue_, otherValue_);
            }
            return this.getNext().executeInt1(frameValue, valueValue_, receiverValue_, otherValue_);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            if (this.root.isNil(valueValue)) {
                return this.root.cmpNil(valueValue, receiverValue, otherValue);
            }
            return this.getNext().executeInt1(frameValue, valueValue, receiverValue, otherValue);
        }

        static BaseNode_ create(CmpIntNodeGen root) {
            return new CmpNilNode_(root);
        }
    }

    @GeneratedBy(methodName="cmpBignum(DynamicObject, Object, Object)", value=CmpIntNode.class)
    private static final class CmpBignumNode_
    extends BaseNode_ {
        CmpBignumNode_(CmpIntNodeGen root) {
            super(root, 3);
        }

        @Override
        public int executeInt0(VirtualFrame frameValue) {
            DynamicObject valueValue_;
            try {
                valueValue_ = this.root.value_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = this.root.receiver_.execute(frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeInt1(frameValue, ex.getResult(), receiverValue, otherValue);
            }
            Object receiverValue_ = this.root.receiver_.execute(frameValue);
            Object otherValue_ = this.root.other_.execute(frameValue);
            if (RubyGuards.isRubyBignum(valueValue_)) {
                return this.root.cmpBignum(valueValue_, receiverValue_, otherValue_);
            }
            return this.getNext().executeInt1(frameValue, valueValue_, receiverValue_, otherValue_);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyBignum(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.cmpBignum(valueValue_, receiverValue, otherValue);
            }
            return this.getNext().executeInt1(frameValue, valueValue, receiverValue, otherValue);
        }

        static BaseNode_ create(CmpIntNodeGen root) {
            return new CmpBignumNode_(root);
        }
    }

    @GeneratedBy(methodName="cmpLong(long, Object, Object)", value=CmpIntNode.class)
    private static final class CmpLongNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        CmpLongNode_(CmpIntNodeGen root, Object valueValue) {
            super(root, 2);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((CmpLongNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeInt0(frameValue);
        }

        @Override
        public int executeInt0(VirtualFrame frameValue) {
            long valueValue_;
            try {
                if (this.valueImplicitType == Long.TYPE) {
                    valueValue_ = this.root.value_.executeLong(frameValue);
                } else if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = RubyTypes.promoteToLong(this.root.value_.executeInteger(frameValue));
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitLong(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = this.root.receiver_.execute(frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeInt1(frameValue, ex.getResult(), receiverValue, otherValue);
            }
            Object receiverValue_ = this.root.receiver_.execute(frameValue);
            Object otherValue_ = this.root.other_.execute(frameValue);
            return this.root.cmpLong(valueValue_, receiverValue_, otherValue_);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                return this.root.cmpLong(valueValue_, receiverValue, otherValue);
            }
            return this.getNext().executeInt1(frameValue, valueValue, receiverValue, otherValue);
        }

        static BaseNode_ create(CmpIntNodeGen root, Object valueValue) {
            return new CmpLongNode_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="cmpInt(int, Object, Object)", value=CmpIntNode.class)
    private static final class CmpIntNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        CmpIntNode_(CmpIntNodeGen root, Object valueValue) {
            super(root, 1);
            this.valueImplicitType = RubyTypesGen.getImplicitIntegerClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((CmpIntNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeInt0(frameValue);
        }

        @Override
        public int executeInt0(VirtualFrame frameValue) {
            int valueValue_;
            try {
                if (this.valueImplicitType == Integer.TYPE) {
                    valueValue_ = this.root.value_.executeInteger(frameValue);
                } else {
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    valueValue_ = RubyTypesGen.expectImplicitInteger(valueValue__, this.valueImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object receiverValue = this.root.receiver_.execute(frameValue);
                Object otherValue = this.root.other_.execute(frameValue);
                return this.getNext().executeInt1(frameValue, ex.getResult(), receiverValue, otherValue);
            }
            Object receiverValue_ = this.root.receiver_.execute(frameValue);
            Object otherValue_ = this.root.other_.execute(frameValue);
            return this.root.cmpInt(valueValue_, receiverValue_, otherValue_);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            if (RubyTypesGen.isImplicitInteger(valueValue, this.valueImplicitType)) {
                int valueValue_ = RubyTypesGen.asImplicitInteger(valueValue, this.valueImplicitType);
                return this.root.cmpInt(valueValue_, receiverValue, otherValue);
            }
            return this.getNext().executeInt1(frameValue, valueValue, receiverValue, otherValue);
        }

        static BaseNode_ create(CmpIntNodeGen root, Object valueValue) {
            return new CmpIntNode_(root, valueValue);
        }
    }

    @GeneratedBy(value=CmpIntNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(CmpIntNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue, receiverValue, otherValue));
        }

        @Override
        public int executeInt0(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            Object receiverValue_ = this.root.receiver_.execute(frameValue);
            Object otherValue_ = this.root.other_.execute(frameValue);
            return this.getNext().executeInt1(frameValue, valueValue_, receiverValue_, otherValue_);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            return this.getNext().executeInt1(frameValue, valueValue, receiverValue, otherValue);
        }

        static BaseNode_ create(CmpIntNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=CmpIntNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(CmpIntNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public int executeInt1(VirtualFrame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            return (Integer)this.uninitialized((Frame)frameValue, valueValue, receiverValue, otherValue);
        }

        static BaseNode_ create(CmpIntNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=CmpIntNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected CmpIntNodeGen root;

        BaseNode_(CmpIntNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (CmpIntNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_, this.root.receiver_, this.root.other_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            return this.executeInt1((VirtualFrame)frameValue, valueValue, receiverValue, otherValue);
        }

        public abstract int executeInt1(VirtualFrame var1, Object var2, Object var3, Object var4);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            Object receiverValue_ = this.root.receiver_.execute(frameValue);
            Object otherValue_ = this.root.other_.execute(frameValue);
            return this.executeInt1(frameValue, valueValue_, receiverValue_, otherValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public int executeInt0(VirtualFrame frameValue) {
            return (Integer)this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object valueValue, Object receiverValue, Object otherValue) {
            DynamicObject valueValue_;
            if (RubyTypesGen.isImplicitInteger(valueValue)) {
                return CmpIntNode_.create(this.root, valueValue);
            }
            if (RubyTypesGen.isImplicitLong(valueValue)) {
                return CmpLongNode_.create(this.root, valueValue);
            }
            if (valueValue instanceof DynamicObject && RubyGuards.isRubyBignum(valueValue_ = (DynamicObject)valueValue)) {
                return CmpBignumNode_.create(this.root);
            }
            if (this.root.isNil(valueValue)) {
                return CmpNilNode_.create(this.root);
            }
            if (!(RubyGuards.isInteger(valueValue) || RubyGuards.isLong(valueValue) || RubyGuards.isRubyBignum(valueValue) || this.root.isNil(valueValue))) {
                return CmpObjectNode_.create(this.root);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeValue_(Frame frameValue) {
            Object object;
            Class valueType_ = this.root.valueType_;
            if (valueType_ == Integer.TYPE) {
                return this.root.value_.executeInteger((VirtualFrame)frameValue);
            }
            if (valueType_ == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.valueType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.valueType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.valueType_ = _type;
            return object;
        }
    }
}

