/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.array.ArrayAppendOneNode;
import org.jruby.truffle.core.array.ArrayEnsureCapacityNode;
import org.jruby.truffle.core.array.ArrayGeneralizeNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="value", type=RubyNode.class)})
public abstract class ArrayWriteNormalizedNode
extends RubyNode {
    public abstract Object executeWrite(DynamicObject var1, int var2, Object var3);

    @Specialization(guards={"isInBounds(array, index)", "strategy.matches(array)", "strategy.accepts(value)"}, limit="ARRAY_STRATEGIES")
    public Object writeWithin(DynamicObject array, int index, Object value, @Cached(value="of(array)") ArrayStrategy strategy) {
        strategy.newMirror(array).set(index, value);
        return value;
    }

    @Specialization(guards={"isInBounds(array, index)", "currentStrategy.matches(array)", "!currentStrategy.accepts(value)", "valueStrategy.specializesFor(value)"}, limit="ARRAY_STRATEGIES")
    public Object writeWithinGeneralize(DynamicObject array, int index, Object value, @Cached(value="of(array)") ArrayStrategy currentStrategy, @Cached(value="forValue(value)") ArrayStrategy valueStrategy, @Cached(value="currentStrategy.generalize(valueStrategy)") ArrayStrategy generalizedStrategy) {
        int size = ArrayHelpers.getSize(array);
        ArrayMirror currentMirror = currentStrategy.newMirror(array);
        ArrayMirror storeMirror = generalizedStrategy.newArray(currentMirror.getLength());
        currentMirror.copyTo(storeMirror, 0, 0, size);
        storeMirror.set(index, value);
        generalizedStrategy.setStore(array, storeMirror.getArray());
        return value;
    }

    @Specialization(guards={"isExtendingByOne(array, index)"})
    public Object writeExtendByOne(DynamicObject array, int index, Object value, @Cached(value="create()") ArrayAppendOneNode appendNode) {
        appendNode.executeAppendOne(array, value);
        return value;
    }

    @Specialization(guards={"!isInBounds(array, index)", "!isExtendingByOne(array, index)", "strategy.matches(array)", "!strategy.accepts(nil())"}, limit="ARRAY_STRATEGIES")
    public Object writeBeyondPrimitive(DynamicObject array, int index, Object value, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="create()") ArrayGeneralizeNode generalizeNode) {
        int newSize = index + 1;
        Object[] objectStore = generalizeNode.executeGeneralize(array, newSize);
        for (int n = strategy.getSize(array); n < index; ++n) {
            objectStore[n] = this.nil();
        }
        objectStore[index] = value;
        strategy.setStoreAndSize(array, objectStore, newSize);
        return value;
    }

    @Specialization(guards={"!isInBounds(array, index)", "!isExtendingByOne(array, index)", "strategy.matches(array)", "strategy.accepts(nil())"})
    public Object writeBeyondObject(DynamicObject array, int index, Object value, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="create()") ArrayEnsureCapacityNode ensureCapacityNode) {
        ensureCapacityNode.executeEnsureCapacity(array, index + 1);
        ArrayMirror store = strategy.newMirror(array);
        for (int n = strategy.getSize(array); n < index; ++n) {
            store.set(n, this.nil());
        }
        store.set(index, value);
        ArrayHelpers.setSize(array, index + 1);
        return value;
    }

    protected static boolean isInBounds(DynamicObject array, int index) {
        return index >= 0 && index < ArrayHelpers.getSize(array);
    }

    protected static boolean isExtendingByOne(DynamicObject array, int index) {
        return index == ArrayHelpers.getSize(array);
    }
}

