/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.array.ArrayReadDenormalizedNode;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ArrayReadDenormalizedNode.class)
public final class ArrayReadDenormalizedNodeGen
extends ArrayReadDenormalizedNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @CompilerDirectives.CompilationFinal
    private Class<?> indexType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayReadDenormalizedNodeGen(RubyNode array, RubyNode index) {
        this.array_ = array;
        this.index_ = index;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeRead(DynamicObject arrayValue, int indexValue) {
        return this.specialization_.execute1(arrayValue, indexValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ArrayReadDenormalizedNode create(RubyNode array, RubyNode index) {
        return new ArrayReadDenormalizedNodeGen(array, index);
    }

    @GeneratedBy(methodName="read(DynamicObject, int, ConditionProfile)", value=ArrayReadDenormalizedNode.class)
    private static final class ReadNode_
    extends BaseNode_ {
        private final ConditionProfile negativeIndexProfile;
        private final Class<?> indexImplicitType;

        ReadNode_(ArrayReadDenormalizedNodeGen root, Object indexValue, ConditionProfile negativeIndexProfile) {
            super(root, 1);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.negativeIndexProfile = negativeIndexProfile;
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((ReadNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_((Frame)frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_((Frame)frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute_(arrayValue_, ex.getResult());
            }
            return this.root.read(arrayValue_, indexValue_, this.negativeIndexProfile);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue) {
            return this.root.read(arrayValue, indexValue, this.negativeIndexProfile);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                return this.root.read(arrayValue_, indexValue_, this.negativeIndexProfile);
            }
            return this.getNext().execute_(arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadDenormalizedNodeGen root, Object indexValue, ConditionProfile negativeIndexProfile) {
            return new ReadNode_(root, indexValue, negativeIndexProfile);
        }
    }

    @GeneratedBy(value=ArrayReadDenormalizedNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayReadDenormalizedNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue));
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue) {
            return this.getNext().execute_(arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadDenormalizedNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadDenormalizedNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayReadDenormalizedNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue) {
            return this.uninitialized(null, arrayValue, indexValue);
        }

        static BaseNode_ create(ArrayReadDenormalizedNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayReadDenormalizedNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayReadDenormalizedNodeGen root;

        BaseNode_(ArrayReadDenormalizedNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ArrayReadDenormalizedNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.index_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue) {
            return this.execute_(arrayValue, indexValue);
        }

        public abstract Object execute_(Object var1, Object var2);

        public Object execute1(DynamicObject arrayValue, int indexValue) {
            return this.execute_(arrayValue, indexValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object indexValue_ = this.executeIndex_((Frame)frameValue);
            return this.execute_(arrayValue_, indexValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue)) {
                ConditionProfile negativeIndexProfile1 = ConditionProfile.createBinaryProfile();
                return ReadNode_.create(this.root, indexValue, negativeIndexProfile1);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeIndex_(Frame frameValue) {
            Object object;
            Class indexType_ = this.root.indexType_;
            if (indexType_ == Integer.TYPE) {
                return this.root.index_.executeInteger((VirtualFrame)frameValue);
            }
            if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.indexType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.indexType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.indexType_ = _type;
            return object;
        }
    }
}

