/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CallPrimitiveNode;
import org.jruby.truffle.builtins.CoreMethodNodeManager;
import org.jruby.truffle.builtins.InvokePrimitiveNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.UnsafeNode;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.numeric.FixnumLowerNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.ReadSelfNode;
import org.jruby.truffle.parser.Translator;

public class PrimitiveNodeConstructor {
    private final Primitive annotation;
    private final NodeFactory<? extends RubyNode> factory;

    public PrimitiveNodeConstructor(Primitive annotation, NodeFactory<? extends RubyNode> factory) {
        this.annotation = annotation;
        this.factory = factory;
    }

    public int getPrimitiveArity() {
        return this.factory.getExecutionSignature().size();
    }

    public RubyNode createCallPrimitiveNode(RubyContext context, Source source, SourceIndexLength sourceSection, RubyNode fallback) {
        int argumentsCount = this.getPrimitiveArity();
        ArrayList<RubyNode> arguments = new ArrayList<RubyNode>(argumentsCount);
        if (this.annotation.needsSelf()) {
            arguments.add(this.transformArgument(new ProfileArgumentNode(new ReadSelfNode()), 0));
            --argumentsCount;
        }
        for (int n = 0; n < argumentsCount; ++n) {
            ProfileArgumentNode readArgumentNode = new ProfileArgumentNode(new ReadPreArgumentNode(n, MissingArgumentBehavior.UNDEFINED));
            arguments.add(this.transformArgument(readArgumentNode, n + 1));
        }
        if (!CoreMethodNodeManager.isSafe(context, this.annotation.unsafe())) {
            return new UnsafeNode();
        }
        RubyNode primitiveNode = CoreMethodNodeManager.createNodeFromFactory(context, source, sourceSection, this.factory, arguments);
        return Translator.withSourceSection(sourceSection, new CallPrimitiveNode(primitiveNode, fallback));
    }

    public RubyNode createInvokePrimitiveNode(RubyContext context, Source source, SourceIndexLength sourceSection, RubyNode[] arguments) {
        assert (arguments.length == this.getPrimitiveArity());
        if (!CoreMethodNodeManager.isSafe(context, this.annotation.unsafe())) {
            return new UnsafeNode();
        }
        for (int n = 0; n < arguments.length; ++n) {
            int nthArg = this.annotation.needsSelf() ? n : n + 1;
            arguments[n] = this.transformArgument(arguments[n], nthArg);
        }
        List signatures = this.factory.getNodeSignatures();
        assert (signatures.size() == 1);
        List signature = (List)signatures.get(0);
        RubyNode primitiveNode = signature.get(0) == SourceSection.class ? (RubyNode)((Object)this.factory.createNode(new Object[]{sourceSection.toSourceSection(source), arguments})) : (signature.get(0) == SourceIndexLength.class ? (RubyNode)((Object)this.factory.createNode(new Object[]{sourceSection, arguments})) : (RubyNode)((Object)this.factory.createNode(new Object[]{arguments})));
        return Translator.withSourceSection(sourceSection, new InvokePrimitiveNode(primitiveNode));
    }

    private RubyNode transformArgument(RubyNode argument, int n) {
        if (ArrayUtils.contains(this.annotation.lowerFixnum(), n)) {
            return FixnumLowerNodeGen.create(argument);
        }
        return argument;
    }
}

