/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.object.DynamicObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.CodeSource;
import org.jruby.truffle.Log;
import org.jruby.truffle.Main;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.builtins.PrimitiveManager;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.CoreMethods;
import org.jruby.truffle.core.encoding.EncodingManager;
import org.jruby.truffle.core.exception.CoreExceptions;
import org.jruby.truffle.core.kernel.AtExitManager;
import org.jruby.truffle.core.kernel.TraceManager;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.core.objectspace.ObjectSpaceManager;
import org.jruby.truffle.core.rope.RopeTable;
import org.jruby.truffle.core.string.CoreStrings;
import org.jruby.truffle.core.string.FrozenStrings;
import org.jruby.truffle.core.symbol.SymbolTable;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.interop.InteropManager;
import org.jruby.truffle.language.CallStackManager;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.SafepointManager;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.loader.FeatureLoader;
import org.jruby.truffle.language.loader.SourceLoader;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.shared.SharedObjects;
import org.jruby.truffle.options.Options;
import org.jruby.truffle.options.OptionsBuilder;
import org.jruby.truffle.options.Verbosity;
import org.jruby.truffle.platform.NativePlatform;
import org.jruby.truffle.platform.NativePlatformFactory;
import org.jruby.truffle.stdlib.CoverageManager;
import org.jruby.truffle.stdlib.readline.ConsoleHolder;
import org.jruby.truffle.tools.InstrumentationServerManager;
import org.jruby.truffle.tools.callgraph.CallGraph;
import org.jruby.truffle.tools.callgraph.SimpleWriter;

public class RubyContext
extends ExecutionContext {
    private final TruffleLanguage.Env env;
    private final Options options;
    private final String rubyHome;
    private String originalInputFile;
    private InputStream syntaxCheckInputStream;
    private boolean verbose;
    private final RopeTable ropeTable = new RopeTable();
    private final PrimitiveManager primitiveManager = new PrimitiveManager();
    private final SafepointManager safepointManager = new SafepointManager(this);
    private final SymbolTable symbolTable;
    private final InteropManager interopManager = new InteropManager(this);
    private final CodeLoader codeLoader = new CodeLoader(this);
    private final FeatureLoader featureLoader = new FeatureLoader(this);
    private final TraceManager traceManager;
    private final ObjectSpaceManager objectSpaceManager = new ObjectSpaceManager(this);
    private final SharedObjects sharedObjects = new SharedObjects(this);
    private final AtExitManager atExitManager = new AtExitManager(this);
    private final SourceLoader sourceLoader = new SourceLoader(this);
    private final CallStackManager callStack = new CallStackManager(this);
    private final CoreStrings coreStrings = new CoreStrings(this);
    private final FrozenStrings frozenStrings = new FrozenStrings(this);
    private final CoreExceptions coreExceptions = new CoreExceptions(this);
    private final EncodingManager encodingManager = new EncodingManager(this);
    private final CompilerOptions compilerOptions = Truffle.getRuntime().createCompilerOptions();
    private final NativePlatform nativePlatform;
    private final CoreLibrary coreLibrary;
    private final CoreMethods coreMethods;
    private final ThreadManager threadManager;
    private final LexicalScope rootLexicalScope;
    private final InstrumentationServerManager instrumentationServerManager;
    private final CallGraph callGraph;
    private final PrintStream debugStandardOut;
    private final CoverageManager coverageManager;
    private final ConsoleHolder consoleHolder;
    private final Object classVariableDefinitionLock = new Object();
    private String currentDirectory;
    public static ThreadLocal<RubyContext> contextsBeingCreated = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyContext(TruffleLanguage.Env env) {
        contextsBeingCreated.set(this);
        try {
            this.env = env;
            OptionsBuilder optionsBuilder = new OptionsBuilder();
            optionsBuilder.set(env.getConfig());
            optionsBuilder.set(System.getProperties());
            this.options = optionsBuilder.build();
            this.rubyHome = this.findRubyHome();
            Log.LOGGER.config(() -> String.format("ruby home: %s", this.rubyHome));
            this.currentDirectory = System.getProperty("user.dir");
            this.verbose = this.options.VERBOSITY.equals((Object)Verbosity.TRUE);
            this.callGraph = this.options.CALL_GRAPH ? new CallGraph() : null;
            if (this.compilerOptions.supportsOption("MinTimeThreshold")) {
                this.compilerOptions.setOption("MinTimeThreshold", (Object)100000000);
            }
            if (this.compilerOptions.supportsOption("MinInliningMaxCallerSize")) {
                this.compilerOptions.setOption("MinInliningMaxCallerSize", (Object)5000);
            }
            this.coreLibrary = new CoreLibrary(this);
            this.coreLibrary.initialize();
            this.symbolTable = new SymbolTable(this.coreLibrary.getSymbolFactory());
            this.nativePlatform = NativePlatformFactory.createPlatform(this);
            this.rootLexicalScope = new LexicalScope(null, this.coreLibrary.getObjectClass());
            this.coreLibrary.initializeEncodingManager();
            this.threadManager = new ThreadManager(this);
            this.threadManager.initialize();
            Main.printTruffleTimeMetric("before-load-nodes");
            this.coreLibrary.addCoreMethods(this.primitiveManager);
            Main.printTruffleTimeMetric("after-load-nodes");
            Instrumenter instrumenter = (Instrumenter)env.lookup(Instrumenter.class);
            this.traceManager = new TraceManager(this, instrumenter);
            this.coreMethods = new CoreMethods(this);
            this.coverageManager = new CoverageManager(this, instrumenter);
            this.coreLibrary.loadRubyCore();
            PrintStream configStandardOut = System.out;
            PrintStream printStream = this.debugStandardOut = configStandardOut == System.out ? null : configStandardOut;
            if (!TruffleOptions.AOT && this.options.INSTRUMENTATION_SERVER_PORT != 0) {
                this.instrumentationServerManager = new InstrumentationServerManager(this, this.options.INSTRUMENTATION_SERVER_PORT);
                this.instrumentationServerManager.start();
            } else {
                this.instrumentationServerManager = null;
            }
            this.coreLibrary.initializePostBoot();
            this.consoleHolder = new ConsoleHolder();
            if (this.options.SHARED_OBJECTS_ENABLED && this.options.SHARED_OBJECTS_FORCE) {
                this.sharedObjects.startSharing();
            }
        }
        finally {
            contextsBeingCreated.remove();
        }
    }

    private String findRubyHome() {
        String jrubyHome;
        CodeSource codeSource;
        if (this.options.HOME != null) {
            return new File(this.options.HOME).getAbsolutePath();
        }
        if (!TruffleOptions.AOT && (codeSource = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource()) != null && codeSource.getLocation().getProtocol().equals("file")) {
            File jar = new File(codeSource.getLocation().getFile());
            if (jar.getParentFile().getName().equals("lib")) {
                return jar.getParentFile().getParentFile().getAbsolutePath();
            }
            if (jar.getParentFile().getName().equals("ruby") && new File(jar.getParentFile(), "lib").exists()) {
                return jar.getParentFile().getAbsolutePath();
            }
            if (jar.getParentFile().getName().equals("dists") && jar.getParentFile().getParentFile().getName().equals("mxbuild")) {
                return new File(jar.getParentFile().getParentFile(), "ruby-zip-extracted").getAbsolutePath();
            }
        }
        if ((jrubyHome = System.getProperty("jruby.home")) != null) {
            return new File(jrubyHome).getAbsolutePath();
        }
        Log.LOGGER.config("home not explicitly set, and couldn't determine it from the source of the Java classfiles or the JRuby launcher");
        return null;
    }

    public Object send(Object object, String methodName, DynamicObject block, Object ... arguments) {
        CompilerAsserts.neverPartOfCompilation();
        assert (block == null || RubyGuards.isRubyProc(block));
        InternalMethod method = ModuleOperations.lookupMethod(this.coreLibrary.getMetaClass(object), methodName);
        if (method == null || method.isUndefined()) {
            return null;
        }
        return method.getCallTarget().call(RubyArguments.pack(null, null, method, DeclarationContext.METHOD, null, object, block, arguments));
    }

    public void shutdown() {
        if (this.options.ROPE_PRINT_INTERN_STATS) {
            System.out.println("Ropes re-used: " + this.getRopeTable().getRopesReusedCount());
            System.out.println("Rope byte arrays re-used: " + this.getRopeTable().getByteArrayReusedCount());
            System.out.println("Rope bytes saved: " + this.getRopeTable().getRopeBytesSaved());
            System.out.println("Total ropes interned: " + this.getRopeTable().totalRopes());
        }
        this.atExitManager.runSystemExitHooks();
        if (this.instrumentationServerManager != null) {
            this.instrumentationServerManager.shutdown();
        }
        this.threadManager.shutdown();
        if (this.options.COVERAGE_GLOBAL) {
            this.coverageManager.print(System.out);
        }
        if (this.callGraph != null) {
            this.callGraph.resolve();
            if (this.options.CALL_GRAPH_WRITE != null) {
                try (PrintStream stream = new PrintStream(this.options.CALL_GRAPH_WRITE, StandardCharsets.UTF_8.name());){
                    new SimpleWriter(this.callGraph, stream).write();
                }
                catch (FileNotFoundException | UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public TruffleLanguage.Env getEnv() {
        return this.env;
    }

    public NativePlatform getNativePlatform() {
        return this.nativePlatform;
    }

    public CoreLibrary getCoreLibrary() {
        return this.coreLibrary;
    }

    public CoreMethods getCoreMethods() {
        return this.coreMethods;
    }

    public PrintStream getDebugStandardOut() {
        return this.debugStandardOut;
    }

    public FeatureLoader getFeatureLoader() {
        return this.featureLoader;
    }

    public ObjectSpaceManager getObjectSpaceManager() {
        return this.objectSpaceManager;
    }

    public SharedObjects getSharedObjects() {
        return this.sharedObjects;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public AtExitManager getAtExitManager() {
        return this.atExitManager;
    }

    public TraceManager getTraceManager() {
        return this.traceManager;
    }

    public SafepointManager getSafepointManager() {
        return this.safepointManager;
    }

    public LexicalScope getRootLexicalScope() {
        return this.rootLexicalScope;
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public PrimitiveManager getPrimitiveManager() {
        return this.primitiveManager;
    }

    public CoverageManager getCoverageManager() {
        return this.coverageManager;
    }

    public static RubyContext getInstance() {
        try {
            return RubyLanguage.INSTANCE.unprotectedFindContext(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
        }
        catch (IllegalStateException e) {
            return contextsBeingCreated.get();
        }
    }

    public SourceLoader getSourceLoader() {
        return this.sourceLoader;
    }

    public RopeTable getRopeTable() {
        return this.ropeTable;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public CodeLoader getCodeLoader() {
        return this.codeLoader;
    }

    public InteropManager getInteropManager() {
        return this.interopManager;
    }

    public CallStackManager getCallStack() {
        return this.callStack;
    }

    public CoreStrings getCoreStrings() {
        return this.coreStrings;
    }

    public FrozenStrings getFrozenStrings() {
        return this.frozenStrings;
    }

    public Object getClassVariableDefinitionLock() {
        return this.classVariableDefinitionLock;
    }

    public Instrumenter getInstrumenter() {
        return (Instrumenter)this.env.lookup(Instrumenter.class);
    }

    public CoreExceptions getCoreExceptions() {
        return this.coreExceptions;
    }

    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(String currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public void setOriginalInputFile(String originalInputFile) {
        this.originalInputFile = originalInputFile;
    }

    public String getOriginalInputFile() {
        return this.originalInputFile;
    }

    public String getRubyHome() {
        return this.rubyHome;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVerboseNil() {
        this.verbose = false;
    }

    public boolean warningsEnabled() {
        return this.verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public InputStream getSyntaxCheckInputStream() {
        return this.syntaxCheckInputStream;
    }

    public void setSyntaxCheckInputStream(InputStream syntaxCheckInputStream) {
        this.syntaxCheckInputStream = syntaxCheckInputStream;
    }

    public ConsoleHolder getConsoleHolder() {
        return this.consoleHolder;
    }
}

