/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.util;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Iterator;

public class BoundaryUtils {

    public static final class BoundaryIterator<E>
    implements Iterator<E> {
        private final Iterator<E> iterator;

        public BoundaryIterator(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public E next() {
            return this.iterator.next();
        }
    }

    public static final class BoundaryIterable<E>
    implements Iterable<E> {
        private final Iterable<E> iterable;

        public static <E> BoundaryIterable<E> wrap(Iterable<E> iterable) {
            return new BoundaryIterable<E>(iterable);
        }

        public BoundaryIterable(Iterable<E> iterable) {
            this.iterable = iterable;
        }

        @Override
        public BoundaryIterator<E> iterator() {
            return new BoundaryIterator<E>(this.getIterator());
        }

        @CompilerDirectives.TruffleBoundary
        private Iterator<E> getIterator() {
            return this.iterable.iterator();
        }
    }
}

