/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.RescueBodyParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class RescueParseNode
extends ParseNode {
    private final ParseNode bodyNode;
    private final RescueBodyParseNode rescueNode;
    private final ParseNode elseNode;

    public RescueParseNode(ISourcePosition position, ParseNode bodyNode, RescueBodyParseNode rescueNode, ParseNode elseNode) {
        super(position, bodyNode != null && bodyNode.containsVariableAssignment() || rescueNode != null && rescueNode.containsVariableAssignment() || elseNode != null && elseNode.containsVariableAssignment());
        this.bodyNode = bodyNode;
        this.rescueNode = rescueNode;
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RESCUENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitRescueNode(this);
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public ParseNode getElseNode() {
        return this.elseNode;
    }

    public RescueBodyParseNode getRescueNode() {
        return this.rescueNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList((ParseNode)this.rescueNode, this.bodyNode, this.elseNode);
    }
}

