/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.globals.ReadThreadLocalGlobalVariableNode;

public class UpdateLastBacktraceNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    @Node.Child
    private ReadThreadLocalGlobalVariableNode getLastExceptionNode;
    @Node.Child
    private CallDispatchHeadNode setBacktraceNode;
    private final BranchProfile lastExceptionNilProfile = BranchProfile.create();

    public UpdateLastBacktraceNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
        super(context, sourceSection);
        this.child = child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object lastException = this.getGetLastExceptionNode().execute(frame);
        if (lastException == this.nil()) {
            this.lastExceptionNilProfile.enter();
            throw new RaiseException(this.coreExceptions().argumentError("$! is not set", this));
        }
        Object newBacktrace = this.child.execute(frame);
        this.getSetBacktraceNode().call(frame, lastException, "set_backtrace", newBacktrace);
        return newBacktrace;
    }

    private ReadThreadLocalGlobalVariableNode getGetLastExceptionNode() {
        if (this.getLastExceptionNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getLastExceptionNode = (ReadThreadLocalGlobalVariableNode)this.insert(new ReadThreadLocalGlobalVariableNode(this.getContext(), null, "$!", true));
        }
        return this.getLastExceptionNode;
    }

    private CallDispatchHeadNode getSetBacktraceNode() {
        if (this.setBacktraceNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setBacktraceNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        return this.setBacktraceNode;
    }
}

