/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.cast.BooleanCastNode;
import org.jruby.truffle.core.cast.BooleanCastNodeGen;
import org.jruby.truffle.core.cast.ProcOrNullNode;
import org.jruby.truffle.core.cast.ProcOrNullNodeGen;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.DispatchNode;
import org.jruby.truffle.language.dispatch.MissingBehavior;
import org.jruby.truffle.language.dispatch.RubyCallNodeParameters;
import org.jruby.truffle.language.methods.InternalMethod;

public class RubyCallNode
extends RubyNode {
    private final String methodName;
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private ProcOrNullNode block;
    @Node.Children
    private final RubyNode[] arguments;
    private final boolean isSplatted;
    private final boolean ignoreVisibility;
    private final boolean isVCall;
    private final boolean isSafeNavigation;
    private final boolean isAttrAssign;
    @Node.Child
    private CallDispatchHeadNode dispatchHead;
    @CompilerDirectives.CompilationFinal
    private boolean seenNullInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenIntegerFixnumInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenLongFixnumInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenFloatInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenObjectInUnsplat = false;
    @Node.Child
    private CallDispatchHeadNode respondToMissing;
    @Node.Child
    private BooleanCastNode respondToMissingCast;
    private final ConditionProfile nilProfile;

    public RubyCallNode(RubyCallNodeParameters parameters) {
        super(parameters.getContext(), parameters.getSection());
        this.methodName = parameters.getMethodName();
        this.receiver = parameters.getReceiver();
        this.arguments = parameters.getArguments();
        this.block = parameters.getBlock() == null ? null : ProcOrNullNodeGen.create(parameters.getContext(), parameters.getSection(), parameters.getBlock());
        this.isSplatted = parameters.isSplatted();
        this.ignoreVisibility = parameters.isIgnoreVisibility();
        this.isVCall = parameters.isVCall();
        this.isSafeNavigation = parameters.isSafeNavigation();
        this.isAttrAssign = parameters.isAttrAssign();
        this.nilProfile = parameters.isSafeNavigation() ? ConditionProfile.createCountingProfile() : null;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        if (this.isSafeNavigation && this.nilProfile.profile(receiverObject == this.nil())) {
            return this.nil();
        }
        Object[] argumentsObjects = this.executeArguments(frame);
        return this.executeWithArgumentsEvaluated(frame, receiverObject, argumentsObjects);
    }

    public Object executeWithArgumentsEvaluated(VirtualFrame frame, Object receiverObject, Object[] argumentsObjects) {
        DynamicObject blockObject = this.executeBlock(frame);
        if (this.dispatchHead == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.dispatchHead = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), this.ignoreVisibility));
        }
        Object returnValue = this.dispatchHead.dispatch(frame, receiverObject, this.methodName, blockObject, argumentsObjects);
        if (this.isAttrAssign) {
            return argumentsObjects[argumentsObjects.length - 1];
        }
        return returnValue;
    }

    private DynamicObject executeBlock(VirtualFrame frame) {
        if (this.block != null) {
            return (DynamicObject)this.block.execute(frame);
        }
        return null;
    }

    @ExplodeLoop
    private Object[] executeArguments(VirtualFrame frame) {
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        if (this.isSplatted) {
            return this.splat(argumentsObjects[0]);
        }
        return argumentsObjects;
    }

    private Object[] splat(Object argument) {
        if (!RubyGuards.isRubyArray(argument)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedOperationException(argument.getClass().toString());
        }
        DynamicObject array = (DynamicObject)argument;
        int size = Layouts.ARRAY.getSize(array);
        Object store = Layouts.ARRAY.getStore(array);
        if (this.seenNullInUnsplat && store == null) {
            return new Object[0];
        }
        if (this.seenIntegerFixnumInUnsplat && store instanceof int[]) {
            return ArrayUtils.boxUntil((int[])store, size);
        }
        if (this.seenLongFixnumInUnsplat && store instanceof long[]) {
            return ArrayUtils.boxUntil((long[])store, size);
        }
        if (this.seenFloatInUnsplat && store instanceof double[]) {
            return ArrayUtils.boxUntil((double[])store, size);
        }
        if (this.seenObjectInUnsplat && store != null && store.getClass() == Object[].class) {
            return ArrayUtils.extractRange((Object[])store, 0, size);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (store == null) {
            this.seenNullInUnsplat = true;
            return new Object[0];
        }
        if (store instanceof int[]) {
            this.seenIntegerFixnumInUnsplat = true;
            return ArrayUtils.boxUntil((int[])store, size);
        }
        if (store instanceof long[]) {
            this.seenLongFixnumInUnsplat = true;
            return ArrayUtils.boxUntil((long[])store, size);
        }
        if (store instanceof double[]) {
            this.seenFloatInUnsplat = true;
            return ArrayUtils.boxUntil((double[])store, size);
        }
        if (store.getClass() == Object[].class) {
            this.seenObjectInUnsplat = true;
            return ArrayUtils.extractRange((Object[])store, 0, size);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object receiverObject;
        if (this.receiver.isDefined(frame) == this.nil()) {
            return this.nil();
        }
        for (RubyNode argument : this.arguments) {
            if (argument.isDefined(frame) != this.nil()) continue;
            return this.nil();
        }
        try {
            receiverObject = this.receiver.execute(frame);
        }
        catch (Exception e) {
            return this.nil();
        }
        InternalMethod method = ModuleOperations.lookupMethod(this.coreLibrary().getMetaClass(receiverObject), this.methodName);
        Object self = RubyArguments.getSelf((Frame)frame);
        if (method == null) {
            Object r = this.respondToMissing(frame, receiverObject);
            if (r != DispatchNode.MISSING && !this.castRespondToMissingToBoolean(frame, r)) {
                return this.nil();
            }
        } else {
            if (method.isUndefined()) {
                return this.nil();
            }
            if (!this.ignoreVisibility && !method.isVisibleTo(this.coreLibrary().getMetaClass(self))) {
                return this.nil();
            }
        }
        return this.create7BitString("method", (Encoding)UTF8Encoding.INSTANCE);
    }

    private Object respondToMissing(VirtualFrame frame, Object receiverObject) {
        if (this.respondToMissing == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.respondToMissing = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true, MissingBehavior.RETURN_MISSING));
        }
        DynamicObject method = this.getContext().getSymbolTable().getSymbol(this.methodName);
        return this.respondToMissing.call(frame, receiverObject, "respond_to_missing?", method, false);
    }

    private boolean castRespondToMissingToBoolean(VirtualFrame frame, Object r) {
        if (this.respondToMissingCast == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.respondToMissingCast = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(null));
        }
        return this.respondToMissingCast.executeBoolean(frame, r);
    }

    public String getName() {
        return this.methodName;
    }

    public boolean isVCall() {
        return this.isVCall;
    }
}

