/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;

public class RubySourceSection {
    private final int startLine;
    private final int endLine;

    public RubySourceSection(SourceSection sourceSection) {
        this.startLine = sourceSection.getStartLine();
        if (sourceSection.getSource() == null) {
            this.endLine = this.startLine;
        } else {
            int endLineValue;
            try {
                endLineValue = sourceSection.getEndLine();
            }
            catch (IllegalArgumentException e) {
                endLineValue = this.startLine;
            }
            this.endLine = endLineValue;
        }
    }

    public RubySourceSection(int startLine) {
        this(startLine, startLine);
    }

    public RubySourceSection(int startLine, int endLine) {
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public SourceSection toSourceSection(Source source) {
        if (source == null) {
            throw new UnsupportedOperationException();
        }
        int index = source.getLineStartOffset(this.startLine);
        int length = 0;
        for (int n = this.startLine; n <= this.endLine; ++n) {
            length += source.getLineLength(n) + 1;
        }
        length = Math.min(length, source.getLength() - index);
        length = Math.max(0, length);
        return source.createSection(index, length);
    }
}

