/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;
import jnr.ffi.provider.MemoryManager;
import org.jcodings.Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.exception.CoreExceptions;
import org.jruby.truffle.core.kernel.TraceManager;
import org.jruby.truffle.core.numeric.BignumOperations;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.CoreStrings;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.extra.AttachmentsManager;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.platform.posix.Sockets;
import org.jruby.truffle.platform.posix.TrufflePosix;
import org.jruby.truffle.stdlib.CoverageManager;
import org.jruby.util.ByteList;

@ImportStatic(value={RubyGuards.class})
@TypeSystemReference(value=RubyTypes.class)
public abstract class RubyBaseNode
extends Node {
    private static final int FLAG_NEWLINE = 0;
    private static final int FLAG_CALL = 1;
    private static final int FLAG_ROOT = 2;
    @CompilerDirectives.CompilationFinal
    private RubyContext context;
    private int sourceStartLine;
    private int sourceEndLine;
    private int flags;

    public RubyBaseNode() {
    }

    public RubyBaseNode(RubyContext context) {
        this.context = context;
    }

    public RubyBaseNode(SourceSection sourceSection) {
        if (sourceSection != null) {
            this.unsafeSetSourceSection(new RubySourceSection(sourceSection));
        }
    }

    public RubyBaseNode(RubySourceSection sourceSection) {
        if (sourceSection != null) {
            this.unsafeSetSourceSection(sourceSection);
        }
    }

    public RubyBaseNode(RubyContext context, SourceSection sourceSection) {
        this.context = context;
        if (sourceSection != null) {
            this.unsafeSetSourceSection(new RubySourceSection(sourceSection));
        }
    }

    public RubyBaseNode(RubyContext context, RubySourceSection sourceSection) {
        this.context = context;
        if (sourceSection != null) {
            this.unsafeSetSourceSection(sourceSection);
        }
    }

    protected boolean isNil(Object value) {
        return value == this.nil();
    }

    protected boolean isRubiniusUndefined(Object value) {
        return value == this.coreLibrary().getRubiniusUndefined();
    }

    protected DynamicObject nil() {
        return this.coreLibrary().getNilObject();
    }

    protected DynamicObject getSymbol(String name) {
        return this.getContext().getSymbolTable().getSymbol(name);
    }

    protected DynamicObject getSymbol(Rope name) {
        return this.getContext().getSymbolTable().getSymbol(name);
    }

    protected DynamicObject createString(ByteList bytes) {
        return StringOperations.createString(this.getContext(), bytes);
    }

    protected DynamicObject createString(byte[] bytes, Encoding encoding) {
        return StringOperations.createString(this.getContext(), RopeOperations.create(bytes, encoding, CodeRange.CR_7BIT));
    }

    protected DynamicObject create7BitString(CharSequence value, Encoding encoding) {
        return StringOperations.createString(this.getContext(), StringOperations.encodeRope(value, encoding, CodeRange.CR_7BIT));
    }

    protected DynamicObject createString(Rope rope) {
        return StringOperations.createString(this.getContext(), rope);
    }

    protected DynamicObject createArray(Object store, int size) {
        return ArrayHelpers.createArray(this.getContext(), store, size);
    }

    protected DynamicObject createBignum(BigInteger value) {
        return BignumOperations.createBignum(this.getContext(), value);
    }

    protected CoreStrings coreStrings() {
        return this.getContext().getCoreStrings();
    }

    protected CoreLibrary coreLibrary() {
        return this.getContext().getCoreLibrary();
    }

    protected CoreExceptions coreExceptions() {
        return this.getContext().getCoreExceptions();
    }

    protected TrufflePosix posix() {
        return this.getContext().getNativePlatform().getPosix();
    }

    protected Sockets nativeSockets() {
        return this.getContext().getNativePlatform().getSockets();
    }

    protected MemoryManager memoryManager() {
        return this.getContext().getNativePlatform().getMemoryManager();
    }

    protected DynamicObject handle(Object object) {
        return Layouts.HANDLE.createHandle(this.coreLibrary().getHandleFactory(), object);
    }

    public RubyContext getContext() {
        if (this.context == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Node parent = this.getParent();
            while (true) {
                if (parent == null) {
                    System.err.println("warning: using global context!");
                    this.context = RubyContext.getLatestInstance();
                    break;
                }
                if (parent instanceof RubyBaseNode) {
                    this.context = ((RubyBaseNode)parent).getContext();
                    break;
                }
                if (parent instanceof RubyRootNode) {
                    this.context = ((RubyRootNode)parent).getContext();
                    break;
                }
                parent = parent.getParent();
            }
        }
        return this.context;
    }

    public void unsafeSetSourceSection(RubySourceSection sourceSection) {
        assert (this.sourceStartLine == 0);
        this.sourceStartLine = sourceSection.getStartLine();
        this.sourceEndLine = sourceSection.getEndLine();
    }

    public RubySourceSection getRubySourceSection() {
        if (this.sourceStartLine == 0) {
            return null;
        }
        return new RubySourceSection(this.sourceStartLine, this.sourceEndLine);
    }

    public RubySourceSection getEncapsulatingRubySourceSection() {
        for (RubyBaseNode node = this; node != null; node = node.getParent()) {
            if (node instanceof RubyBaseNode && node.sourceStartLine != 0) {
                return node.getRubySourceSection();
            }
            if (!(node instanceof RootNode)) continue;
            return new RubySourceSection(node.getSourceSection());
        }
        return null;
    }

    public SourceSection getSourceSection() {
        if (this.sourceStartLine == 0) {
            return null;
        }
        return this.getRubySourceSection().toSourceSection(this.getRootNode().getSourceSection().getSource());
    }

    public void unsafeSetIsNewLine() {
        this.flags |= 1;
    }

    public void unsafeSetIsCall() {
        this.flags |= 2;
    }

    public void unsafeSetIsRoot() {
        this.flags |= 4;
    }

    private boolean isNewLine() {
        return (this.flags >> 0 & 1) == 1;
    }

    private boolean isCall() {
        return (this.flags >> 1 & 1) == 1;
    }

    private boolean isRoot() {
        return (this.flags >> 2 & 1) == 1;
    }

    protected boolean isTaggedWith(Class<?> tag) {
        if (tag == TraceManager.CallTag.class || tag == StandardTags.CallTag.class) {
            return this.isCall();
        }
        if (tag == AttachmentsManager.LineTag.class || tag == TraceManager.LineTag.class || tag == CoverageManager.LineTag.class || tag == StandardTags.StatementTag.class) {
            return this.isNewLine();
        }
        if (tag == StandardTags.RootTag.class) {
            return this.isRoot();
        }
        return false;
    }
}

