/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringLayout;

@GeneratedBy(value=StringLayout.class)
public class StringLayoutImpl
extends BasicObjectLayoutImpl
implements StringLayout {
    public static final StringLayout INSTANCE = new StringLayoutImpl();
    protected static final Shape.Allocator STRING_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ROPE_IDENTIFIER = new HiddenKey("rope");
    protected static final Property ROPE_PROPERTY = Property.create((Object)ROPE_IDENTIFIER, (Location)STRING_ALLOCATOR.locationForType(Rope.class, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected StringLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createStringShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new StringType(logicalClass, metaClass)).addProperty(ROPE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createString(DynamicObjectFactory factory, Rope rope) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsString(factory));
        assert (factory.getShape().hasProperty((Object)ROPE_IDENTIFIER));
        assert (rope != null);
        return factory.newInstance(new Object[]{rope});
    }

    @Override
    public boolean isString(Object object) {
        return object instanceof DynamicObject && this.isString((DynamicObject)object);
    }

    @Override
    public boolean isString(DynamicObject object) {
        return this.isString(object.getShape().getObjectType());
    }

    @Override
    public boolean isString(ObjectType objectType) {
        return objectType instanceof StringType;
    }

    private boolean createsString(DynamicObjectFactory factory) {
        return this.isString(factory.getShape().getObjectType());
    }

    @Override
    public Rope getRope(DynamicObject object) {
        assert (this.isString(object));
        assert (object.getShape().hasProperty((Object)ROPE_IDENTIFIER));
        return (Rope)ROPE_PROPERTY.get(object, this.isString(object));
    }

    @Override
    public void setRope(DynamicObject object, Rope value) {
        assert (this.isString(object));
        assert (object.getShape().hasProperty((Object)ROPE_IDENTIFIER));
        assert (value != null);
        try {
            ROPE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class StringType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public StringType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public StringType setLogicalClass(DynamicObject logicalClass) {
            return new StringType(logicalClass, this.metaClass);
        }

        @Override
        public StringType setMetaClass(DynamicObject metaClass) {
            return new StringType(this.logicalClass, metaClass);
        }
    }
}

