/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.queue;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.core.queue.ArrayBlockingQueueLocksConditions;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.AllocateObjectNode;

@CoreClass(value="SizedQueue")
public abstract class SizedQueueNodes {

    @CoreMethod(names={"num_waiting"})
    public static abstract class NumWaitingNode
    extends CoreMethodArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public int num_waiting(DynamicObject self) {
            ArrayBlockingQueueLocksConditions<Object> queue = Layouts.SIZED_QUEUE.getQueue(self);
            final ReentrantLock lock = queue.getLock();
            this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    lock.lockInterruptibly();
                    return true;
                }
            });
            try {
                int n = lock.getWaitQueueLength(queue.getNotEmptyCondition()) + lock.getWaitQueueLength(queue.getNotFullCondition());
                return n;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @CoreMethod(names={"clear"})
    public static abstract class ClearNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject clear(DynamicObject self) {
            ArrayBlockingQueueLocksConditions<Object> queue = Layouts.SIZED_QUEUE.getQueue(self);
            queue.clear();
            return self;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int size(DynamicObject self) {
            ArrayBlockingQueueLocksConditions<Object> queue = Layouts.SIZED_QUEUE.getQueue(self);
            return queue.size();
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean empty(DynamicObject self) {
            ArrayBlockingQueueLocksConditions<Object> queue = Layouts.SIZED_QUEUE.getQueue(self);
            return queue.isEmpty();
        }
    }

    @CoreMethod(names={"pop", "shift", "deq"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="queue"), @NodeChild(type=RubyNode.class, value="nonBlocking")})
    public static abstract class PopNode
    extends CoreMethodNode {
        @CreateCast(value={"nonBlocking"})
        public RubyNode coerceToBoolean(RubyNode nonBlocking) {
            return BooleanCastWithDefaultNodeGen.create(false, nonBlocking);
        }

        @Specialization(guards={"!nonBlocking"})
        public Object popBlocking(DynamicObject self, boolean nonBlocking) {
            ArrayBlockingQueueLocksConditions<Object> queue = Layouts.SIZED_QUEUE.getQueue(self);
            return this.doPop(queue);
        }

        @CompilerDirectives.TruffleBoundary
        private Object doPop(BlockingQueue<Object> queue) {
            return this.getContext().getThreadManager().runUntilResult(this, () -> queue.take());
        }

        @Specialization(guards={"nonBlocking"})
        public Object popNonBlock(DynamicObject self, boolean nonBlocking, @Cached(value="create()") BranchProfile errorProfile) {
            ArrayBlockingQueueLocksConditions<Object> queue = Layouts.SIZED_QUEUE.getQueue(self);
            Object value = this.doPoll(queue);
            if (value == null) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().threadError("queue empty", this));
            }
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        private Object doPoll(BlockingQueue<Object> queue) {
            return queue.poll();
        }
    }

    @CoreMethod(names={"push", "<<", "enq"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="queue"), @NodeChild(type=RubyNode.class, value="value"), @NodeChild(type=RubyNode.class, value="nonBlocking")})
    public static abstract class PushNode
    extends CoreMethodNode {
        @CreateCast(value={"nonBlocking"})
        public RubyNode coerceToBoolean(RubyNode nonBlocking) {
            return BooleanCastWithDefaultNodeGen.create(false, nonBlocking);
        }

        @Specialization(guards={"!nonBlocking"})
        public DynamicObject pushBlocking(DynamicObject self, Object value, boolean nonBlocking) {
            ArrayBlockingQueueLocksConditions<Object> queue = Layouts.SIZED_QUEUE.getQueue(self);
            this.doPushBlocking(value, queue);
            return self;
        }

        @CompilerDirectives.TruffleBoundary
        private void doPushBlocking(final Object value, final BlockingQueue<Object> queue) {
            this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Boolean>(){

                @Override
                public Boolean block() throws InterruptedException {
                    queue.put(value);
                    return true;
                }
            });
        }

        @Specialization(guards={"nonBlocking"})
        public DynamicObject pushNonBlock(DynamicObject self, Object value, boolean nonBlocking, @Cached(value="create()") BranchProfile errorProfile) {
            ArrayBlockingQueueLocksConditions<Object> queue = Layouts.SIZED_QUEUE.getQueue(self);
            boolean pushed = this.doOffer(value, queue);
            if (!pushed) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().threadError("queue full", this));
            }
            return self;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean doOffer(Object value, BlockingQueue<Object> queue) {
            return queue.offer(value);
        }
    }

    @CoreMethod(names={"max"})
    public static abstract class MaxNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int max(DynamicObject self) {
            ArrayBlockingQueueLocksConditions<Object> queue = Layouts.SIZED_QUEUE.getQueue(self);
            return queue.size() + queue.remainingCapacity();
        }
    }

    @CoreMethod(names={"max="}, required=1)
    public static abstract class SetMaxNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int setMax(DynamicObject self, int newCapacity) {
            Object element;
            if (newCapacity <= 0) {
                throw new RaiseException(this.coreExceptions().argumentError("queue size must be positive", this));
            }
            ArrayBlockingQueueLocksConditions<Object> oldQueue = Layouts.SIZED_QUEUE.getQueue(self);
            ArrayBlockingQueueLocksConditions<Object> newQueue = this.getContext().getNativePlatform().createArrayBlockingQueueLocksConditions(newCapacity);
            while ((element = oldQueue.poll()) != null) {
                newQueue.add(element);
            }
            Layouts.SIZED_QUEUE.setQueue(self, newQueue);
            return newCapacity;
        }
    }

    @CoreMethod(names={"initialize"}, visibility=Visibility.PRIVATE, required=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject initialize(DynamicObject self, int capacity) {
            if (capacity <= 0) {
                throw new RaiseException(this.coreExceptions().argumentError("queue size must be positive", this));
            }
            ArrayBlockingQueueLocksConditions<Object> blockingQueue = this.getContext().getNativePlatform().createArrayBlockingQueueLocksConditions(capacity);
            Layouts.SIZED_QUEUE.setQueue(self, blockingQueue);
            return self;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            Object queue = null;
            return this.allocateNode.allocate(rubyClass, queue);
        }
    }
}

