/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.pack;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.RootNode;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatErrorListener;
import org.jruby.truffle.core.format.FormatRootNode;
import org.jruby.truffle.core.format.LoopRecovery;
import org.jruby.truffle.core.format.pack.PackLexer;
import org.jruby.truffle.core.format.pack.PackParser;
import org.jruby.truffle.core.format.pack.PackTreeBuilder;
import org.jruby.truffle.language.RubyNode;

public class PackCompiler {
    private final RubyContext context;
    private final RubyNode currentNode;

    public PackCompiler(RubyContext context, RubyNode currentNode) {
        this.context = context;
        this.currentNode = currentNode;
    }

    public CallTarget compile(String format) {
        if (format.length() > this.context.getOptions().PACK_RECOVER_LOOP_MIN) {
            format = LoopRecovery.recoverLoop(format);
        }
        FormatErrorListener errorListener = new FormatErrorListener(this.context, this.currentNode);
        ANTLRInputStream input = new ANTLRInputStream(format);
        PackLexer lexer = new PackLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PackParser parser = new PackParser((TokenStream)tokens);
        PackTreeBuilder builder = new PackTreeBuilder(this.context, this.currentNode);
        parser.addParseListener(builder);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        parser.sequence();
        return Truffle.getRuntime().createCallTarget((RootNode)new FormatRootNode(this.currentNode.getEncapsulatingSourceSection(), builder.getEncoding(), builder.getNode()));
    }
}

