/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.MathNodes;
import org.jruby.truffle.core.cast.ToFNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=MathNodes.class)
public final class MathNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(ACosNodeFactory.getInstance(), ACosHNodeFactory.getInstance(), ASinNodeFactory.getInstance(), ASinHNodeFactory.getInstance(), ATanNodeFactory.getInstance(), ATan2NodeFactory.getInstance(), ATanHNodeFactory.getInstance(), CbRtNodeFactory.getInstance(), CosNodeFactory.getInstance(), CosHNodeFactory.getInstance(), ErfNodeFactory.getInstance(), ErfcNodeFactory.getInstance(), ExpNodeFactory.getInstance(), FrExpNodeFactory.getInstance(), GammaNodeFactory.getInstance(), HypotNodeFactory.getInstance(), LdexpNodeFactory.getInstance(), LGammaNodeFactory.getInstance(), LogNodeFactory.getInstance(), Log10NodeFactory.getInstance(), Log2NodeFactory.getInstance(), SinNodeFactory.getInstance(), SinHNodeFactory.getInstance(), TanNodeFactory.getInstance(), TanHNodeFactory.getInstance(), SqrtNodeFactory.getInstance(), SimpleMonadicMathNodeFactory.getInstance(), SimpleDyadicMathNodeFactory.getInstance());
    }

    @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
    protected static final class SimpleDyadicMathNodeFactory
    implements NodeFactory<MathNodes.SimpleDyadicMathNode> {
        private static SimpleDyadicMathNodeFactory simpleDyadicMathNodeFactoryInstance;

        private SimpleDyadicMathNodeFactory() {
        }

        public Class<MathNodes.SimpleDyadicMathNode> getNodeClass() {
            return MathNodes.SimpleDyadicMathNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class), Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public MathNodes.SimpleDyadicMathNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SimpleDyadicMathNodeFactory.create((RubyNode[])arguments[0]);
            }
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SimpleDyadicMathNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        protected static NodeFactory<MathNodes.SimpleDyadicMathNode> getInstance() {
            if (simpleDyadicMathNodeFactoryInstance == null) {
                simpleDyadicMathNodeFactoryInstance = new SimpleDyadicMathNodeFactory();
            }
            return simpleDyadicMathNodeFactoryInstance;
        }

        public static MathNodes.SimpleDyadicMathNode create(RubyNode[] arguments) {
            return new SimpleDyadicMathNodeGen(arguments);
        }

        public static MathNodes.SimpleDyadicMathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SimpleDyadicMathNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
        protected static final class SimpleDyadicMathNodeGen
        extends MathNodes.SimpleDyadicMathNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SimpleDyadicMathNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            private SimpleDyadicMathNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, Object)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(SimpleDyadicMathNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value, Object arguments1Value) {
                    return this.createNext(null, arguments0Value, arguments1Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_, arguments1Value_ = this.executeArguments1_((Frame)frameValue))) {
                        return this.root.function(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.guardFallback(arguments0Value, arguments1Value)) {
                        return this.root.function(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double, double)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function15Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function15Node_(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 16);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function15Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function15Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function15Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, DynamicObject)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function14Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function14Node_(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    super(root, 15);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function14Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    return new Function14Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(double, long)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function13Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function13Node_(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 14);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function13Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function13Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function13Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, int)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function12Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function12Node_(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 13);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function12Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function12Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function12Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, double)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function11Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function11Node_(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    super(root, 12);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function11Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    return new Function11Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, DynamicObject)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function10Node_
            extends BaseNode_ {
                Function10Node_(SimpleDyadicMathNodeGen root) {
                    super(root, 11);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new Function10Node_(root);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, long)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function9Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function9Node_(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    super(root, 10);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function9Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    return new Function9Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, int)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function8Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function8Node_(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    super(root, 9);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function8Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments1Value) {
                    return new Function8Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, double)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function7Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function7Node_(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function7Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function7Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function7Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, DynamicObject)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function6Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function6Node_(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function6Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    return new Function6Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, long)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function5Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function5Node_(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function5Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function5Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function5Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, int)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function4Node_(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function4Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function4Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function4Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, double)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function3Node_(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function3Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function3Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, DynamicObject)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function2Node_(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value) {
                    return new Function2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, long)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function1Node_(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, int)", value=MathNodes.SimpleDyadicMathNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function0Node_(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function0Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SimpleDyadicMathNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SimpleDyadicMathNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SimpleDyadicMathNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleDyadicMathNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SimpleDyadicMathNodeGen root;

                BaseNode_(SimpleDyadicMathNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SimpleDyadicMathNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function0Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Function2Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function3Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function4Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function5Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function6Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function7Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyTypesGen.isImplicitInteger(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function8Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function9Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_2 = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_2)) {
                                return Function10Node_.create(this.root);
                            }
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function11Node_.create(this.root, arguments1Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function12Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function13Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Function14Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function15Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments0Value_, arguments0ImplicitType);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments1Value_, arguments1ImplicitType);
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
    protected static final class SimpleMonadicMathNodeFactory
    implements NodeFactory<MathNodes.SimpleMonadicMathNode> {
        private static SimpleMonadicMathNodeFactory simpleMonadicMathNodeFactoryInstance;

        private SimpleMonadicMathNodeFactory() {
        }

        public Class<MathNodes.SimpleMonadicMathNode> getNodeClass() {
            return MathNodes.SimpleMonadicMathNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class), Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public MathNodes.SimpleMonadicMathNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SimpleMonadicMathNodeFactory.create((RubyNode[])arguments[0]);
            }
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SimpleMonadicMathNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        protected static NodeFactory<MathNodes.SimpleMonadicMathNode> getInstance() {
            if (simpleMonadicMathNodeFactoryInstance == null) {
                simpleMonadicMathNodeFactoryInstance = new SimpleMonadicMathNodeFactory();
            }
            return simpleMonadicMathNodeFactoryInstance;
        }

        public static MathNodes.SimpleMonadicMathNode create(RubyNode[] arguments) {
            return new SimpleMonadicMathNodeGen(arguments);
        }

        public static MathNodes.SimpleMonadicMathNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new SimpleMonadicMathNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
        protected static final class SimpleMonadicMathNodeGen
        extends MathNodes.SimpleMonadicMathNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SimpleMonadicMathNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            private SimpleMonadicMathNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.SimpleMonadicMathNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(SimpleMonadicMathNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.SimpleMonadicMathNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(SimpleMonadicMathNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.SimpleMonadicMathNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(SimpleMonadicMathNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.SimpleMonadicMathNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(SimpleMonadicMathNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.SimpleMonadicMathNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(SimpleMonadicMathNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SimpleMonadicMathNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SimpleMonadicMathNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SimpleMonadicMathNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SimpleMonadicMathNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SimpleMonadicMathNodeGen root;

                BaseNode_(SimpleMonadicMathNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SimpleMonadicMathNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.SqrtNode.class)
    public static final class SqrtNodeFactory
    implements NodeFactory<MathNodes.SqrtNode> {
        private static SqrtNodeFactory sqrtNodeFactoryInstance;

        private SqrtNodeFactory() {
        }

        public Class<MathNodes.SqrtNode> getNodeClass() {
            return MathNodes.SqrtNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.SqrtNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SqrtNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.SqrtNode> getInstance() {
            if (sqrtNodeFactoryInstance == null) {
                sqrtNodeFactoryInstance = new SqrtNodeFactory();
            }
            return sqrtNodeFactoryInstance;
        }

        public static MathNodes.SqrtNode create(RubyNode[] arguments) {
            return new SqrtNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.SqrtNode.class)
        public static final class SqrtNodeGen
        extends MathNodes.SqrtNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SqrtNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.SqrtNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(SqrtNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.SqrtNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(SqrtNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.SqrtNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(SqrtNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.SqrtNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(SqrtNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.SqrtNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(SqrtNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.SqrtNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SqrtNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SqrtNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SqrtNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SqrtNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SqrtNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SqrtNodeGen root;

                BaseNode_(SqrtNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SqrtNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.TanHNode.class)
    public static final class TanHNodeFactory
    implements NodeFactory<MathNodes.TanHNode> {
        private static TanHNodeFactory tanHNodeFactoryInstance;

        private TanHNodeFactory() {
        }

        public Class<MathNodes.TanHNode> getNodeClass() {
            return MathNodes.TanHNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.TanHNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return TanHNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.TanHNode> getInstance() {
            if (tanHNodeFactoryInstance == null) {
                tanHNodeFactoryInstance = new TanHNodeFactory();
            }
            return tanHNodeFactoryInstance;
        }

        public static MathNodes.TanHNode create(RubyNode[] arguments) {
            return new TanHNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.TanHNode.class)
        public static final class TanHNodeGen
        extends MathNodes.TanHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private TanHNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.TanHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(TanHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.TanHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(TanHNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.TanHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(TanHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.TanHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(TanHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.TanHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(TanHNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.TanHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(TanHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.TanHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(TanHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(TanHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.TanHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected TanHNodeGen root;

                BaseNode_(TanHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (TanHNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.TanNode.class)
    public static final class TanNodeFactory
    implements NodeFactory<MathNodes.TanNode> {
        private static TanNodeFactory tanNodeFactoryInstance;

        private TanNodeFactory() {
        }

        public Class<MathNodes.TanNode> getNodeClass() {
            return MathNodes.TanNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.TanNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return TanNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.TanNode> getInstance() {
            if (tanNodeFactoryInstance == null) {
                tanNodeFactoryInstance = new TanNodeFactory();
            }
            return tanNodeFactoryInstance;
        }

        public static MathNodes.TanNode create(RubyNode[] arguments) {
            return new TanNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.TanNode.class)
        public static final class TanNodeGen
        extends MathNodes.TanNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private TanNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.TanNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(TanNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.TanNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(TanNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.TanNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(TanNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.TanNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(TanNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.TanNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(TanNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.TanNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(TanNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.TanNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(TanNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(TanNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.TanNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected TanNodeGen root;

                BaseNode_(TanNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (TanNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.SinHNode.class)
    public static final class SinHNodeFactory
    implements NodeFactory<MathNodes.SinHNode> {
        private static SinHNodeFactory sinHNodeFactoryInstance;

        private SinHNodeFactory() {
        }

        public Class<MathNodes.SinHNode> getNodeClass() {
            return MathNodes.SinHNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.SinHNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SinHNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.SinHNode> getInstance() {
            if (sinHNodeFactoryInstance == null) {
                sinHNodeFactoryInstance = new SinHNodeFactory();
            }
            return sinHNodeFactoryInstance;
        }

        public static MathNodes.SinHNode create(RubyNode[] arguments) {
            return new SinHNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.SinHNode.class)
        public static final class SinHNodeGen
        extends MathNodes.SinHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SinHNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.SinHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(SinHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.SinHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(SinHNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.SinHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(SinHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.SinHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(SinHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.SinHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(SinHNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.SinHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SinHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SinHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SinHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SinHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SinHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SinHNodeGen root;

                BaseNode_(SinHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SinHNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.SinNode.class)
    public static final class SinNodeFactory
    implements NodeFactory<MathNodes.SinNode> {
        private static SinNodeFactory sinNodeFactoryInstance;

        private SinNodeFactory() {
        }

        public Class<MathNodes.SinNode> getNodeClass() {
            return MathNodes.SinNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.SinNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SinNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.SinNode> getInstance() {
            if (sinNodeFactoryInstance == null) {
                sinNodeFactoryInstance = new SinNodeFactory();
            }
            return sinNodeFactoryInstance;
        }

        public static MathNodes.SinNode create(RubyNode[] arguments) {
            return new SinNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.SinNode.class)
        public static final class SinNodeGen
        extends MathNodes.SinNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SinNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.SinNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(SinNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.SinNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(SinNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.SinNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(SinNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.SinNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(SinNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.SinNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(SinNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.SinNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SinNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SinNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SinNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SinNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.SinNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SinNodeGen root;

                BaseNode_(SinNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (SinNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.Log2Node.class)
    public static final class Log2NodeFactory
    implements NodeFactory<MathNodes.Log2Node> {
        private static Log2NodeFactory log2NodeFactoryInstance;

        private Log2NodeFactory() {
        }

        public Class<MathNodes.Log2Node> getNodeClass() {
            return MathNodes.Log2Node.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.Log2Node createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return Log2NodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.Log2Node> getInstance() {
            if (log2NodeFactoryInstance == null) {
                log2NodeFactoryInstance = new Log2NodeFactory();
            }
            return log2NodeFactoryInstance;
        }

        public static MathNodes.Log2Node create(RubyNode[] arguments) {
            return new Log2NodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.Log2Node.class)
        public static final class Log2NodeGen
        extends MathNodes.Log2Node
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private Log2NodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.Log2Node.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(Log2NodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.Log2Node.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(Log2NodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.Log2Node.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(Log2NodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.Log2Node.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(Log2NodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.Log2Node.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(Log2NodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.Log2Node.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(Log2NodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.Log2Node.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(Log2NodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(Log2NodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.Log2Node.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected Log2NodeGen root;

                BaseNode_(Log2NodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (Log2NodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.Log10Node.class)
    public static final class Log10NodeFactory
    implements NodeFactory<MathNodes.Log10Node> {
        private static Log10NodeFactory log10NodeFactoryInstance;

        private Log10NodeFactory() {
        }

        public Class<MathNodes.Log10Node> getNodeClass() {
            return MathNodes.Log10Node.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.Log10Node createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return Log10NodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.Log10Node> getInstance() {
            if (log10NodeFactoryInstance == null) {
                log10NodeFactoryInstance = new Log10NodeFactory();
            }
            return log10NodeFactoryInstance;
        }

        public static MathNodes.Log10Node create(RubyNode[] arguments) {
            return new Log10NodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.Log10Node.class)
        public static final class Log10NodeGen
        extends MathNodes.Log10Node
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private Log10NodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.Log10Node.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(Log10NodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.Log10Node.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(Log10NodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.Log10Node.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(Log10NodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.Log10Node.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(Log10NodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.Log10Node.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(Log10NodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.Log10Node.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(Log10NodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.Log10Node.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(Log10NodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(Log10NodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.Log10Node.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected Log10NodeGen root;

                BaseNode_(Log10NodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (Log10NodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.LogNode.class)
    public static final class LogNodeFactory
    implements NodeFactory<MathNodes.LogNode> {
        private static LogNodeFactory logNodeFactoryInstance;

        private LogNodeFactory() {
        }

        public Class<MathNodes.LogNode> getNodeClass() {
            return MathNodes.LogNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.LogNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LogNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.LogNode> getInstance() {
            if (logNodeFactoryInstance == null) {
                logNodeFactoryInstance = new LogNodeFactory();
            }
            return logNodeFactoryInstance;
        }

        public static MathNodes.LogNode create(RubyNode[] arguments) {
            return new LogNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.LogNode.class)
        public static final class LogNodeGen
        extends MathNodes.LogNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LogNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, Object)", value=MathNodes.LogNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(LogNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value, Object arguments1Value) {
                    return this.createNext(null, arguments0Value, arguments1Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_, arguments1Value_ = this.executeArguments1_((Frame)frameValue))) {
                        return this.root.function(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.guardFallback(arguments0Value, arguments1Value)) {
                        return this.root.function(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, NotProvided, ToFNode)", value=MathNodes.LogNode.class)
            private static final class Function20Node_
            extends BaseNode_ {
                @Node.Child
                private ToFNode toFNode;

                Function20Node_(LogNodeGen root, ToFNode toFNode) {
                    super(root, 21);
                    this.toFNode = toFNode;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(frameValue, arguments0Value_, arguments1Value_, this.toFNode);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof NotProvided) {
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.function(frameValue, arguments0Value, arguments1Value_, this.toFNode);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, ToFNode toFNode) {
                    return new Function20Node_(root, toFNode);
                }
            }

            @GeneratedBy(methodName="function(double, NotProvided)", value=MathNodes.LogNode.class)
            private static final class Function19Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function19Node_(LogNodeGen root, Object arguments0Value) {
                    super(root, 20);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function19Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof NotProvided) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value) {
                    return new Function19Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, NotProvided)", value=MathNodes.LogNode.class)
            private static final class Function18Node_
            extends BaseNode_ {
                Function18Node_(LogNodeGen root) {
                    super(root, 19);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function18Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long, NotProvided)", value=MathNodes.LogNode.class)
            private static final class Function17Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function17Node_(LogNodeGen root, Object arguments0Value) {
                    super(root, 18);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function17Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof NotProvided) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value) {
                    return new Function17Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, NotProvided)", value=MathNodes.LogNode.class)
            private static final class Function16Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function16Node_(LogNodeGen root, Object arguments0Value) {
                    super(root, 17);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function16Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    NotProvided arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof NotProvided) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        NotProvided arguments1Value_ = (NotProvided)arguments1Value;
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value) {
                    return new Function16Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(double, double)", value=MathNodes.LogNode.class)
            private static final class Function15Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function15Node_(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 16);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function15Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function15Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function15Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, DynamicObject)", value=MathNodes.LogNode.class)
            private static final class Function14Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function14Node_(LogNodeGen root, Object arguments0Value) {
                    super(root, 15);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function14Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value) {
                    return new Function14Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(double, long)", value=MathNodes.LogNode.class)
            private static final class Function13Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function13Node_(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 14);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function13Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function13Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function13Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, int)", value=MathNodes.LogNode.class)
            private static final class Function12Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function12Node_(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 13);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function12Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function12Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function12Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, double)", value=MathNodes.LogNode.class)
            private static final class Function11Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function11Node_(LogNodeGen root, Object arguments1Value) {
                    super(root, 12);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function11Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments1Value) {
                    return new Function11Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, DynamicObject)", value=MathNodes.LogNode.class)
            private static final class Function10Node_
            extends BaseNode_ {
                Function10Node_(LogNodeGen root) {
                    super(root, 11);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new Function10Node_(root);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, long)", value=MathNodes.LogNode.class)
            private static final class Function9Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function9Node_(LogNodeGen root, Object arguments1Value) {
                    super(root, 10);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function9Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments1Value) {
                    return new Function9Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, int)", value=MathNodes.LogNode.class)
            private static final class Function8Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function8Node_(LogNodeGen root, Object arguments1Value) {
                    super(root, 9);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function8Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments1Value) {
                    return new Function8Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, double)", value=MathNodes.LogNode.class)
            private static final class Function7Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function7Node_(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function7Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function7Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function7Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, DynamicObject)", value=MathNodes.LogNode.class)
            private static final class Function6Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function6Node_(LogNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function6Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value) {
                    return new Function6Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, long)", value=MathNodes.LogNode.class)
            private static final class Function5Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function5Node_(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function5Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function5Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function5Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, int)", value=MathNodes.LogNode.class)
            private static final class Function4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function4Node_(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function4Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function4Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function4Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, double)", value=MathNodes.LogNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function3Node_(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function3Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function3Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, DynamicObject)", value=MathNodes.LogNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function2Node_(LogNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value) {
                    return new Function2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, long)", value=MathNodes.LogNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function1Node_(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, int)", value=MathNodes.LogNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function0Node_(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function0Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(value=MathNodes.LogNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LogNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LogNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LogNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LogNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LogNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LogNodeGen root;

                BaseNode_(LogNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (LogNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    DynamicObject arguments1Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function0Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Function2Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function3Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_2 = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function4Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function5Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_2)) {
                            return Function6Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function7Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    if (arguments0Value instanceof DynamicObject) {
                        arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyTypesGen.isImplicitInteger(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function8Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function9Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_2 = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_2)) {
                                return Function10Node_.create(this.root);
                            }
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function11Node_.create(this.root, arguments1Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function12Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function13Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Function14Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function15Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    if (arguments1Value instanceof NotProvided) {
                        if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                            return Function16Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                            return Function17Node_.create(this.root, arguments0Value);
                        }
                        if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                            return Function18Node_.create(this.root);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                            return Function19Node_.create(this.root, arguments0Value);
                        }
                        ToFNode toFNode21 = ToFNode.create();
                        return Function20Node_.create(this.root, toFNode21);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments0Value_, arguments0ImplicitType);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments1Value_, arguments1ImplicitType);
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.LGammaNode.class)
    public static final class LGammaNodeFactory
    implements NodeFactory<MathNodes.LGammaNode> {
        private static LGammaNodeFactory lGammaNodeFactoryInstance;

        private LGammaNodeFactory() {
        }

        public Class<MathNodes.LGammaNode> getNodeClass() {
            return MathNodes.LGammaNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyContext.class, SourceSection.class, RubyNode[].class));
        }

        public MathNodes.LGammaNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LGammaNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.LGammaNode> getInstance() {
            if (lGammaNodeFactoryInstance == null) {
                lGammaNodeFactoryInstance = new LGammaNodeFactory();
            }
            return lGammaNodeFactoryInstance;
        }

        public static MathNodes.LGammaNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new LGammaNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MathNodes.LGammaNode.class)
        public static final class LGammaNodeGen
        extends MathNodes.LGammaNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LGammaNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="lgamma(VirtualFrame, Object)", value=MathNodes.LGammaNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(LGammaNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.lgamma(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="lgamma(double)", value=MathNodes.LGammaNode.class)
            private static final class Lgamma3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Lgamma3Node_(LGammaNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Lgamma3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult());
                    }
                    return this.root.lgamma(arguments0Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.lgamma(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root, Object arguments0Value) {
                    return new Lgamma3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="lgamma(DynamicObject)", value=MathNodes.LGammaNode.class)
            private static final class Lgamma2Node_
            extends BaseNode_ {
                Lgamma2Node_(LGammaNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.lgamma(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root) {
                    return new Lgamma2Node_(root);
                }
            }

            @GeneratedBy(methodName="lgamma(long)", value=MathNodes.LGammaNode.class)
            private static final class Lgamma1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Lgamma1Node_(LGammaNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Lgamma1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult());
                    }
                    return this.root.lgamma(arguments0Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.lgamma(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root, Object arguments0Value) {
                    return new Lgamma1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="lgamma(int)", value=MathNodes.LGammaNode.class)
            private static final class Lgamma0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Lgamma0Node_(LGammaNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Lgamma0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult());
                    }
                    return this.root.lgamma(arguments0Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.lgamma(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root, Object arguments0Value) {
                    return new Lgamma0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.LGammaNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LGammaNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LGammaNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LGammaNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(LGammaNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LGammaNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LGammaNodeGen root;

                BaseNode_(LGammaNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (LGammaNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Lgamma0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Lgamma1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Lgamma2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Lgamma3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.LdexpNode.class)
    public static final class LdexpNodeFactory
    implements NodeFactory<MathNodes.LdexpNode> {
        private static LdexpNodeFactory ldexpNodeFactoryInstance;

        private LdexpNodeFactory() {
        }

        public Class<MathNodes.LdexpNode> getNodeClass() {
            return MathNodes.LdexpNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.LdexpNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LdexpNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.LdexpNode> getInstance() {
            if (ldexpNodeFactoryInstance == null) {
                ldexpNodeFactoryInstance = new LdexpNodeFactory();
            }
            return ldexpNodeFactoryInstance;
        }

        public static MathNodes.LdexpNode create(RubyNode[] arguments) {
            return new LdexpNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.LdexpNode.class)
        public static final class LdexpNodeGen
        extends MathNodes.LdexpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private LdexpNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="ldexp(Object, Object)", value=MathNodes.LdexpNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(LdexpNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value, Object arguments1Value) {
                    return this.createNext(null, arguments0Value, arguments1Value) == null;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.guardFallback(arguments0Value, arguments1Value)) {
                        return this.root.ldexp(arguments0Value, arguments1Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="ldexp(double, int)", value=MathNodes.LdexpNode.class)
            private static final class LdexpNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                LdexpNode_(LdexpNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((LdexpNode_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((LdexpNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return LdexpNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult(), arguments1Value));
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return LdexpNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_, ex.getResult()));
                    }
                    return this.root.ldexp(arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.ldexp(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new LdexpNode_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(value=MathNodes.LdexpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(LdexpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LdexpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(LdexpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(LdexpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.LdexpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected LdexpNodeGen root;

                BaseNode_(LdexpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (LdexpNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return LdexpNodeGen.expectDouble(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value) && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        return LdexpNode_.create(this.root, arguments0Value, arguments1Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.HypotNode.class)
    public static final class HypotNodeFactory
    implements NodeFactory<MathNodes.HypotNode> {
        private static HypotNodeFactory hypotNodeFactoryInstance;

        private HypotNodeFactory() {
        }

        public Class<MathNodes.HypotNode> getNodeClass() {
            return MathNodes.HypotNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.HypotNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return HypotNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.HypotNode> getInstance() {
            if (hypotNodeFactoryInstance == null) {
                hypotNodeFactoryInstance = new HypotNodeFactory();
            }
            return hypotNodeFactoryInstance;
        }

        public static MathNodes.HypotNode create(RubyNode[] arguments) {
            return new HypotNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.HypotNode.class)
        public static final class HypotNodeGen
        extends MathNodes.HypotNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private HypotNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, Object)", value=MathNodes.HypotNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(HypotNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value, Object arguments1Value) {
                    return this.createNext(null, arguments0Value, arguments1Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_, arguments1Value_ = this.executeArguments1_((Frame)frameValue))) {
                        return this.root.function(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.guardFallback(arguments0Value, arguments1Value)) {
                        return this.root.function(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double, double)", value=MathNodes.HypotNode.class)
            private static final class Function15Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function15Node_(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 16);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function15Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function15Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function15Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, DynamicObject)", value=MathNodes.HypotNode.class)
            private static final class Function14Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function14Node_(HypotNodeGen root, Object arguments0Value) {
                    super(root, 15);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function14Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value) {
                    return new Function14Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(double, long)", value=MathNodes.HypotNode.class)
            private static final class Function13Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function13Node_(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 14);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function13Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function13Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function13Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, int)", value=MathNodes.HypotNode.class)
            private static final class Function12Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function12Node_(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 13);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function12Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function12Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function12Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, double)", value=MathNodes.HypotNode.class)
            private static final class Function11Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function11Node_(HypotNodeGen root, Object arguments1Value) {
                    super(root, 12);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function11Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments1Value) {
                    return new Function11Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, DynamicObject)", value=MathNodes.HypotNode.class)
            private static final class Function10Node_
            extends BaseNode_ {
                Function10Node_(HypotNodeGen root) {
                    super(root, 11);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new Function10Node_(root);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, long)", value=MathNodes.HypotNode.class)
            private static final class Function9Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function9Node_(HypotNodeGen root, Object arguments1Value) {
                    super(root, 10);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function9Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments1Value) {
                    return new Function9Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, int)", value=MathNodes.HypotNode.class)
            private static final class Function8Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function8Node_(HypotNodeGen root, Object arguments1Value) {
                    super(root, 9);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function8Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments1Value) {
                    return new Function8Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, double)", value=MathNodes.HypotNode.class)
            private static final class Function7Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function7Node_(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function7Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function7Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function7Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, DynamicObject)", value=MathNodes.HypotNode.class)
            private static final class Function6Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function6Node_(HypotNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function6Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value) {
                    return new Function6Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, long)", value=MathNodes.HypotNode.class)
            private static final class Function5Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function5Node_(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function5Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function5Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function5Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, int)", value=MathNodes.HypotNode.class)
            private static final class Function4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function4Node_(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function4Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function4Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function4Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, double)", value=MathNodes.HypotNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function3Node_(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function3Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function3Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, DynamicObject)", value=MathNodes.HypotNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function2Node_(HypotNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value) {
                    return new Function2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, long)", value=MathNodes.HypotNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function1Node_(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, int)", value=MathNodes.HypotNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function0Node_(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function0Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(value=MathNodes.HypotNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(HypotNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.HypotNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(HypotNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(HypotNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.HypotNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected HypotNodeGen root;

                BaseNode_(HypotNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (HypotNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function0Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Function2Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function3Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function4Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function5Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function6Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function7Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyTypesGen.isImplicitInteger(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function8Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function9Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_2 = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_2)) {
                                return Function10Node_.create(this.root);
                            }
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function11Node_.create(this.root, arguments1Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function12Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function13Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Function14Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function15Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments0Value_, arguments0ImplicitType);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments1Value_, arguments1ImplicitType);
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.GammaNode.class)
    public static final class GammaNodeFactory
    implements NodeFactory<MathNodes.GammaNode> {
        private static GammaNodeFactory gammaNodeFactoryInstance;

        private GammaNodeFactory() {
        }

        public Class<MathNodes.GammaNode> getNodeClass() {
            return MathNodes.GammaNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.GammaNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GammaNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.GammaNode> getInstance() {
            if (gammaNodeFactoryInstance == null) {
                gammaNodeFactoryInstance = new GammaNodeFactory();
            }
            return gammaNodeFactoryInstance;
        }

        public static MathNodes.GammaNode create(RubyNode[] arguments) {
            return new GammaNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.GammaNode.class)
        public static final class GammaNodeGen
        extends MathNodes.GammaNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GammaNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.GammaNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(GammaNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.GammaNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(GammaNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.GammaNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(GammaNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.GammaNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(GammaNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.GammaNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(GammaNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.GammaNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GammaNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.GammaNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GammaNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(GammaNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.GammaNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected GammaNodeGen root;

                BaseNode_(GammaNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (GammaNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.FrExpNode.class)
    public static final class FrExpNodeFactory
    implements NodeFactory<MathNodes.FrExpNode> {
        private static FrExpNodeFactory frExpNodeFactoryInstance;

        private FrExpNodeFactory() {
        }

        public Class<MathNodes.FrExpNode> getNodeClass() {
            return MathNodes.FrExpNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.FrExpNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return FrExpNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.FrExpNode> getInstance() {
            if (frExpNodeFactoryInstance == null) {
                frExpNodeFactoryInstance = new FrExpNodeFactory();
            }
            return frExpNodeFactoryInstance;
        }

        public static MathNodes.FrExpNode create(RubyNode[] arguments) {
            return new FrExpNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.FrExpNode.class)
        public static final class FrExpNodeGen
        extends MathNodes.FrExpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private FrExpNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="frexp(Object)", value=MathNodes.FrExpNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(FrExpNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.frexp(arguments0Value);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="frexp(double)", value=MathNodes.FrExpNode.class)
            private static final class FrexpNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                FrexpNode_(FrExpNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((FrexpNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return FrExpNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.frexp(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.frexp(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root, Object arguments0Value) {
                    return new FrexpNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.FrExpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(FrExpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.FrExpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(FrExpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(FrExpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.FrExpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected FrExpNodeGen root;

                BaseNode_(FrExpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (FrExpNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return FrExpNodeGen.expectDynamicObject(this.execute(frameValue));
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return FrexpNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ExpNode.class)
    public static final class ExpNodeFactory
    implements NodeFactory<MathNodes.ExpNode> {
        private static ExpNodeFactory expNodeFactoryInstance;

        private ExpNodeFactory() {
        }

        public Class<MathNodes.ExpNode> getNodeClass() {
            return MathNodes.ExpNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.ExpNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ExpNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ExpNode> getInstance() {
            if (expNodeFactoryInstance == null) {
                expNodeFactoryInstance = new ExpNodeFactory();
            }
            return expNodeFactoryInstance;
        }

        public static MathNodes.ExpNode create(RubyNode[] arguments) {
            return new ExpNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.ExpNode.class)
        public static final class ExpNodeGen
        extends MathNodes.ExpNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ExpNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ExpNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ExpNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ExpNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(ExpNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.ExpNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ExpNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ExpNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ExpNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ExpNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(ExpNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.ExpNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ExpNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ExpNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ExpNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ExpNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ExpNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ExpNodeGen root;

                BaseNode_(ExpNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ExpNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ErfcNode.class)
    public static final class ErfcNodeFactory
    implements NodeFactory<MathNodes.ErfcNode> {
        private static ErfcNodeFactory erfcNodeFactoryInstance;

        private ErfcNodeFactory() {
        }

        public Class<MathNodes.ErfcNode> getNodeClass() {
            return MathNodes.ErfcNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.ErfcNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ErfcNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ErfcNode> getInstance() {
            if (erfcNodeFactoryInstance == null) {
                erfcNodeFactoryInstance = new ErfcNodeFactory();
            }
            return erfcNodeFactoryInstance;
        }

        public static MathNodes.ErfcNode create(RubyNode[] arguments) {
            return new ErfcNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.ErfcNode.class)
        public static final class ErfcNodeGen
        extends MathNodes.ErfcNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ErfcNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ErfcNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ErfcNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ErfcNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(ErfcNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.ErfcNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ErfcNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ErfcNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ErfcNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ErfcNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(ErfcNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.ErfcNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ErfcNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ErfcNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ErfcNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfcNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ErfcNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ErfcNodeGen root;

                BaseNode_(ErfcNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ErfcNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ErfNode.class)
    public static final class ErfNodeFactory
    implements NodeFactory<MathNodes.ErfNode> {
        private static ErfNodeFactory erfNodeFactoryInstance;

        private ErfNodeFactory() {
        }

        public Class<MathNodes.ErfNode> getNodeClass() {
            return MathNodes.ErfNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.ErfNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ErfNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ErfNode> getInstance() {
            if (erfNodeFactoryInstance == null) {
                erfNodeFactoryInstance = new ErfNodeFactory();
            }
            return erfNodeFactoryInstance;
        }

        public static MathNodes.ErfNode create(RubyNode[] arguments) {
            return new ErfNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.ErfNode.class)
        public static final class ErfNodeGen
        extends MathNodes.ErfNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ErfNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ErfNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ErfNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ErfNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(ErfNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.ErfNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ErfNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ErfNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ErfNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ErfNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(ErfNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.ErfNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ErfNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ErfNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ErfNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ErfNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ErfNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ErfNodeGen root;

                BaseNode_(ErfNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ErfNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.CosHNode.class)
    public static final class CosHNodeFactory
    implements NodeFactory<MathNodes.CosHNode> {
        private static CosHNodeFactory cosHNodeFactoryInstance;

        private CosHNodeFactory() {
        }

        public Class<MathNodes.CosHNode> getNodeClass() {
            return MathNodes.CosHNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.CosHNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CosHNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.CosHNode> getInstance() {
            if (cosHNodeFactoryInstance == null) {
                cosHNodeFactoryInstance = new CosHNodeFactory();
            }
            return cosHNodeFactoryInstance;
        }

        public static MathNodes.CosHNode create(RubyNode[] arguments) {
            return new CosHNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.CosHNode.class)
        public static final class CosHNodeGen
        extends MathNodes.CosHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CosHNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.CosHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(CosHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.CosHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(CosHNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.CosHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(CosHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.CosHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(CosHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.CosHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(CosHNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.CosHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CosHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CosHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CosHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(CosHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CosHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CosHNodeGen root;

                BaseNode_(CosHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (CosHNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.CosNode.class)
    public static final class CosNodeFactory
    implements NodeFactory<MathNodes.CosNode> {
        private static CosNodeFactory cosNodeFactoryInstance;

        private CosNodeFactory() {
        }

        public Class<MathNodes.CosNode> getNodeClass() {
            return MathNodes.CosNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.CosNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CosNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.CosNode> getInstance() {
            if (cosNodeFactoryInstance == null) {
                cosNodeFactoryInstance = new CosNodeFactory();
            }
            return cosNodeFactoryInstance;
        }

        public static MathNodes.CosNode create(RubyNode[] arguments) {
            return new CosNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.CosNode.class)
        public static final class CosNodeGen
        extends MathNodes.CosNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CosNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.CosNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(CosNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.CosNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(CosNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.CosNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(CosNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.CosNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(CosNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.CosNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(CosNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.CosNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CosNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CosNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CosNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(CosNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CosNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CosNodeGen root;

                BaseNode_(CosNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (CosNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.CbRtNode.class)
    public static final class CbRtNodeFactory
    implements NodeFactory<MathNodes.CbRtNode> {
        private static CbRtNodeFactory cbRtNodeFactoryInstance;

        private CbRtNodeFactory() {
        }

        public Class<MathNodes.CbRtNode> getNodeClass() {
            return MathNodes.CbRtNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.CbRtNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CbRtNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.CbRtNode> getInstance() {
            if (cbRtNodeFactoryInstance == null) {
                cbRtNodeFactoryInstance = new CbRtNodeFactory();
            }
            return cbRtNodeFactoryInstance;
        }

        public static MathNodes.CbRtNode create(RubyNode[] arguments) {
            return new CbRtNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.CbRtNode.class)
        public static final class CbRtNodeGen
        extends MathNodes.CbRtNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private CbRtNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.CbRtNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(CbRtNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.CbRtNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(CbRtNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.CbRtNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(CbRtNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.CbRtNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(CbRtNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.CbRtNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(CbRtNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.CbRtNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CbRtNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CbRtNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CbRtNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(CbRtNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.CbRtNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CbRtNodeGen root;

                BaseNode_(CbRtNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (CbRtNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ATanHNode.class)
    public static final class ATanHNodeFactory
    implements NodeFactory<MathNodes.ATanHNode> {
        private static ATanHNodeFactory aTanHNodeFactoryInstance;

        private ATanHNodeFactory() {
        }

        public Class<MathNodes.ATanHNode> getNodeClass() {
            return MathNodes.ATanHNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.ATanHNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ATanHNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ATanHNode> getInstance() {
            if (aTanHNodeFactoryInstance == null) {
                aTanHNodeFactoryInstance = new ATanHNodeFactory();
            }
            return aTanHNodeFactoryInstance;
        }

        public static MathNodes.ATanHNode create(RubyNode[] arguments) {
            return new ATanHNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.ATanHNode.class)
        public static final class ATanHNodeGen
        extends MathNodes.ATanHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ATanHNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ATanHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ATanHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ATanHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(ATanHNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.ATanHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ATanHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ATanHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ATanHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ATanHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(ATanHNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.ATanHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ATanHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATanHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ATanHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATanHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ATanHNodeGen root;

                BaseNode_(ATanHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ATanHNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ATan2Node.class)
    public static final class ATan2NodeFactory
    implements NodeFactory<MathNodes.ATan2Node> {
        private static ATan2NodeFactory aTan2NodeFactoryInstance;

        private ATan2NodeFactory() {
        }

        public Class<MathNodes.ATan2Node> getNodeClass() {
            return MathNodes.ATan2Node.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.ATan2Node createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ATan2NodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ATan2Node> getInstance() {
            if (aTan2NodeFactoryInstance == null) {
                aTan2NodeFactoryInstance = new ATan2NodeFactory();
            }
            return aTan2NodeFactoryInstance;
        }

        public static MathNodes.ATan2Node create(RubyNode[] arguments) {
            return new ATan2NodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.ATan2Node.class)
        public static final class ATan2NodeGen
        extends MathNodes.ATan2Node
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ATan2NodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object, Object)", value=MathNodes.ATan2Node.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ATan2NodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value, Object arguments1Value) {
                    return this.createNext(null, arguments0Value, arguments1Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments1Value_;
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_, arguments1Value_ = this.executeArguments1_((Frame)frameValue))) {
                        return this.root.function(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (this.guardFallback(arguments0Value, arguments1Value)) {
                        return this.root.function(frameValue, arguments0Value, arguments1Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double, double)", value=MathNodes.ATan2Node.class)
            private static final class Function15Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function15Node_(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 16);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function15Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function15Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function15Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, DynamicObject)", value=MathNodes.ATan2Node.class)
            private static final class Function14Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function14Node_(ATan2NodeGen root, Object arguments0Value) {
                    super(root, 15);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function14Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value) {
                    return new Function14Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(double, long)", value=MathNodes.ATan2Node.class)
            private static final class Function13Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function13Node_(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 14);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function13Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function13Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function13Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(double, int)", value=MathNodes.ATan2Node.class)
            private static final class Function12Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function12Node_(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 13);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function12Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function12Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function12Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, double)", value=MathNodes.ATan2Node.class)
            private static final class Function11Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function11Node_(ATan2NodeGen root, Object arguments1Value) {
                    super(root, 12);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function11Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments1Value) {
                    return new Function11Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, DynamicObject)", value=MathNodes.ATan2Node.class)
            private static final class Function10Node_
            extends BaseNode_ {
                Function10Node_(ATan2NodeGen root) {
                    super(root, 11);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new Function10Node_(root);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, long)", value=MathNodes.ATan2Node.class)
            private static final class Function9Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function9Node_(ATan2NodeGen root, Object arguments1Value) {
                    super(root, 10);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function9Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments1Value) {
                    return new Function9Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject, int)", value=MathNodes.ATan2Node.class)
            private static final class Function8Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                Function8Node_(ATan2NodeGen root, Object arguments1Value) {
                    super(root, 9);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((Function8Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments1Value) {
                    return new Function8Node_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, double)", value=MathNodes.ATan2Node.class)
            private static final class Function7Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function7Node_(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 8);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function7Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function7Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function7Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, DynamicObject)", value=MathNodes.ATan2Node.class)
            private static final class Function6Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function6Node_(ATan2NodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function6Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value) {
                    return new Function6Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(long, long)", value=MathNodes.ATan2Node.class)
            private static final class Function5Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function5Node_(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 6);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function5Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function5Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function5Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(long, int)", value=MathNodes.ATan2Node.class)
            private static final class Function4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function4Node_(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function4Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function4Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_((Frame)frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function4Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, double)", value=MathNodes.ATan2Node.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function3Node_(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function3Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Double.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeDouble(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitDouble(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitDouble(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        double arguments1Value_ = RubyTypesGen.asImplicitDouble(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function3Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, DynamicObject)", value=MathNodes.ATan2Node.class)
            private static final class Function2Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function2Node_(ATan2NodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function2Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments1Value_)) {
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && arguments1Value instanceof DynamicObject) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyBignum(arguments1Value_)) {
                            return this.root.function(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value) {
                    return new Function2Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int, long)", value=MathNodes.ATan2Node.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function1Node_(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitLongClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function1Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.executeArguments1Long_((Frame)frameValue, this.arguments1ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitLong(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        long arguments1Value_ = RubyTypesGen.asImplicitLong(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function1Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(methodName="function(int, int)", value=MathNodes.ATan2Node.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;
                private final Class<?> arguments1ImplicitType;

                Function0Node_(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType && this.arguments1ImplicitType == ((Function0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments1Value_;
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_((Frame)frameValue);
                        return this.getNext().executeDouble_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_((Frame)frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.function(arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType) && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.function(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root, Object arguments0Value, Object arguments1Value) {
                    return new Function0Node_(root, arguments0Value, arguments1Value);
                }
            }

            @GeneratedBy(value=MathNodes.ATan2Node.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ATan2NodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATan2Node.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ATan2NodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ATan2NodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATan2Node.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ATan2NodeGen root;

                BaseNode_(ATan2NodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ATan2NodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    Object arguments1Value_ = this.executeArguments1_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function0Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function1Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Function2Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function3Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function4Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function5Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function6Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function7Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyTypesGen.isImplicitInteger(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function8Node_.create(this.root, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function9Node_.create(this.root, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            DynamicObject arguments1Value_2 = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubyBignum(arguments0Value_) && RubyGuards.isRubyBignum(arguments1Value_2)) {
                                return Function10Node_.create(this.root);
                            }
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value) && RubyGuards.isRubyBignum(arguments0Value_)) {
                            return Function11Node_.create(this.root, arguments1Value);
                        }
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            return Function12Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (RubyTypesGen.isImplicitLong(arguments1Value)) {
                            return Function13Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                        if (arguments1Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments1Value_ = (DynamicObject)arguments1Value)) {
                            return Function14Node_.create(this.root, arguments0Value);
                        }
                        if (RubyTypesGen.isImplicitDouble(arguments1Value)) {
                            return Function15Node_.create(this.root, arguments0Value, arguments1Value);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments0Value_, arguments0ImplicitType);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Double.TYPE) {
                        return this.root.arguments1_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                protected final long executeArguments1Long_(Frame frameValue, Class<?> arguments1ImplicitType) throws UnexpectedResultException {
                    if (arguments1ImplicitType == Long.TYPE) {
                        return this.root.arguments1_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments1ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments1_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments1Value_, arguments1ImplicitType);
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ATanNode.class)
    public static final class ATanNodeFactory
    implements NodeFactory<MathNodes.ATanNode> {
        private static ATanNodeFactory aTanNodeFactoryInstance;

        private ATanNodeFactory() {
        }

        public Class<MathNodes.ATanNode> getNodeClass() {
            return MathNodes.ATanNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.ATanNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ATanNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ATanNode> getInstance() {
            if (aTanNodeFactoryInstance == null) {
                aTanNodeFactoryInstance = new ATanNodeFactory();
            }
            return aTanNodeFactoryInstance;
        }

        public static MathNodes.ATanNode create(RubyNode[] arguments) {
            return new ATanNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.ATanNode.class)
        public static final class ATanNodeGen
        extends MathNodes.ATanNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ATanNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ATanNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ATanNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ATanNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(ATanNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.ATanNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ATanNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ATanNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ATanNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ATanNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(ATanNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.ATanNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ATanNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATanNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ATanNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ATanNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ATanNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ATanNodeGen root;

                BaseNode_(ATanNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ATanNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ASinHNode.class)
    public static final class ASinHNodeFactory
    implements NodeFactory<MathNodes.ASinHNode> {
        private static ASinHNodeFactory aSinHNodeFactoryInstance;

        private ASinHNodeFactory() {
        }

        public Class<MathNodes.ASinHNode> getNodeClass() {
            return MathNodes.ASinHNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.ASinHNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ASinHNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ASinHNode> getInstance() {
            if (aSinHNodeFactoryInstance == null) {
                aSinHNodeFactoryInstance = new ASinHNodeFactory();
            }
            return aSinHNodeFactoryInstance;
        }

        public static MathNodes.ASinHNode create(RubyNode[] arguments) {
            return new ASinHNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.ASinHNode.class)
        public static final class ASinHNodeGen
        extends MathNodes.ASinHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ASinHNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ASinHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ASinHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ASinHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(ASinHNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.ASinHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ASinHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ASinHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ASinHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ASinHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(ASinHNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.ASinHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ASinHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ASinHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ASinHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ASinHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ASinHNodeGen root;

                BaseNode_(ASinHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ASinHNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ASinNode.class)
    public static final class ASinNodeFactory
    implements NodeFactory<MathNodes.ASinNode> {
        private static ASinNodeFactory aSinNodeFactoryInstance;

        private ASinNodeFactory() {
        }

        public Class<MathNodes.ASinNode> getNodeClass() {
            return MathNodes.ASinNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.ASinNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ASinNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ASinNode> getInstance() {
            if (aSinNodeFactoryInstance == null) {
                aSinNodeFactoryInstance = new ASinNodeFactory();
            }
            return aSinNodeFactoryInstance;
        }

        public static MathNodes.ASinNode create(RubyNode[] arguments) {
            return new ASinNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.ASinNode.class)
        public static final class ASinNodeGen
        extends MathNodes.ASinNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ASinNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ASinNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ASinNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ASinNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(ASinNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.ASinNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ASinNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ASinNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ASinNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ASinNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(ASinNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.ASinNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ASinNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ASinNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ASinNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ASinNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ASinNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ASinNodeGen root;

                BaseNode_(ASinNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ASinNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ACosHNode.class)
    public static final class ACosHNodeFactory
    implements NodeFactory<MathNodes.ACosHNode> {
        private static ACosHNodeFactory aCosHNodeFactoryInstance;

        private ACosHNodeFactory() {
        }

        public Class<MathNodes.ACosHNode> getNodeClass() {
            return MathNodes.ACosHNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.ACosHNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ACosHNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ACosHNode> getInstance() {
            if (aCosHNodeFactoryInstance == null) {
                aCosHNodeFactoryInstance = new ACosHNodeFactory();
            }
            return aCosHNodeFactoryInstance;
        }

        public static MathNodes.ACosHNode create(RubyNode[] arguments) {
            return new ACosHNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.ACosHNode.class)
        public static final class ACosHNodeGen
        extends MathNodes.ACosHNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ACosHNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ACosHNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ACosHNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ACosHNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(ACosHNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.ACosHNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ACosHNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ACosHNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ACosHNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ACosHNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(ACosHNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.ACosHNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ACosHNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ACosHNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ACosHNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosHNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ACosHNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ACosHNodeGen root;

                BaseNode_(ACosHNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ACosHNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MathNodes.ACosNode.class)
    public static final class ACosNodeFactory
    implements NodeFactory<MathNodes.ACosNode> {
        private static ACosNodeFactory aCosNodeFactoryInstance;

        private ACosNodeFactory() {
        }

        public Class<MathNodes.ACosNode> getNodeClass() {
            return MathNodes.ACosNode.class;
        }

        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        public MathNodes.ACosNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ACosNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MathNodes.ACosNode> getInstance() {
            if (aCosNodeFactoryInstance == null) {
                aCosNodeFactoryInstance = new ACosNodeFactory();
            }
            return aCosNodeFactoryInstance;
        }

        public static MathNodes.ACosNode create(RubyNode[] arguments) {
            return new ACosNodeGen(arguments);
        }

        @GeneratedBy(value=MathNodes.ACosNode.class)
        public static final class ACosNodeGen
        extends MathNodes.ACosNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ACosNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) {
                return this.specialization_.executeDouble(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="function(VirtualFrame, Object)", value=MathNodes.ACosNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(ACosNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext(null, arguments0Value) == null;
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.function(frameValue, arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.function(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="function(double)", value=MathNodes.ACosNode.class)
            private static final class Function3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function3Node_(ACosNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root, Object arguments0Value) {
                    return new Function3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(DynamicObject)", value=MathNodes.ACosNode.class)
            private static final class Function2Node_
            extends BaseNode_ {
                Function2Node_(ACosNodeGen root) {
                    super(root, 3);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root) {
                    return new Function2Node_(root);
                }
            }

            @GeneratedBy(methodName="function(long)", value=MathNodes.ACosNode.class)
            private static final class Function1Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function1Node_(ACosNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function1Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root, Object arguments0Value) {
                    return new Function1Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="function(int)", value=MathNodes.ACosNode.class)
            private static final class Function0Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Function0Node_(ACosNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Function0Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDouble(frameValue);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_((Frame)frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDouble_(frameValue, ex.getResult());
                    }
                    return this.root.function(arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.function(arguments0Value_);
                    }
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root, Object arguments0Value) {
                    return new Function0Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=MathNodes.ACosNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ACosNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.getNext().executeDouble_(frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDouble_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ACosNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ACosNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public double executeDouble_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Double)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ACosNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MathNodes.ACosNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ACosNodeGen root;

                BaseNode_(ACosNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ACosNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDouble_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract double executeDouble_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_((Frame)frameValue);
                    return this.executeDouble_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public double executeDouble(VirtualFrame frameValue) {
                    return (Double)this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Function0Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Function1Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return Function2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Function3Node_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }
}

