/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.parser.ParserContext;

public class SnippetNode
extends RubyBaseNode {
    @CompilerDirectives.CompilationFinal
    private String expression;
    @CompilerDirectives.CompilationFinal
    private String[] parameters;
    @CompilerDirectives.CompilationFinal
    private FrameDescriptor frameDescriptor;
    @CompilerDirectives.CompilationFinal
    private FrameSlot[] parameterFrameSlots;
    @Node.Child
    private DirectCallNode directCallNode;

    public Object execute(VirtualFrame frame, String expression, Object ... arguments) {
        if (this.directCallNode == null) {
            int n;
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.expression = expression;
            assert (arguments.length % 2 == 0);
            this.parameters = new String[arguments.length / 2];
            for (n = 0; n < this.parameters.length; ++n) {
                this.parameters[n] = (String)arguments[2 * n];
            }
            this.frameDescriptor = new FrameDescriptor((Object)this.nil());
            this.parameterFrameSlots = new FrameSlot[this.parameters.length];
            for (n = 0; n < this.parameters.length; ++n) {
                this.parameterFrameSlots[n] = this.frameDescriptor.findOrAddFrameSlot((Object)this.parameters[n]);
            }
            Source source = this.getContext().getSourceLoader().loadFragment(this.expression, "(snippet)");
            RubyRootNode rootNode = this.getContext().getCodeLoader().parse(source, (Encoding)UTF8Encoding.INSTANCE, ParserContext.INLINE, this.frameDescriptor, null, true, this);
            this.directCallNode = (DirectCallNode)this.insert((Node)Truffle.getRuntime().createDirectCallNode((CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNode)));
            if (this.directCallNode.isInlinable()) {
                this.directCallNode.forceInlining();
            }
        }
        if (arguments.length != this.parameters.length * 2) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedOperationException("number of arguments doesn't match number of parameters");
        }
        assert (this.ensureConstantExpressionParameters(expression, arguments));
        Object[] callArguments = RubyArguments.pack(this.parentFrame(frame, arguments), null, RubyArguments.getMethod((Frame)frame), DeclarationContext.INSTANCE_EVAL, null, RubyArguments.getSelf((Frame)frame), null, new Object[0]);
        return this.directCallNode.call(frame, callArguments);
    }

    private boolean ensureConstantExpressionParameters(String expression, Object[] arguments) {
        assert (this.expression == expression) : "has to be always called with same expression: " + this.expression + " != " + expression;
        for (int n = 0; n < this.parameters.length; ++n) {
            assert (this.parameters[n] == arguments[2 * n]) : "has to be always called with same parameter name at " + n + ": " + this.parameters[n] + " != " + arguments[2 * n];
        }
        return true;
    }

    @ExplodeLoop
    private MaterializedFrame parentFrame(VirtualFrame frame, Object[] arguments) {
        Object[] parentFrameArguments = RubyArguments.pack(null, null, RubyArguments.getMethod((Frame)frame), DeclarationContext.INSTANCE_EVAL, null, RubyArguments.getSelf((Frame)frame), null, new Object[0]);
        MaterializedFrame parentFrame = Truffle.getRuntime().createMaterializedFrame(parentFrameArguments, this.frameDescriptor);
        for (int n = 0; n < this.parameters.length; ++n) {
            parentFrame.setObject(this.parameterFrameSlots[n], arguments[2 * n + 1]);
        }
        return parentFrame;
    }
}

