/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop.cext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.string.StringNodes;
import org.jruby.truffle.core.string.StringNodesFactory;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.interop.cext.CExtString;

public class CExtStringMessageResolution {

    public static abstract class ForeignWriteNode
    extends Node {
        @Node.Child
        private Node findContextNode;
        @Node.Child
        private StringNodes.SetByteNode setByteNode;

        protected Object access(CExtString cExtString, int index, Object value) {
            return this.getHelperNode().executeSetByte(cExtString.getString(), index, value);
        }

        private StringNodes.SetByteNode getHelperNode() {
            if (this.setByteNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.findContextNode = this.insert(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
                RubyContext context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
                this.setByteNode = (StringNodes.SetByteNode)this.insert(StringNodesFactory.SetByteNodeFactory.create(context, null, null, null, null));
            }
            return this.setByteNode;
        }
    }

    public static abstract class ForeignReadNode
    extends Node {
        @Node.Child
        private RopeNodes.GetByteNode getByteNode;

        protected Object access(CExtString cExtString, int index) {
            return this.getHelperNode().executeGetByte(StringOperations.rope(cExtString.getString()), index);
        }

        private RopeNodes.GetByteNode getHelperNode() {
            if (this.getByteNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getByteNode = (RopeNodes.GetByteNode)this.insert(RopeNodesFactory.GetByteNodeGen.create(null, null));
            }
            return this.getByteNode;
        }
    }

    public static abstract class ForeignGetSizeNode
    extends Node {
        protected Object access(CExtString cExtString) {
            return StringOperations.rope(cExtString.getString()).byteLength();
        }
    }

    public static abstract class ForeignHasSizeNode
    extends Node {
        protected Object access(CExtString object) {
            return true;
        }
    }

    public static abstract class Check
    extends Node {
        protected static boolean test(TruffleObject receiver) {
            return receiver instanceof CExtString;
        }
    }
}

