/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.tracepoint;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.tracepoint.TracePointLayout;

@GeneratedBy(value=TracePointLayout.class)
public class TracePointLayoutImpl
extends BasicObjectLayoutImpl
implements TracePointLayout {
    public static final TracePointLayout INSTANCE = new TracePointLayoutImpl();
    protected static final Shape.Allocator TRACE_POINT_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey TAGS_IDENTIFIER = new HiddenKey("tags");
    protected static final Property TAGS_PROPERTY = Property.create((Object)TAGS_IDENTIFIER, (Location)TRACE_POINT_ALLOCATOR.locationForType(Object[].class), (int)0);
    protected static final HiddenKey EVENT_IDENTIFIER = new HiddenKey("event");
    protected static final Property EVENT_PROPERTY = Property.create((Object)EVENT_IDENTIFIER, (Location)TRACE_POINT_ALLOCATOR.locationForType(DynamicObject.class), (int)0);
    protected static final HiddenKey PATH_IDENTIFIER = new HiddenKey("path");
    protected static final Property PATH_PROPERTY = Property.create((Object)PATH_IDENTIFIER, (Location)TRACE_POINT_ALLOCATOR.locationForType(DynamicObject.class), (int)0);
    protected static final HiddenKey LINE_IDENTIFIER = new HiddenKey("line");
    protected static final Property LINE_PROPERTY = Property.create((Object)LINE_IDENTIFIER, (Location)TRACE_POINT_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey BINDING_IDENTIFIER = new HiddenKey("binding");
    protected static final Property BINDING_PROPERTY = Property.create((Object)BINDING_IDENTIFIER, (Location)TRACE_POINT_ALLOCATOR.locationForType(DynamicObject.class), (int)0);
    protected static final HiddenKey PROC_IDENTIFIER = new HiddenKey("proc");
    protected static final Property PROC_PROPERTY = Property.create((Object)PROC_IDENTIFIER, (Location)TRACE_POINT_ALLOCATOR.locationForType(DynamicObject.class), (int)0);
    protected static final HiddenKey EVENT_BINDING_IDENTIFIER = new HiddenKey("eventBinding");
    protected static final Property EVENT_BINDING_PROPERTY = Property.create((Object)EVENT_BINDING_IDENTIFIER, (Location)TRACE_POINT_ALLOCATOR.locationForType(Object.class), (int)0);
    protected static final HiddenKey INSIDE_PROC_IDENTIFIER = new HiddenKey("insideProc");
    protected static final Property INSIDE_PROC_PROPERTY = Property.create((Object)INSIDE_PROC_IDENTIFIER, (Location)TRACE_POINT_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected TracePointLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createTracePointShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new TracePointType(logicalClass, metaClass)).addProperty(TAGS_PROPERTY).addProperty(EVENT_PROPERTY).addProperty(PATH_PROPERTY).addProperty(LINE_PROPERTY).addProperty(BINDING_PROPERTY).addProperty(PROC_PROPERTY).addProperty(EVENT_BINDING_PROPERTY).addProperty(INSIDE_PROC_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createTracePoint(DynamicObjectFactory factory, Object[] tags, DynamicObject event, DynamicObject path, int line, DynamicObject binding, DynamicObject proc, Object eventBinding, boolean insideProc) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (TracePointLayoutImpl.createsTracePoint(factory));
        assert (factory.getShape().hasProperty((Object)TAGS_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)EVENT_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)PATH_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)LINE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)BINDING_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)PROC_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)EVENT_BINDING_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)INSIDE_PROC_IDENTIFIER));
        return factory.newInstance(new Object[]{tags, event, path, line, binding, proc, eventBinding, insideProc});
    }

    @Override
    public boolean isTracePoint(DynamicObject object) {
        return TracePointLayoutImpl.isTracePoint(object.getShape().getObjectType());
    }

    private static boolean isTracePoint(ObjectType objectType) {
        return objectType instanceof TracePointType;
    }

    private static boolean createsTracePoint(DynamicObjectFactory factory) {
        return TracePointLayoutImpl.isTracePoint(factory.getShape().getObjectType());
    }

    @Override
    public Object[] getTags(DynamicObject object) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)TAGS_IDENTIFIER));
        return (Object[])TAGS_PROPERTY.get(object, this.isTracePoint(object));
    }

    @Override
    public void setTags(DynamicObject object, Object[] value) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)TAGS_IDENTIFIER));
        try {
            TAGS_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public DynamicObject getEvent(DynamicObject object) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)EVENT_IDENTIFIER));
        return (DynamicObject)EVENT_PROPERTY.get(object, this.isTracePoint(object));
    }

    @Override
    public void setEvent(DynamicObject object, DynamicObject value) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)EVENT_IDENTIFIER));
        try {
            EVENT_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public DynamicObject getPath(DynamicObject object) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)PATH_IDENTIFIER));
        return (DynamicObject)PATH_PROPERTY.get(object, this.isTracePoint(object));
    }

    @Override
    public void setPath(DynamicObject object, DynamicObject value) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)PATH_IDENTIFIER));
        try {
            PATH_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int getLine(DynamicObject object) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)LINE_IDENTIFIER));
        return (Integer)LINE_PROPERTY.get(object, this.isTracePoint(object));
    }

    @Override
    public void setLine(DynamicObject object, int value) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)LINE_IDENTIFIER));
        try {
            LINE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public DynamicObject getBinding(DynamicObject object) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)BINDING_IDENTIFIER));
        return (DynamicObject)BINDING_PROPERTY.get(object, this.isTracePoint(object));
    }

    @Override
    public void setBinding(DynamicObject object, DynamicObject value) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)BINDING_IDENTIFIER));
        try {
            BINDING_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public DynamicObject getProc(DynamicObject object) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)PROC_IDENTIFIER));
        return (DynamicObject)PROC_PROPERTY.get(object, this.isTracePoint(object));
    }

    @Override
    public void setProc(DynamicObject object, DynamicObject value) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)PROC_IDENTIFIER));
        try {
            PROC_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public Object getEventBinding(DynamicObject object) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)EVENT_BINDING_IDENTIFIER));
        return EVENT_BINDING_PROPERTY.get(object, this.isTracePoint(object));
    }

    @Override
    public void setEventBinding(DynamicObject object, Object value) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)EVENT_BINDING_IDENTIFIER));
        try {
            EVENT_BINDING_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public boolean getInsideProc(DynamicObject object) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)INSIDE_PROC_IDENTIFIER));
        return (Boolean)INSIDE_PROC_PROPERTY.get(object, this.isTracePoint(object));
    }

    @Override
    public void setInsideProc(DynamicObject object, boolean value) {
        assert (this.isTracePoint(object));
        assert (object.getShape().hasProperty((Object)INSIDE_PROC_IDENTIFIER));
        try {
            INSIDE_PROC_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class TracePointType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public TracePointType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public TracePointType setLogicalClass(DynamicObject logicalClass) {
            return new TracePointType(logicalClass, this.metaClass);
        }

        @Override
        public TracePointType setMetaClass(DynamicObject metaClass) {
            return new TracePointType(this.logicalClass, metaClass);
        }
    }
}

