/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.cast.ToIntRangeNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ToIntRangeNode.class)
public final class ToIntRangeNodeGen
extends ToIntRangeNode
implements SpecializedNode {
    @Node.Child
    private RubyNode range_;
    @Node.Child
    private BaseNode_ specialization_;

    private ToIntRangeNodeGen(RubyNode range) {
        this.range_ = range;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeToIntRange(VirtualFrame frameValue, DynamicObject rangeValue) {
        return this.specialization_.executeDynamicObject1(frameValue, rangeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ToIntRangeNode create(RubyNode range) {
        return new ToIntRangeNodeGen(range);
    }

    @GeneratedBy(methodName="objectRange(VirtualFrame, DynamicObject)", value=ToIntRangeNode.class)
    private static final class ObjectRangeNode_
    extends BaseNode_ {
        ObjectRangeNode_(ToIntRangeNodeGen root) {
            super(root, 3);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject rangeValue) {
            if (RubyGuards.isObjectRange(rangeValue)) {
                return this.root.objectRange(frameValue, rangeValue);
            }
            return this.getNext().executeDynamicObject1(frameValue, rangeValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object rangeValue) {
            DynamicObject rangeValue_;
            if (rangeValue instanceof DynamicObject && RubyGuards.isObjectRange(rangeValue_ = (DynamicObject)rangeValue)) {
                return this.root.objectRange(frameValue, rangeValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, rangeValue);
        }

        static BaseNode_ create(ToIntRangeNodeGen root) {
            return new ObjectRangeNode_(root);
        }
    }

    @GeneratedBy(methodName="longRange(VirtualFrame, DynamicObject)", value=ToIntRangeNode.class)
    private static final class LongRangeNode_
    extends BaseNode_ {
        LongRangeNode_(ToIntRangeNodeGen root) {
            super(root, 2);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject rangeValue) {
            if (RubyGuards.isLongRange(rangeValue)) {
                return this.root.longRange(frameValue, rangeValue);
            }
            return this.getNext().executeDynamicObject1(frameValue, rangeValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object rangeValue) {
            DynamicObject rangeValue_;
            if (rangeValue instanceof DynamicObject && RubyGuards.isLongRange(rangeValue_ = (DynamicObject)rangeValue)) {
                return this.root.longRange(frameValue, rangeValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, rangeValue);
        }

        static BaseNode_ create(ToIntRangeNodeGen root) {
            return new LongRangeNode_(root);
        }
    }

    @GeneratedBy(methodName="intRange(DynamicObject)", value=ToIntRangeNode.class)
    private static final class IntRangeNode_
    extends BaseNode_ {
        IntRangeNode_(ToIntRangeNodeGen root) {
            super(root, 1);
        }

        @Override
        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject rangeValue) {
            if (RubyGuards.isIntRange(rangeValue)) {
                return this.root.intRange(rangeValue);
            }
            return this.getNext().executeDynamicObject1(frameValue, rangeValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object rangeValue) {
            DynamicObject rangeValue_;
            if (rangeValue instanceof DynamicObject && RubyGuards.isIntRange(rangeValue_ = (DynamicObject)rangeValue)) {
                return this.root.intRange(rangeValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, rangeValue);
        }

        static BaseNode_ create(ToIntRangeNodeGen root) {
            return new IntRangeNode_(root);
        }
    }

    @GeneratedBy(value=ToIntRangeNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ToIntRangeNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object rangeValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, rangeValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object rangeValue) {
            return this.getNext().executeDynamicObject_(frameValue, rangeValue);
        }

        static BaseNode_ create(ToIntRangeNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ToIntRangeNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ToIntRangeNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object rangeValue) {
            return (DynamicObject)this.uninitialized((Frame)frameValue, rangeValue);
        }

        static BaseNode_ create(ToIntRangeNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ToIntRangeNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ToIntRangeNodeGen root;

        BaseNode_(ToIntRangeNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ToIntRangeNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.range_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object rangeValue) {
            return this.executeDynamicObject_((VirtualFrame)frameValue, rangeValue);
        }

        public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

        public DynamicObject executeDynamicObject1(VirtualFrame frameValue, DynamicObject rangeValue) {
            return this.executeDynamicObject_(frameValue, rangeValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object rangeValue_ = this.root.range_.execute(frameValue);
            return this.executeDynamicObject_(frameValue, rangeValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object rangeValue) {
            if (rangeValue instanceof DynamicObject) {
                DynamicObject rangeValue_ = (DynamicObject)rangeValue;
                if (RubyGuards.isIntRange(rangeValue_)) {
                    return IntRangeNode_.create(this.root);
                }
                if (RubyGuards.isLongRange(rangeValue_)) {
                    return LongRangeNode_.create(this.root);
                }
                if (RubyGuards.isObjectRange(rangeValue_)) {
                    return ObjectRangeNode_.create(this.root);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

