/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.tools.simpleshell;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.io.IOException;
import java.util.Collections;
import java.util.StringTokenizer;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.backtrace.Activation;
import org.jruby.truffle.language.backtrace.BacktraceFormatter;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.parser.ParserContext;
import org.jruby.truffle.tools.simpleshell.ConsoleShellInterface;
import org.jruby.truffle.tools.simpleshell.ShellInterface;
import org.jruby.truffle.tools.simpleshell.StandardShellInterface;
import org.jruby.truffle.util.StringUtils;

public class SimpleShell {
    private final RubyContext context;
    private final ShellInterface shellInterface;
    private int currentFrameIndex;
    private MaterializedFrame currentFrame;

    public SimpleShell(RubyContext context) {
        this.context = context;
        this.shellInterface = TruffleOptions.AOT || System.console() == null ? new StandardShellInterface() : new ConsoleShellInterface();
    }

    public void run(MaterializedFrame frame, Node currentNode) {
        this.currentFrameIndex = 0;
        this.currentFrame = frame;
        while (true) {
            String shellLine;
            try {
                shellLine = this.shellInterface.readLine("> ");
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(shellLine);
            if (!tokenizer.hasMoreElements()) continue;
            switch (tokenizer.nextToken()) {
                case "backtrace": {
                    BacktraceFormatter formatter = BacktraceFormatter.createDefaultFormatter(this.context);
                    int n = 0;
                    for (Activation activation : this.context.getCallStack().getBacktrace(currentNode).getActivations()) {
                        if (n == this.currentFrameIndex) {
                            this.shellInterface.getWriter().print("  \u25b6 ");
                        } else {
                            this.shellInterface.getWriter().printf("%3d ", n);
                        }
                        this.shellInterface.getWriter().println(formatter.formatLine(Collections.singletonList(activation), 0, null));
                        ++n;
                    }
                    break;
                }
                case "continue": {
                    return;
                }
                case "exit": {
                    System.exit(0);
                    break;
                }
                case "frame": {
                    throw new UnsupportedOperationException();
                }
                default: {
                    try {
                        String inspected;
                        RubyRootNode rootNode = this.context.getCodeLoader().parse(this.context.getSourceLoader().loadFragment(shellLine, "(shell)"), (Encoding)UTF8Encoding.INSTANCE, ParserContext.EVAL, this.currentFrame, false, currentNode);
                        CodeLoader.DeferredCall deferredCall = this.context.getCodeLoader().prepareExecute(ParserContext.EVAL, RubyArguments.getDeclarationContext((Frame)this.currentFrame), rootNode, this.currentFrame, RubyArguments.getSelf((Frame)this.currentFrame));
                        Object result = deferredCall.callWithoutCallNode();
                        try {
                            inspected = this.context.send(result, "inspect", null, new Object[0]).toString();
                        }
                        catch (Exception e) {
                            inspected = StringUtils.format("(error inspecting %s@%x %s)", result.getClass().getSimpleName(), result.hashCode(), e.toString());
                        }
                        this.shellInterface.getWriter().println(inspected);
                        break;
                    }
                    catch (RaiseException e) {
                        DynamicObject rubyException = e.getException();
                        BacktraceFormatter formatter = BacktraceFormatter.createDefaultFormatter(this.context);
                        formatter.printBacktrace(this.context, rubyException, Layouts.EXCEPTION.getBacktrace(rubyException), this.shellInterface.getWriter());
                    }
                }
            }
            this.shellInterface.getWriter().flush();
        }
    }
}

