/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.language.objects.AllocateObjectNode;

@CoreClass(value="Rubinius::AtomicReference")
public abstract class AtomicReferenceNodes {

    @CoreMethod(names={"get_and_set"}, required=1)
    public static abstract class GetAndSetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object getAndSet(DynamicObject self, Object value) {
            return Layouts.ATOMIC_REFERENCE.getAndSetValue(self, value);
        }
    }

    @CoreMethod(names={"compare_and_set"}, required=2)
    public static abstract class CompareAndSetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean compareAndSet(DynamicObject self, Object expectedValue, Object value) {
            return Layouts.ATOMIC_REFERENCE.compareAndSetValue(self, expectedValue, value);
        }
    }

    @CoreMethod(names={"set"}, required=1)
    public static abstract class SetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object set(DynamicObject self, Object value) {
            Layouts.ATOMIC_REFERENCE.setValue(self, value);
            return value;
        }
    }

    @CoreMethod(names={"get"})
    public static abstract class GetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object get(DynamicObject self) {
            return Layouts.ATOMIC_REFERENCE.getValue(self);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode = AllocateObjectNode.create();

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, new AtomicReference<DynamicObject>(this.nil()));
        }
    }
}

