/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.RetryException;
import org.jruby.truffle.language.exceptions.RescueNode;
import org.jruby.truffle.language.exceptions.SetExceptionVariableNode;
import org.jruby.truffle.language.methods.ExceptionTranslatingNode;

public class TryNode
extends RubyNode {
    @Node.Child
    private ExceptionTranslatingNode tryPart;
    @Node.Children
    private final RescueNode[] rescueParts;
    @Node.Child
    private RubyNode elsePart;
    @Node.Child
    private SetExceptionVariableNode setExceptionVariableNode;
    private final BranchProfile elseProfile = BranchProfile.create();
    private final BranchProfile controlFlowProfile = BranchProfile.create();
    private final BranchProfile raiseExceptionProfile = BranchProfile.create();

    public TryNode(RubyContext context, SourceSection sourceSection, ExceptionTranslatingNode tryPart, RescueNode[] rescueParts, RubyNode elsePart) {
        super(context, sourceSection);
        this.tryPart = tryPart;
        this.rescueParts = rescueParts;
        this.elsePart = elsePart;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result;
        while (true) {
            try {
                result = this.tryPart.execute(frame);
            }
            catch (RaiseException exception) {
                this.raiseExceptionProfile.enter();
                try {
                    return this.handleException(frame, exception);
                }
                catch (RetryException e) {
                    this.getContext().getSafepointManager().poll(this);
                    continue;
                }
            }
            catch (ControlFlowException exception) {
                this.controlFlowProfile.enter();
                throw exception;
            }
            break;
        }
        this.elseProfile.enter();
        if (this.elsePart != null) {
            result = this.elsePart.execute(frame);
        }
        return result;
    }

    @ExplodeLoop
    private Object handleException(VirtualFrame frame, RaiseException exception) {
        for (RescueNode rescue : this.rescueParts) {
            if (!rescue.canHandle(frame, exception.getException())) continue;
            return this.setLastExceptionAndRunRescue(frame, exception, rescue);
        }
        throw exception;
    }

    private Object setLastExceptionAndRunRescue(VirtualFrame frame, RaiseException exception, RubyNode rescue) {
        if (this.setExceptionVariableNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setExceptionVariableNode = (SetExceptionVariableNode)this.insert(new SetExceptionVariableNode(this.getContext()));
        }
        return this.setExceptionVariableNode.setLastExceptionAndRun(frame, exception, rescue);
    }
}

