/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;

public class RubyRootNode
extends RootNode {
    private final RubyContext context;
    private final SharedMethodInfo sharedMethodInfo;
    private final boolean needsDeclarationFrame;
    @Node.Child
    private RubyNode body;

    public RubyRootNode(RubyContext context, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, boolean needsDeclarationFrame) {
        super(RubyLanguage.class, sourceSection, frameDescriptor);
        assert (body != null);
        this.context = context;
        this.sharedMethodInfo = sharedMethodInfo;
        this.needsDeclarationFrame = needsDeclarationFrame;
        this.body = body;
        body.unsafeSetIsCall();
        body.unsafeSetIsRoot();
        if (context.getCallGraph() != null) {
            context.getCallGraph().registerRootNode(this);
        }
    }

    public Object execute(VirtualFrame frame) {
        this.context.getSafepointManager().poll((Node)this);
        return this.body.execute(frame);
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public boolean isCloningAllowed() {
        return true;
    }

    public Node copy() {
        RubyRootNode cloned = (RubyRootNode)super.copy();
        if (this.context.getCallGraph() != null) {
            this.context.getCallGraph().registerRootNode(cloned);
        }
        return cloned;
    }

    public String getName() {
        return this.sharedMethodInfo.getName();
    }

    public String toString() {
        return this.sharedMethodInfo.toString();
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public RubyNode getBody() {
        return this.body;
    }

    public boolean needsDeclarationFrame() {
        return this.needsDeclarationFrame;
    }

    public RubyContext getContext() {
        return this.context;
    }
}

