/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.joni.Matcher;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.regexp.RegexpGuards;
import org.jruby.truffle.core.regexp.RegexpNodes;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.util.StringUtils;

public abstract class RegexpPrimitiveNodes {

    @Primitive(name="regexp_set_block_last_match")
    public static abstract class RegexpSetBlockLastMatchPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject setBlockLastMatch(DynamicObject regexpClass) {
            return this.nil();
        }
    }

    @Primitive(name="regexp_set_last_match")
    public static abstract class RegexpSetLastMatchPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object setLastMatchData(DynamicObject regexpClass, Object matchData) {
            RegexpSetLastMatchPrimitiveNode.setLastMatch(this.getContext(), matchData);
            return matchData;
        }

        @CompilerDirectives.TruffleBoundary
        public static void setLastMatch(RubyContext context, Object matchData) {
            DynamicObject threadLocals = Layouts.THREAD.getThreadLocals(context.getThreadManager().getCurrentThread());
            boolean res = threadLocals.set((Object)"$~", matchData);
            assert (res);
        }
    }

    @Primitive(name="regexp_search_region", lowerFixnum={2, 3})
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpSearchRegionPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"!isInitialized(regexp)", "isRubyString(string)"})
        public Object searchRegionNotInitialized(DynamicObject regexp, DynamicObject string, int start, int end, boolean forward) {
            throw new RaiseException(this.coreExceptions().typeError("uninitialized Regexp", this));
        }

        @Specialization(guards={"isRubyString(string)", "!isValidEncoding(string)"})
        public Object searchRegionInvalidEncoding(DynamicObject regexp, DynamicObject string, int start, int end, boolean forward) {
            throw new RaiseException(this.coreExceptions().argumentError(this.formatError(string), this));
        }

        @CompilerDirectives.TruffleBoundary
        private String formatError(DynamicObject string) {
            return StringUtils.format("invalid byte sequence in %s", Layouts.STRING.getRope(string).getEncoding());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isInitialized(regexp)", "isRubyString(string)", "isValidEncoding(string)"})
        public Object searchRegion(DynamicObject regexp, DynamicObject string, int start, int end, boolean forward, @Cached(value="createX()") RopeNodes.MakeSubstringNode makeSubstringNode) {
            Matcher matcher = RegexpNodes.createMatcher(this.getContext(), regexp, string);
            if (forward) {
                return RegexpNodes.matchCommon(this.getContext(), this, makeSubstringNode, regexp, string, false, false, matcher, start, end);
            }
            return RegexpNodes.matchCommon(this.getContext(), this, makeSubstringNode, regexp, string, false, false, matcher, end, start);
        }
    }

    @Primitive(name="regexp_propagate_last_match")
    public static abstract class RegexpPropagateLastMatchPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject propagateLastMatch(DynamicObject regexpClass) {
            return this.nil();
        }
    }

    @Primitive(name="regexp_options")
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpOptionsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isInitialized(regexp)"})
        public int options(DynamicObject regexp) {
            return Layouts.REGEXP.getOptions(regexp).toOptions();
        }

        @Specialization(guards={"!isInitialized(regexp)"})
        public int optionsNotInitialized(DynamicObject regexp) {
            throw new RaiseException(this.coreExceptions().typeError("uninitialized Regexp", this));
        }
    }

    @Primitive(name="regexp_initialize", lowerFixnum={2})
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpInitializePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRegexpLiteral(regexp)", "isRubyString(pattern)"})
        public DynamicObject initializeRegexpLiteral(DynamicObject regexp, DynamicObject pattern, int options) {
            throw new RaiseException(this.coreExceptions().securityError("can't modify literal regexp", this));
        }

        @Specialization(guards={"!isRegexpLiteral(regexp)", "isInitialized(regexp)", "isRubyString(pattern)"})
        public DynamicObject initializeAlreadyInitialized(DynamicObject regexp, DynamicObject pattern, int options) {
            throw new RaiseException(this.coreExceptions().typeError("already initialized regexp", this));
        }

        @Specialization(guards={"!isRegexpLiteral(regexp)", "!isInitialized(regexp)", "isRubyString(pattern)"})
        public DynamicObject initialize(DynamicObject regexp, DynamicObject pattern, int options) {
            RegexpNodes.initialize(this.getContext(), regexp, this, StringOperations.rope(pattern), options);
            return regexp;
        }
    }

    @Primitive(name="regexp_fixed_encoding_p")
    public static abstract class RegexpFixedEncodingPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public boolean fixedEncoding(DynamicObject regexp) {
            return Layouts.REGEXP.getOptions(regexp).isFixed();
        }
    }
}

