/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;

public abstract class EncodingOperations {
    public static Encoding getEncoding(DynamicObject rubyEncoding) {
        Encoding encoding = Layouts.ENCODING.getEncoding(rubyEncoding);
        if (encoding == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Rope name = StringOperations.rope(Layouts.ENCODING.getName(rubyEncoding));
            encoding = EncodingOperations.loadEncoding(name);
            Layouts.ENCODING.setEncoding(rubyEncoding, encoding);
        }
        return encoding;
    }

    @CompilerDirectives.TruffleBoundary
    private static EncodingDB.Entry findEncodingEntry(Rope name) {
        return (EncodingDB.Entry)EncodingDB.getEncodings().get(name.getBytes(), 0, name.byteLength());
    }

    @CompilerDirectives.TruffleBoundary
    private static EncodingDB.Entry findAliasEntry(Rope name) {
        return (EncodingDB.Entry)EncodingDB.getAliases().get(name.getBytes(), 0, name.byteLength());
    }

    private static EncodingDB.Entry findEncodingOrAliasEntry(Rope name) {
        EncodingDB.Entry e = EncodingOperations.findEncodingEntry(name);
        return e != null ? e : EncodingOperations.findAliasEntry(name);
    }

    @CompilerDirectives.TruffleBoundary
    private static Encoding loadEncoding(Rope name) {
        EncodingDB.Entry entry = EncodingOperations.findEncodingOrAliasEntry(name);
        if (entry == null) {
            return null;
        }
        return entry.getEncoding();
    }
}

