/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.object.DynamicObject;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.truffle.builtins.PrimitiveManager;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.encoding.EncodingManager;
import org.jruby.truffle.core.exception.CoreExceptions;
import org.jruby.truffle.core.kernel.AtExitManager;
import org.jruby.truffle.core.kernel.TraceManager;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.core.objectspace.ObjectSpaceManager;
import org.jruby.truffle.core.rope.RopeTable;
import org.jruby.truffle.core.string.CoreStrings;
import org.jruby.truffle.core.string.FrozenStrings;
import org.jruby.truffle.core.symbol.SymbolTable;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.extra.AttachmentsManager;
import org.jruby.truffle.interop.InteropManager;
import org.jruby.truffle.interop.JRubyInterop;
import org.jruby.truffle.language.CallStackManager;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.Options;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.SafepointManager;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.loader.FeatureLoader;
import org.jruby.truffle.language.loader.SourceCache;
import org.jruby.truffle.language.loader.SourceLoader;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.platform.NativePlatform;
import org.jruby.truffle.platform.NativePlatformFactory;
import org.jruby.truffle.stdlib.CoverageManager;
import org.jruby.truffle.tools.InstrumentationServerManager;
import org.jruby.truffle.tools.callgraph.CallGraph;
import org.jruby.truffle.tools.callgraph.SimpleWriter;

public class RubyContext
extends ExecutionContext {
    private static volatile RubyContext latestInstance;
    private final TruffleLanguage.Env env;
    private final Ruby jrubyRuntime;
    private final Options options = new Options();
    private final RopeTable ropeTable = new RopeTable();
    private final PrimitiveManager primitiveManager = new PrimitiveManager();
    private final JRubyInterop jrubyInterop = new JRubyInterop(this);
    private final SafepointManager safepointManager = new SafepointManager(this);
    private final SymbolTable symbolTable;
    private final InteropManager interopManager = new InteropManager(this);
    private final CodeLoader codeLoader = new CodeLoader(this);
    private final FeatureLoader featureLoader = new FeatureLoader(this);
    private final TraceManager traceManager;
    private final ObjectSpaceManager objectSpaceManager = new ObjectSpaceManager(this);
    private final AtExitManager atExitManager = new AtExitManager(this);
    private final SourceLoader sourceLoader = new SourceLoader(this);
    private final SourceCache sourceCache = new SourceCache(this.sourceLoader);
    private final CallStackManager callStack = new CallStackManager(this);
    private final CoreStrings coreStrings = new CoreStrings(this);
    private final FrozenStrings frozenStrings = new FrozenStrings(this);
    private final CoreExceptions coreExceptions = new CoreExceptions(this);
    private final EncodingManager encodingManager = new EncodingManager(this);
    private final CompilerOptions compilerOptions = Truffle.getRuntime().createCompilerOptions();
    private final NativePlatform nativePlatform;
    private final CoreLibrary coreLibrary;
    private final ThreadManager threadManager;
    private final LexicalScope rootLexicalScope;
    private final InstrumentationServerManager instrumentationServerManager;
    private final CallGraph callGraph;
    private final PrintStream debugStandardOut;
    private final CoverageManager coverageManager;
    private final Object classVariableDefinitionLock = new Object();
    private final AttachmentsManager attachmentsManager;

    public RubyContext(Ruby jrubyRuntime, TruffleLanguage.Env env) {
        latestInstance = this;
        this.jrubyRuntime = jrubyRuntime;
        this.env = env;
        this.callGraph = this.options.CALL_GRAPH ? new CallGraph() : null;
        if (this.compilerOptions.supportsOption("MinTimeThreshold")) {
            this.compilerOptions.setOption("MinTimeThreshold", (Object)100000000);
        }
        if (this.compilerOptions.supportsOption("MinInliningMaxCallerSize")) {
            this.compilerOptions.setOption("MinInliningMaxCallerSize", (Object)5000);
        }
        this.coreLibrary = new CoreLibrary(this);
        this.coreLibrary.initialize();
        this.symbolTable = new SymbolTable(this.coreLibrary.getSymbolFactory());
        this.nativePlatform = NativePlatformFactory.createPlatform(this);
        this.rootLexicalScope = new LexicalScope(null, this.coreLibrary.getObjectClass());
        this.threadManager = new ThreadManager(this);
        this.threadManager.initialize();
        Main.printTruffleTimeMetric((String)"before-load-primitives");
        this.coreLibrary.addPrimitives();
        Main.printTruffleTimeMetric((String)"after-load-primitives");
        Main.printTruffleTimeMetric((String)"before-load-nodes");
        this.coreLibrary.addCoreMethods();
        Main.printTruffleTimeMetric((String)"after-load-nodes");
        this.coreLibrary.loadRubyCore();
        PrintStream configStandardOut = jrubyRuntime.getInstanceConfig().getOutput();
        PrintStream printStream = this.debugStandardOut = configStandardOut == System.out ? null : configStandardOut;
        if (this.options.INSTRUMENTATION_SERVER_PORT != 0) {
            this.instrumentationServerManager = new InstrumentationServerManager(this, this.options.INSTRUMENTATION_SERVER_PORT);
            this.instrumentationServerManager.start();
        } else {
            this.instrumentationServerManager = null;
        }
        Instrumenter instrumenter = (Instrumenter)env.lookup(Instrumenter.class);
        this.attachmentsManager = new AttachmentsManager(this, instrumenter);
        this.traceManager = new TraceManager(this, instrumenter);
        this.coverageManager = new CoverageManager(this, instrumenter);
        this.coreLibrary.initializePostBoot();
    }

    public Object send(Object object, String methodName, DynamicObject block, Object ... arguments) {
        CompilerAsserts.neverPartOfCompilation();
        assert (block == null || RubyGuards.isRubyProc(block));
        InternalMethod method = ModuleOperations.lookupMethod(this.coreLibrary.getMetaClass(object), methodName);
        if (method == null || method.isUndefined()) {
            return null;
        }
        return method.getCallTarget().call(RubyArguments.pack(null, null, method, DeclarationContext.METHOD, null, object, block, arguments));
    }

    public void shutdown() {
        if (this.getOptions().ROPE_PRINT_INTERN_STATS) {
            System.out.println("Ropes re-used: " + this.getRopeTable().getRopesReusedCount());
            System.out.println("Rope byte arrays re-used: " + this.getRopeTable().getByteArrayReusedCount());
            System.out.println("Rope bytes saved: " + this.getRopeTable().getRopeBytesSaved());
            System.out.println("Total ropes interned: " + this.getRopeTable().totalRopes());
        }
        this.atExitManager.runSystemExitHooks();
        if (this.instrumentationServerManager != null) {
            this.instrumentationServerManager.shutdown();
        }
        this.threadManager.shutdown();
        if (this.options.COVERAGE_GLOBAL) {
            this.coverageManager.print(System.out);
        }
        if (this.callGraph != null) {
            this.callGraph.resolve();
            if (this.options.CALL_GRAPH_WRITE != null) {
                try (PrintStream stream = new PrintStream(this.options.CALL_GRAPH_WRITE, StandardCharsets.UTF_8.name());){
                    new SimpleWriter(this.callGraph, stream).write();
                }
                catch (FileNotFoundException | UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public TruffleLanguage.Env getEnv() {
        return this.env;
    }

    public NativePlatform getNativePlatform() {
        return this.nativePlatform;
    }

    public JRubyInterop getJRubyInterop() {
        return this.jrubyInterop;
    }

    public Ruby getJRubyRuntime() {
        return this.jrubyRuntime;
    }

    public CoreLibrary getCoreLibrary() {
        return this.coreLibrary;
    }

    public PrintStream getDebugStandardOut() {
        return this.debugStandardOut;
    }

    public FeatureLoader getFeatureLoader() {
        return this.featureLoader;
    }

    public ObjectSpaceManager getObjectSpaceManager() {
        return this.objectSpaceManager;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public AtExitManager getAtExitManager() {
        return this.atExitManager;
    }

    public TraceManager getTraceManager() {
        return this.traceManager;
    }

    public SafepointManager getSafepointManager() {
        return this.safepointManager;
    }

    public LexicalScope getRootLexicalScope() {
        return this.rootLexicalScope;
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public PrimitiveManager getPrimitiveManager() {
        return this.primitiveManager;
    }

    public CoverageManager getCoverageManager() {
        return this.coverageManager;
    }

    public static RubyContext getLatestInstance() {
        return latestInstance;
    }

    public AttachmentsManager getAttachmentsManager() {
        return this.attachmentsManager;
    }

    public SourceLoader getSourceLoader() {
        return this.sourceLoader;
    }

    public SourceCache getSourceCache() {
        return this.sourceCache;
    }

    public RopeTable getRopeTable() {
        return this.ropeTable;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public CodeLoader getCodeLoader() {
        return this.codeLoader;
    }

    public InteropManager getInteropManager() {
        return this.interopManager;
    }

    public CallStackManager getCallStack() {
        return this.callStack;
    }

    public CoreStrings getCoreStrings() {
        return this.coreStrings;
    }

    public FrozenStrings getFrozenStrings() {
        return this.frozenStrings;
    }

    public Object getClassVariableDefinitionLock() {
        return this.classVariableDefinitionLock;
    }

    public Instrumenter getInstrumenter() {
        return (Instrumenter)this.env.lookup(Instrumenter.class);
    }

    public CoreExceptions getCoreExceptions() {
        return this.coreExceptions;
    }

    public EncodingManager getEncodingManager() {
        return this.encodingManager;
    }
}

