/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.supercall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.cast.ProcOrNullNode;
import org.jruby.truffle.core.cast.ProcOrNullNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.methods.CallInternalMethodNode;
import org.jruby.truffle.language.methods.CallInternalMethodNodeGen;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.supercall.LookupSuperMethodNode;
import org.jruby.truffle.language.supercall.LookupSuperMethodNodeGen;

public class SuperCallNode
extends RubyNode {
    private final ConditionProfile missingProfile = ConditionProfile.createBinaryProfile();
    @Node.Child
    private RubyNode arguments;
    @Node.Child
    private RubyNode block;
    @Node.Child
    ProcOrNullNode procOrNullNode;
    @Node.Child
    LookupSuperMethodNode lookupSuperMethodNode;
    @Node.Child
    CallInternalMethodNode callMethodNode;
    @Node.Child
    CallDispatchHeadNode callMethodMissingNode;

    public SuperCallNode(RubyContext context, SourceSection sourceSection, RubyNode arguments, RubyNode block) {
        super(context, sourceSection);
        this.arguments = arguments;
        this.block = block;
        this.procOrNullNode = ProcOrNullNodeGen.create(context, sourceSection, null);
        this.lookupSuperMethodNode = LookupSuperMethodNodeGen.create(context, sourceSection, null);
        this.callMethodNode = CallInternalMethodNodeGen.create(context, sourceSection, null, new RubyNode[0]);
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        Object self = RubyArguments.getSelf((Frame)frame);
        Object[] superArguments = (Object[])this.arguments.execute(frame);
        DynamicObject blockObject = this.procOrNullNode.executeProcOrNull(this.block.execute(frame));
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (this.missingProfile.profile(superMethod == null)) {
            String name = RubyArguments.getMethod((Frame)frame).getSharedMethodInfo().getName();
            Object[] methodMissingArguments = ArrayUtils.unshift(superArguments, this.getContext().getSymbolTable().getSymbol(name));
            return this.callMethodMissing(frame, self, blockObject, methodMissingArguments);
        }
        Object[] frameArguments = RubyArguments.pack(null, null, superMethod, DeclarationContext.METHOD, null, self, blockObject, superArguments);
        return this.callMethodNode.executeCallMethod(frame, superMethod, frameArguments);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object self = RubyArguments.getSelf((Frame)frame);
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            return this.nil();
        }
        return this.create7BitString("super", (Encoding)UTF8Encoding.INSTANCE);
    }

    private Object callMethodMissing(VirtualFrame frame, Object receiver, DynamicObject block, Object[] arguments) {
        if (this.callMethodMissingNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.callMethodMissingNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
        }
        return this.callMethodMissingNode.call(frame, receiver, "method_missing", block, arguments);
    }
}

