/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.module;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.HashMap;
import java.util.Map;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.module.ModuleFields;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.util.IdUtil;
import org.jruby.util.func.Function1;

public abstract class ModuleOperations {
    public static boolean includesModule(DynamicObject module, DynamicObject other) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        for (DynamicObject ancestor : Layouts.MODULE.getFields(module).ancestors()) {
            if (ancestor != other) continue;
            return true;
        }
        return false;
    }

    public static boolean assignableTo(DynamicObject thisClass, DynamicObject otherClass) {
        return ModuleOperations.includesModule(thisClass, otherClass);
    }

    public static boolean canBindMethodTo(DynamicObject origin, DynamicObject module) {
        assert (RubyGuards.isRubyModule(origin));
        assert (RubyGuards.isRubyModule(module));
        if (!RubyGuards.isRubyClass(origin)) {
            return true;
        }
        return RubyGuards.isRubyClass(module) && ModuleOperations.assignableTo(module, origin);
    }

    @CompilerDirectives.TruffleBoundary
    public static Iterable<Map.Entry<String, RubyConstant>> getAllConstants(DynamicObject module) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        HashMap<String, RubyConstant> constants = new HashMap<String, RubyConstant>();
        for (Map.Entry<String, RubyConstant> constant : Layouts.MODULE.getFields(module).getConstants()) {
            constants.put(constant.getKey(), constant.getValue());
        }
        for (DynamicObject ancestor : Layouts.MODULE.getFields(module).prependedAndIncludedModules()) {
            for (Map.Entry<String, RubyConstant> constant : Layouts.MODULE.getFields(ancestor).getConstants()) {
                if (constants.containsKey(constant.getKey())) continue;
                constants.put(constant.getKey(), constant.getValue());
            }
        }
        return constants.entrySet();
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyConstant lookupConstant(RubyContext context, DynamicObject module, String name) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        RubyConstant constant = Layouts.MODULE.getFields(module).getConstant(name);
        if (constant != null) {
            return constant;
        }
        for (DynamicObject ancestor : Layouts.MODULE.getFields(module).parentAncestors()) {
            constant = Layouts.MODULE.getFields(ancestor).getConstant(name);
            if (constant == null) continue;
            return constant;
        }
        return null;
    }

    private static RubyConstant lookupConstantInObject(RubyContext context, DynamicObject module, String name) {
        if (!RubyGuards.isRubyClass(module)) {
            DynamicObject objectClass = context.getCoreLibrary().getObjectClass();
            RubyConstant constant = Layouts.MODULE.getFields(objectClass).getConstant(name);
            if (constant != null) {
                return constant;
            }
            for (DynamicObject ancestor : Layouts.MODULE.getFields(objectClass).prependedAndIncludedModules()) {
                constant = Layouts.MODULE.getFields(ancestor).getConstant(name);
                if (constant == null) continue;
                return constant;
            }
        }
        return null;
    }

    public static RubyConstant lookupConstantAndObject(RubyContext context, DynamicObject module, String name) {
        RubyConstant constant = ModuleOperations.lookupConstant(context, module, name);
        if (constant != null) {
            return constant;
        }
        return ModuleOperations.lookupConstantInObject(context, module, name);
    }

    @CompilerDirectives.TruffleBoundary
    public static RubyConstant lookupConstantWithLexicalScope(RubyContext context, LexicalScope lexicalScope, String name) {
        CompilerAsserts.neverPartOfCompilation();
        DynamicObject module = lexicalScope.getLiveModule();
        RubyConstant constant = null;
        while (lexicalScope != context.getRootLexicalScope()) {
            constant = Layouts.MODULE.getFields(lexicalScope.getLiveModule()).getConstant(name);
            if (constant != null) {
                return constant;
            }
            lexicalScope = lexicalScope.getParent();
        }
        return ModuleOperations.lookupConstantAndObject(context, module, name);
    }

    public static RubyConstant lookupScopedConstant(RubyContext context, DynamicObject module, String fullName, boolean inherit, Node currentNode) {
        int next;
        CompilerAsserts.neverPartOfCompilation();
        int start = 0;
        if (fullName.startsWith("::")) {
            module = context.getCoreLibrary().getObjectClass();
            start += 2;
        }
        while ((next = fullName.indexOf("::", start)) != -1) {
            String segment = fullName.substring(start, next);
            RubyConstant constant = ModuleOperations.lookupConstantWithInherit(context, module, segment, inherit, currentNode);
            if (constant == null) {
                return null;
            }
            if (!RubyGuards.isRubyModule(constant.getValue())) {
                throw new RaiseException(context.getCoreExceptions().typeError(fullName.substring(0, next) + " does not refer to class/module", currentNode));
            }
            module = (DynamicObject)constant.getValue();
            start = next + 2;
        }
        String lastSegment = fullName.substring(start);
        if (!IdUtil.isValidConstantName19((String)lastSegment)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(context.getCoreExceptions().nameError(String.format("wrong constant name %s", fullName), fullName, currentNode));
        }
        return ModuleOperations.lookupConstantWithInherit(context, module, lastSegment, inherit, currentNode);
    }

    public static RubyConstant lookupConstantWithInherit(RubyContext context, DynamicObject module, String name, boolean inherit, Node currentNode) {
        assert (RubyGuards.isRubyModule(module));
        if (!IdUtil.isValidConstantName19((String)name)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(context.getCoreExceptions().nameError(String.format("wrong constant name %s", name), name, currentNode));
        }
        if (inherit) {
            return ModuleOperations.lookupConstantAndObject(context, module, name);
        }
        return Layouts.MODULE.getFields(module).getConstant(name);
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> getAllMethods(DynamicObject module) {
        assert (RubyGuards.isRubyModule(module));
        HashMap<String, InternalMethod> methods = new HashMap<String, InternalMethod>();
        for (DynamicObject ancestor : Layouts.MODULE.getFields(module).ancestors()) {
            for (InternalMethod method : Layouts.MODULE.getFields(ancestor).getMethods()) {
                if (methods.containsKey(method.getName())) continue;
                methods.put(method.getName(), method);
            }
        }
        return methods;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> getMethodsBeforeLogicalClass(DynamicObject module) {
        assert (RubyGuards.isRubyModule(module));
        HashMap<String, InternalMethod> methods = new HashMap<String, InternalMethod>();
        for (DynamicObject ancestor : Layouts.MODULE.getFields(module).ancestors()) {
            if (RubyGuards.isRubyClass(ancestor) && !Layouts.CLASS.getIsSingleton(ancestor)) break;
            for (InternalMethod method : Layouts.MODULE.getFields(ancestor).getMethods()) {
                if (methods.containsKey(method.getName())) continue;
                methods.put(method.getName(), method);
            }
        }
        return methods;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> getMethodsUntilLogicalClass(DynamicObject module) {
        assert (RubyGuards.isRubyModule(module));
        HashMap<String, InternalMethod> methods = new HashMap<String, InternalMethod>();
        for (DynamicObject ancestor : Layouts.MODULE.getFields(module).ancestors()) {
            for (InternalMethod method : Layouts.MODULE.getFields(ancestor).getMethods()) {
                if (methods.containsKey(method.getName())) continue;
                methods.put(method.getName(), method);
            }
            if (!RubyGuards.isRubyClass(ancestor) || Layouts.CLASS.getIsSingleton(ancestor)) continue;
            break;
        }
        return methods;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, InternalMethod> withoutUndefinedMethods(Map<String, InternalMethod> methods) {
        HashMap<String, InternalMethod> definedMethods = new HashMap<String, InternalMethod>();
        for (Map.Entry<String, InternalMethod> method : methods.entrySet()) {
            if (method.getValue().isUndefined()) continue;
            definedMethods.put(method.getKey(), method.getValue());
        }
        return definedMethods;
    }

    @CompilerDirectives.TruffleBoundary
    public static InternalMethod lookupMethod(DynamicObject module, String name) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        for (DynamicObject ancestor : Layouts.MODULE.getFields(module).ancestors()) {
            InternalMethod method = Layouts.MODULE.getFields(ancestor).getMethod(name);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static InternalMethod lookupMethod(DynamicObject module, String name, Visibility visibility) {
        InternalMethod method = ModuleOperations.lookupMethod(module, name);
        return method != null && method.getVisibility() == visibility ? method : null;
    }

    public static InternalMethod lookupSuperMethod(InternalMethod currentMethod, DynamicObject objectMetaClass) {
        assert (RubyGuards.isRubyClass(objectMetaClass));
        String name = currentMethod.getSharedMethodInfo().getName();
        return ModuleOperations.lookupSuperMethod(currentMethod.getDeclaringModule(), name, objectMetaClass);
    }

    @CompilerDirectives.TruffleBoundary
    public static InternalMethod lookupSuperMethod(DynamicObject declaringModule, String name, DynamicObject objectMetaClass) {
        assert (RubyGuards.isRubyModule(declaringModule));
        assert (RubyGuards.isRubyClass(objectMetaClass));
        boolean foundDeclaringModule = false;
        for (DynamicObject module : Layouts.MODULE.getFields(objectMetaClass).ancestors()) {
            InternalMethod method;
            if (module == declaringModule) {
                foundDeclaringModule = true;
                continue;
            }
            if (!foundDeclaringModule || (method = Layouts.MODULE.getFields(module).getMethod(name)) == null) continue;
            return method;
        }
        assert (foundDeclaringModule) : "Did not find the declaring module in " + Layouts.MODULE.getFields(objectMetaClass).getName() + " ancestors";
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, Object> getAllClassVariables(DynamicObject module) {
        CompilerAsserts.neverPartOfCompilation();
        assert (RubyGuards.isRubyModule(module));
        final HashMap<String, Object> classVariables = new HashMap<String, Object>();
        ModuleOperations.classVariableLookup(module, new Function1<Object, DynamicObject>(){

            public Object apply(DynamicObject module) {
                classVariables.putAll(Layouts.MODULE.getFields(module).getClassVariables());
                return null;
            }
        });
        return classVariables;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object lookupClassVariable(DynamicObject module, final String name) {
        assert (RubyGuards.isRubyModule(module));
        return ModuleOperations.classVariableLookup(module, new Function1<Object, DynamicObject>(){

            public Object apply(DynamicObject module) {
                return Layouts.MODULE.getFields(module).getClassVariables().get(name);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
    public static void setClassVariable(RubyContext context, DynamicObject module, String name, Object value, Node currentNode) {
        assert (RubyGuards.isRubyModule(module));
        ModuleFields moduleFields = Layouts.MODULE.getFields(module);
        moduleFields.checkFrozen(context, currentNode);
        if (!ModuleOperations.trySetClassVariable(module, name, value)) {
            Object object = context.getClassVariableDefinitionLock();
            synchronized (object) {
                if (!ModuleOperations.trySetClassVariable(module, name, value)) {
                    moduleFields.getClassVariables().put(name, value);
                }
            }
        }
    }

    private static boolean trySetClassVariable(DynamicObject topModule, final String name, final Object value) {
        DynamicObject found = ModuleOperations.classVariableLookup(topModule, new Function1<DynamicObject, DynamicObject>(){

            public DynamicObject apply(DynamicObject module) {
                ModuleFields moduleFields = Layouts.MODULE.getFields(module);
                if (moduleFields.getClassVariables().replace(name, value) != null) {
                    return module;
                }
                return null;
            }
        });
        return found != null;
    }

    @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
    public static Object removeClassVariable(ModuleFields moduleFields, RubyContext context, Node currentNode, String name) {
        moduleFields.checkFrozen(context, currentNode);
        Object found = moduleFields.getClassVariables().remove(name);
        if (found == null) {
            throw new RaiseException(context.getCoreExceptions().nameErrorClassVariableNotDefined(name, moduleFields.rubyModuleObject, currentNode));
        }
        return found;
    }

    private static <R> R classVariableLookup(DynamicObject module, Function1<R, DynamicObject> action) {
        DynamicObject klass;
        CompilerAsserts.neverPartOfCompilation();
        Object result = action.apply((Object)module);
        if (result != null) {
            return (R)result;
        }
        if (RubyGuards.isRubyClass(module) && Layouts.CLASS.getIsSingleton(klass = module) && Layouts.MODULE.isModule(Layouts.CLASS.getAttached(klass)) && (result = action.apply((Object)(module = Layouts.CLASS.getAttached(klass)))) != null) {
            return (R)result;
        }
        for (DynamicObject ancestor : Layouts.MODULE.getFields(module).parentAncestors()) {
            result = action.apply((Object)ancestor);
            if (result == null) continue;
            return (R)result;
        }
        return null;
    }

    public static boolean isMethodPrivateFromName(String name) {
        CompilerAsserts.neverPartOfCompilation();
        return name.equals("initialize") || name.equals("initialize_copy") || name.equals("initialize_clone") || name.equals("initialize_dup") || name.equals("respond_to_missing?");
    }
}

