/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.AmbiguousOptionalArgumentChecker;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.ReturnEnumeratorIfNoBlockNode;
import org.jruby.truffle.builtins.UnsafeNode;
import org.jruby.truffle.core.RaiseIfFrozenNode;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.cast.TaintResultNode;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.core.numeric.FixnumLowerNodeGen;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.Options;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ReadBlockNode;
import org.jruby.truffle.language.arguments.ReadCallerFrameNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.arguments.ReadRemainingArgumentsNode;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.ExceptionTranslatingNode;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.objects.SelfNode;
import org.jruby.truffle.language.objects.SingletonClassNode;
import org.jruby.truffle.language.parser.jruby.Translator;
import org.jruby.truffle.platform.UnsafeGroup;

public class CoreMethodNodeManager {
    private final RubyContext context;
    private final SingletonClassNode singletonClassNode;

    public CoreMethodNodeManager(RubyContext context, SingletonClassNode singletonClassNode) {
        this.context = context;
        this.singletonClassNode = singletonClassNode;
    }

    public void addCoreMethodNodes(List<? extends NodeFactory<? extends RubyNode>> nodeFactories) {
        for (NodeFactory<? extends RubyNode> nodeFactory : nodeFactories) {
            GeneratedBy generatedBy = nodeFactory.getClass().getAnnotation(GeneratedBy.class);
            Class nodeClass = generatedBy.value();
            CoreClass classAnnotation = nodeClass.getEnclosingClass().getAnnotation(CoreClass.class);
            CoreMethod methodAnnotation = nodeClass.getAnnotation(CoreMethod.class);
            if (methodAnnotation == null) continue;
            this.addCoreMethod(new MethodDetails(classAnnotation, methodAnnotation, nodeFactory));
        }
    }

    private DynamicObject getSingletonClass(Object object) {
        return this.singletonClassNode.executeSingletonClass(object);
    }

    private void addCoreMethod(MethodDetails methodDetails) {
        DynamicObject module;
        String fullName = methodDetails.getClassAnnotation().value();
        if (fullName.equals("main")) {
            module = this.getSingletonClass(this.context.getCoreLibrary().getMainObject());
        } else {
            module = this.context.getCoreLibrary().getObjectClass();
            for (String moduleName : fullName.split("::")) {
                RubyConstant constant = ModuleOperations.lookupConstant(this.context, module, moduleName);
                if (constant == null) {
                    throw new RuntimeException(String.format("Module %s not found when adding core library", moduleName));
                }
                module = (DynamicObject)constant.getValue();
            }
        }
        assert (RubyGuards.isRubyModule(module)) : fullName;
        CoreMethod method = methodDetails.getMethodAnnotation();
        List<String> names = Arrays.asList(method.names());
        assert (names.size() >= 1);
        Visibility visibility = method.visibility();
        if (method.isModuleFunction()) {
            if (visibility != Visibility.PUBLIC) {
                System.err.println("WARNING: visibility ignored when isModuleFunction in " + methodDetails.getIndicativeName());
            }
            if (method.onSingleton()) {
                System.err.println("WARNING: Either onSingleton or isModuleFunction for " + methodDetails.getIndicativeName());
            }
            if (method.constructor()) {
                System.err.println("WARNING: Either constructor or isModuleFunction for " + methodDetails.getIndicativeName());
            }
            if (RubyGuards.isRubyClass(module)) {
                System.err.println("WARNING: Using isModuleFunction on a Class for " + methodDetails.getIndicativeName());
            }
        }
        if (method.onSingleton() && method.constructor()) {
            System.err.println("WARNING: Either onSingleton or constructor for " + methodDetails.getIndicativeName());
        }
        RubyRootNode rootNode = CoreMethodNodeManager.makeGenericMethod(this.context, methodDetails);
        if (method.isModuleFunction()) {
            CoreMethodNodeManager.addMethod(this.context, module, rootNode, names, Visibility.PRIVATE);
            CoreMethodNodeManager.addMethod(this.context, this.getSingletonClass(module), rootNode, names, Visibility.PUBLIC);
        } else if (method.onSingleton() || method.constructor()) {
            CoreMethodNodeManager.addMethod(this.context, this.getSingletonClass(module), rootNode, names, visibility);
        } else {
            CoreMethodNodeManager.addMethod(this.context, module, rootNode, names, visibility);
        }
    }

    private static void addMethod(RubyContext context, DynamicObject module, RubyRootNode rootNode, List<String> names, Visibility originalVisibility) {
        assert (RubyGuards.isRubyModule(module));
        for (String name : names) {
            RubyRootNode rootNodeCopy = (RubyRootNode)NodeUtil.cloneNode((Node)rootNode);
            Visibility visibility = originalVisibility;
            if (ModuleOperations.isMethodPrivateFromName(name)) {
                visibility = Visibility.PRIVATE;
            }
            InternalMethod method = new InternalMethod(rootNodeCopy.getSharedMethodInfo(), name, module, visibility, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNodeCopy));
            Layouts.MODULE.getFields(module).addMethod(context, null, method.withVisibility(visibility).withName(name));
        }
    }

    private static RubyRootNode makeGenericMethod(RubyContext context, MethodDetails methodDetails) {
        RubyNode sequence;
        RubyNode methodNode;
        boolean needsSelf;
        CoreMethod method = methodDetails.getMethodAnnotation();
        SourceSection sourceSection = SourceSection.createUnavailable(null, (String)String.format("%s#%s", methodDetails.getClassAnnotation().value(), method.names()[0]));
        int required = method.required();
        int optional = method.optional();
        boolean needsCallerFrame = method.needsCallerFrame();
        boolean alwaysInline = needsCallerFrame && context.getOptions().INLINE_NEEDS_CALLER_FRAME;
        Arity arity = new Arity(required, optional, method.rest());
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, LexicalScope.NONE, arity, method.names()[0], false, null, context.getOptions().CORE_ALWAYS_CLONE, alwaysInline, needsCallerFrame);
        ArrayList<RubyNode> argumentsNodes = new ArrayList<RubyNode>();
        if (needsCallerFrame) {
            argumentsNodes.add(new ReadCallerFrameNode());
        }
        boolean bl = needsSelf = method.constructor() || !method.isModuleFunction() && !method.onSingleton() && method.needsSelf();
        if (needsSelf) {
            RubyNode readSelfNode = new SelfNode(context, sourceSection);
            if (method.lowerFixnumSelf()) {
                readSelfNode = FixnumLowerNodeGen.create(context, sourceSection, readSelfNode);
            }
            if (method.raiseIfFrozenSelf()) {
                readSelfNode = new RaiseIfFrozenNode(readSelfNode);
            }
            argumentsNodes.add(readSelfNode);
        }
        for (int n = 0; n < arity.getPreRequired() + arity.getOptional(); ++n) {
            RubyNode readArgumentNode = new ReadPreArgumentNode(n, MissingArgumentBehavior.UNDEFINED);
            if (ArrayUtils.contains(method.lowerFixnumParameters(), n)) {
                readArgumentNode = FixnumLowerNodeGen.create(context, sourceSection, readArgumentNode);
            }
            if (ArrayUtils.contains(method.raiseIfFrozenParameters(), n)) {
                readArgumentNode = new RaiseIfFrozenNode(readArgumentNode);
            }
            argumentsNodes.add(readArgumentNode);
        }
        if (method.rest()) {
            argumentsNodes.add(new ReadRemainingArgumentsNode(arity.getPreRequired() + arity.getOptional()));
        }
        if (method.needsBlock()) {
            argumentsNodes.add(new ReadBlockNode(NotProvided.INSTANCE));
        }
        NodeFactory<? extends RubyNode> nodeFactory = methodDetails.getNodeFactory();
        List signatures = nodeFactory.getNodeSignatures();
        assert (signatures.size() == 1);
        List signature = (List)signatures.get(0);
        if (signature.size() == 0) {
            methodNode = (RubyNode)((Object)nodeFactory.createNode(new Object[0]));
        } else {
            Object[] args;
            RubyNode[] argumentsArray = argumentsNodes.toArray(new RubyNode[argumentsNodes.size()]);
            if (signature.size() == 1 && signature.get(0) == RubyNode[].class) {
                methodNode = (RubyNode)((Object)nodeFactory.createNode(new Object[]{argumentsArray}));
            } else if (signature.size() >= 3 && signature.get(2) == RubyNode[].class) {
                methodNode = (RubyNode)((Object)nodeFactory.createNode(new Object[]{context, sourceSection, argumentsArray}));
            } else if (signature.get(0) != RubyContext.class) {
                args = argumentsArray;
                methodNode = (RubyNode)((Object)nodeFactory.createNode(args));
            } else {
                args = new Object[2 + argumentsNodes.size()];
                args[0] = context;
                args[1] = sourceSection;
                System.arraycopy(argumentsArray, 0, args, 2, argumentsNodes.size());
                methodNode = (RubyNode)((Object)nodeFactory.createNode(args));
            }
        }
        if (System.getenv("TRUFFLE_CHECK_AMBIGUOUS_OPTIONAL_ARGS") != null) {
            AmbiguousOptionalArgumentChecker.verifyNoAmbiguousOptionalArguments(methodDetails);
        }
        RubyNode checkArity = Translator.createCheckArityNode(context, sourceSection, arity);
        if (!CoreMethodNodeManager.isSafe(context, method.unsafe())) {
            sequence = new UnsafeNode(context, sourceSection);
        } else {
            sequence = Translator.sequence(context, sourceSection, Arrays.asList(checkArity, methodNode));
            if (method.returnsEnumeratorIfNoBlock()) {
                sequence = new ReturnEnumeratorIfNoBlockNode(method.names()[0], sequence);
            }
            if (method.taintFromSelf() || method.taintFromParameter() != -1) {
                sequence = new TaintResultNode(method.taintFromSelf(), method.taintFromParameter(), sequence);
            }
        }
        ExceptionTranslatingNode exceptionTranslatingNode = new ExceptionTranslatingNode(context, sourceSection, sequence, method.unsupportedOperationBehavior());
        return new RubyRootNode(context, sourceSection, null, sharedMethodInfo, exceptionTranslatingNode, false);
    }

    public static boolean isSafe(RubyContext context, UnsafeGroup[] groups) {
        Options options = context.getOptions();
        for (UnsafeGroup group : groups) {
            boolean option;
            switch (group) {
                case LOAD: {
                    option = options.PLATFORM_SAFE_LOAD;
                    break;
                }
                case IO: {
                    option = options.PLATFORM_SAFE_IO;
                    break;
                }
                case MEMORY: {
                    option = options.PLATFORM_SAFE_MEMORY;
                    break;
                }
                case THREADS: {
                    option = options.PLATFORM_SAFE_THREADS;
                    break;
                }
                case PROCESSES: {
                    option = options.PLATFORM_SAFE_PROCESSES;
                    break;
                }
                case SIGNALS: {
                    option = options.PLATFORM_SAFE_SIGNALS;
                    break;
                }
                case EXIT: {
                    option = options.PLATFORM_SAFE_EXIT;
                    break;
                }
                case AT_EXIT: {
                    option = options.PLATFORM_SAFE_AT_EXIT;
                    break;
                }
                case SAFE_PUTS: {
                    option = options.PLATFORM_SAFE_PUTS;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (option) continue;
            return false;
        }
        return true;
    }

    public void allMethodInstalled() {
        if (System.getenv("TRUFFLE_CHECK_AMBIGUOUS_OPTIONAL_ARGS") != null && !AmbiguousOptionalArgumentChecker.SUCCESS) {
            System.exit(1);
        }
    }

    public static class MethodDetails {
        private final CoreClass classAnnotation;
        private final CoreMethod methodAnnotation;
        private final NodeFactory<? extends RubyNode> nodeFactory;

        public MethodDetails(CoreClass classAnnotation, CoreMethod methodAnnotation, NodeFactory<? extends RubyNode> nodeFactory) {
            assert (classAnnotation != null);
            assert (methodAnnotation != null);
            assert (nodeFactory != null);
            this.classAnnotation = classAnnotation;
            this.methodAnnotation = methodAnnotation;
            this.nodeFactory = nodeFactory;
        }

        public CoreClass getClassAnnotation() {
            return this.classAnnotation;
        }

        public CoreMethod getMethodAnnotation() {
            return this.methodAnnotation;
        }

        public NodeFactory<? extends RubyNode> getNodeFactory() {
            return this.nodeFactory;
        }

        public String getIndicativeName() {
            return this.classAnnotation.value() + "#" + this.methodAnnotation.names()[0];
        }
    }
}

