/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.fiber;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.fiber.FiberLayout;
import org.jruby.truffle.core.fiber.FiberNodes;

@GeneratedBy(value=FiberLayout.class)
public class FiberLayoutImpl
extends BasicObjectLayoutImpl
implements FiberLayout {
    public static final FiberLayout INSTANCE = new FiberLayoutImpl();
    protected static final Shape.Allocator FIBER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ROOT_FIBER_IDENTIFIER = new HiddenKey("rootFiber");
    protected static final Property ROOT_FIBER_PROPERTY = Property.create((Object)ROOT_FIBER_IDENTIFIER, (Location)FIBER_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);
    protected static final HiddenKey INITIALIZED_LATCH_IDENTIFIER = new HiddenKey("initializedLatch");
    protected static final Property INITIALIZED_LATCH_PROPERTY = Property.create((Object)INITIALIZED_LATCH_IDENTIFIER, (Location)FIBER_ALLOCATOR.locationForType(CountDownLatch.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);
    protected static final HiddenKey MESSAGE_QUEUE_IDENTIFIER = new HiddenKey("messageQueue");
    protected static final Property MESSAGE_QUEUE_PROPERTY = Property.create((Object)MESSAGE_QUEUE_IDENTIFIER, (Location)FIBER_ALLOCATOR.locationForType(BlockingQueue.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);
    protected static final HiddenKey RUBY_THREAD_IDENTIFIER = new HiddenKey("rubyThread");
    protected static final Property RUBY_THREAD_PROPERTY = Property.create((Object)RUBY_THREAD_IDENTIFIER, (Location)FIBER_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), (int)0);
    protected static final HiddenKey LAST_RESUMED_BY_FIBER_IDENTIFIER = new HiddenKey("lastResumedByFiber");
    protected static final Property LAST_RESUMED_BY_FIBER_PROPERTY = Property.create((Object)LAST_RESUMED_BY_FIBER_IDENTIFIER, (Location)FIBER_ALLOCATOR.locationForType(AtomicReference.class), (int)0);
    protected static final HiddenKey ALIVE_IDENTIFIER = new HiddenKey("alive");
    protected static final Property ALIVE_PROPERTY = Property.create((Object)ALIVE_IDENTIFIER, (Location)FIBER_ALLOCATOR.locationForType(AtomicBoolean.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey THREAD_IDENTIFIER = new HiddenKey("thread");
    protected static final Property THREAD_PROPERTY = Property.create((Object)THREAD_IDENTIFIER, (Location)FIBER_ALLOCATOR.locationForType(AtomicReference.class), (int)0);

    protected FiberLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createFiberShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new FiberType(logicalClass, metaClass)).addProperty(ROOT_FIBER_PROPERTY).addProperty(INITIALIZED_LATCH_PROPERTY).addProperty(MESSAGE_QUEUE_PROPERTY).addProperty(RUBY_THREAD_PROPERTY).addProperty(LAST_RESUMED_BY_FIBER_PROPERTY).addProperty(ALIVE_PROPERTY).addProperty(THREAD_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createFiber(DynamicObjectFactory factory, boolean rootFiber, CountDownLatch initializedLatch, BlockingQueue<FiberNodes.FiberMessage> messageQueue, DynamicObject rubyThread, DynamicObject lastResumedByFiber, boolean alive, Thread thread) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (FiberLayoutImpl.createsFiber(factory));
        assert (factory.getShape().hasProperty((Object)ROOT_FIBER_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)INITIALIZED_LATCH_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)MESSAGE_QUEUE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)RUBY_THREAD_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)LAST_RESUMED_BY_FIBER_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)ALIVE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)THREAD_IDENTIFIER));
        assert (initializedLatch != null);
        assert (messageQueue != null);
        assert (rubyThread != null);
        return factory.newInstance(new Object[]{rootFiber, initializedLatch, messageQueue, rubyThread, new AtomicReference<DynamicObject>(lastResumedByFiber), new AtomicBoolean(alive), new AtomicReference<Thread>(thread)});
    }

    @Override
    public boolean isFiber(DynamicObject object) {
        return FiberLayoutImpl.isFiber(object.getShape().getObjectType());
    }

    private static boolean isFiber(ObjectType objectType) {
        return objectType instanceof FiberType;
    }

    private static boolean createsFiber(DynamicObjectFactory factory) {
        return FiberLayoutImpl.isFiber(factory.getShape().getObjectType());
    }

    @Override
    public boolean getRootFiber(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty((Object)ROOT_FIBER_IDENTIFIER));
        return (Boolean)ROOT_FIBER_PROPERTY.get(object, this.isFiber(object));
    }

    @Override
    public CountDownLatch getInitializedLatch(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty((Object)INITIALIZED_LATCH_IDENTIFIER));
        return (CountDownLatch)INITIALIZED_LATCH_PROPERTY.get(object, this.isFiber(object));
    }

    @Override
    public BlockingQueue<FiberNodes.FiberMessage> getMessageQueue(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty((Object)MESSAGE_QUEUE_IDENTIFIER));
        return (BlockingQueue)MESSAGE_QUEUE_PROPERTY.get(object, this.isFiber(object));
    }

    @Override
    public DynamicObject getRubyThread(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty((Object)RUBY_THREAD_IDENTIFIER));
        return (DynamicObject)RUBY_THREAD_PROPERTY.get(object, this.isFiber(object));
    }

    @Override
    public DynamicObject getLastResumedByFiber(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty((Object)LAST_RESUMED_BY_FIBER_IDENTIFIER));
        return (DynamicObject)((AtomicReference)LAST_RESUMED_BY_FIBER_PROPERTY.get(object, this.isFiber(object))).get();
    }

    @Override
    public void setLastResumedByFiber(DynamicObject object, DynamicObject value) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty((Object)LAST_RESUMED_BY_FIBER_IDENTIFIER));
        ((AtomicReference)LAST_RESUMED_BY_FIBER_PROPERTY.get(object, this.isFiber(object))).set(value);
    }

    @Override
    public boolean getAlive(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty((Object)ALIVE_IDENTIFIER));
        return ((AtomicBoolean)ALIVE_PROPERTY.get(object, this.isFiber(object))).get();
    }

    @Override
    public void setAlive(DynamicObject object, boolean value) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty((Object)ALIVE_IDENTIFIER));
        ((AtomicBoolean)ALIVE_PROPERTY.get(object, this.isFiber(object))).set(value);
    }

    @Override
    public Thread getThread(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty((Object)THREAD_IDENTIFIER));
        return (Thread)((AtomicReference)THREAD_PROPERTY.get(object, this.isFiber(object))).get();
    }

    @Override
    public void setThread(DynamicObject object, Thread value) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty((Object)THREAD_IDENTIFIER));
        ((AtomicReference)THREAD_PROPERTY.get(object, this.isFiber(object))).set(value);
    }

    public static class FiberType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public FiberType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public FiberType setLogicalClass(DynamicObject logicalClass) {
            return new FiberType(logicalClass, this.metaClass);
        }

        @Override
        public FiberType setMetaClass(DynamicObject metaClass) {
            return new FiberType(this.logicalClass, metaClass);
        }
    }
}

