/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@NodeChild(value="child", type=RubyNode.class)
public abstract class NameToJavaStringNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toStr;
    private final BranchProfile errorProfile = BranchProfile.create();

    public NameToJavaStringNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.toStr = DispatchHeadNodeFactory.createMethodCall(context);
    }

    public abstract String executeToJavaString(VirtualFrame var1, Object var2);

    @Specialization
    public String passThroughJavaString(String string) {
        return string;
    }

    @Specialization(guards={"isRubySymbol(symbol)"})
    public String coerceRubySymbol(DynamicObject symbol) {
        return Layouts.SYMBOL.getString(symbol);
    }

    @Specialization(guards={"isRubyString(string)"})
    public String coerceRubyString(DynamicObject string) {
        return string.toString();
    }

    @Specialization(guards={"!isString(object)", "!isRubySymbol(object)", "!isRubyString(object)"})
    public String coerceObject(VirtualFrame frame, Object object) {
        Object coerced;
        try {
            coerced = this.toStr.call(frame, object, "to_str", null, new Object[0]);
        }
        catch (RaiseException e) {
            this.errorProfile.enter();
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNoMethodErrorClass()) {
                throw new RaiseException(this.coreExceptions().typeErrorNoImplicitConversion(object, "String", this));
            }
            throw e;
        }
        if (RubyGuards.isRubyString(coerced)) {
            return coerced.toString();
        }
        this.errorProfile.enter();
        throw new RaiseException(this.coreExceptions().typeErrorBadCoercion(object, "String", "to_str", coerced, this));
    }
}

