/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;

@ImportStatic(value={ArrayGuards.class})
@NodeChild(value="array", type=RubyNode.class)
public abstract class ArrayDupNode
extends RubyNode {
    @Node.Child
    private AllocateObjectNode allocateNode;

    public ArrayDupNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
    }

    public abstract DynamicObject executeDup(VirtualFrame var1, DynamicObject var2);

    @Specialization(guards={"isNullArray(from)"})
    public DynamicObject dupNull(DynamicObject from) {
        return this.allocateNode.allocateArray(this.coreLibrary().getArrayClass(), null, 0);
    }

    @Specialization(guards={"strategy.matches(from)"}, limit="ARRAY_STRATEGIES")
    public DynamicObject dupOther(DynamicObject from, @Cached(value="of(from)") ArrayStrategy strategy) {
        int size = Layouts.ARRAY.getSize(from);
        Object store = strategy.newMirror(from).copyArrayAndMirror().getArray();
        return this.allocateNode.allocateArray(this.coreLibrary().getArrayClass(), store, size);
    }
}

