/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.time;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rubinius.TimePrimitiveNodes;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.time.ReadTimeZoneNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;

@CoreClass(name="Time")
public abstract class TimeNodes {
    private static final DateTime ZERO = new DateTime(0L);

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, ZERO, 0, this.coreLibrary().getNilObject(), 0, false, false);
        }
    }

    @CoreMethod(names={"gmtime"})
    public static abstract class GmTimeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject localtime(DynamicObject time) {
            DateTime dateTime = Layouts.TIME.getDateTime(time);
            Layouts.TIME.setIsUtc(time, true);
            Layouts.TIME.setRelativeOffset(time, false);
            Layouts.TIME.setZone(time, this.nil());
            Layouts.TIME.setDateTime(time, dateTime.withZone(DateTimeZone.UTC));
            return time;
        }
    }

    @CoreMethod(names={"dup_internal"}, required=1, visibility=Visibility.PROTECTED)
    public static abstract class DupInternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public DupInternalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject dup(DynamicObject time, DynamicObject klass) {
            return this.allocateObjectNode.allocate(klass, Layouts.TIME.getDateTime(time), Layouts.TIME.getNSec(time), Layouts.TIME.getZone(time), Layouts.TIME.getOffset(time), Layouts.TIME.getRelativeOffset(time), Layouts.TIME.getIsUtc(time));
        }
    }

    @CoreMethod(names={"add_internal!"}, required=2, visibility=Visibility.PROTECTED)
    public static abstract class AddInternalNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject addInternal(DynamicObject time, long seconds, long nanoSeconds) {
            DateTime dateTime = Layouts.TIME.getDateTime(time);
            long addMilis = ExactMath.addExact((long)ExactMath.multiplyExact((long)seconds, (long)1000L), (long)(nanoSeconds / 1000000L));
            Layouts.TIME.setDateTime(time, dateTime.plus(addMilis));
            Layouts.TIME.setNSec(time, (1000000L + Layouts.TIME.getNSec(time) + nanoSeconds % 1000000L) % 1000000L);
            return time;
        }
    }

    @CoreMethod(names={"localtime_internal"}, optional=1)
    public static abstract class LocalTimeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ReadTimeZoneNode readTimeZoneNode;

        public LocalTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readTimeZoneNode = new ReadTimeZoneNode(context, sourceSection);
        }

        @Specialization
        public DynamicObject localtime(VirtualFrame frame, DynamicObject time, NotProvided offset) {
            DynamicObject zoneName = (DynamicObject)this.readTimeZoneNode.execute(frame);
            DateTimeZone dateTimeZone = TimePrimitiveNodes.TimeZoneParser.parse(this, StringOperations.getString(this.getContext(), zoneName));
            String shortZoneName = TimePrimitiveNodes.TimeZoneParser.getShortZoneName(time, dateTimeZone);
            DynamicObject zone = this.createString(StringOperations.encodeRope(shortZoneName, (Encoding)UTF8Encoding.INSTANCE));
            DateTime dateTime = Layouts.TIME.getDateTime(time);
            Layouts.TIME.setIsUtc(time, false);
            Layouts.TIME.setRelativeOffset(time, false);
            Layouts.TIME.setZone(time, zone);
            Layouts.TIME.setDateTime(time, dateTime.withZone(dateTimeZone));
            return time;
        }

        @Specialization
        public DynamicObject localtime(DynamicObject time, long offset) {
            DateTime dateTime = Layouts.TIME.getDateTime(time);
            DateTimeZone zone = this.getDateTimeZone((int)offset);
            Layouts.TIME.setIsUtc(time, false);
            Layouts.TIME.setRelativeOffset(time, true);
            Layouts.TIME.setZone(time, this.nil());
            Layouts.TIME.setDateTime(time, dateTime.withZone(zone));
            return time;
        }

        @CompilerDirectives.TruffleBoundary
        public DateTimeZone getDateTimeZone(int offset) {
            return DateTimeZone.forOffsetMillis((int)(offset * 1000));
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class InternalOffsetNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object internalOffset(DynamicObject time) {
            Object offset = Layouts.TIME.getOffset(time);
            if (offset == this.nil()) {
                return Layouts.TIME.getDateTime(time).getZone().getOffset(Layouts.TIME.getDateTime(time).getMillis()) / 1000;
            }
            return offset;
        }
    }

    @NodeChild(type=RubyNode.class, value="self")
    public static abstract class InternalGMTNode
    extends CoreMethodNode {
        @Specialization
        public boolean internalGMT(DynamicObject time) {
            return Layouts.TIME.getIsUtc(time);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyTime(from)"})
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            Layouts.TIME.setDateTime(self, Layouts.TIME.getDateTime(from));
            Layouts.TIME.setNSec(self, Layouts.TIME.getNSec(from));
            Layouts.TIME.setOffset(self, Layouts.TIME.getOffset(from));
            Layouts.TIME.setRelativeOffset(self, Layouts.TIME.getRelativeOffset(from));
            return self;
        }
    }
}

