/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.kenai.jffi.MemoryIO;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rubinius.RubiniusPrimitive;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.truffle.platform.RubiniusTypes;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.util.ByteList;
import org.jruby.util.unsafe.UnsafeHolder;

public abstract class PointerPrimitiveNodes {
    public static final Pointer NULL_POINTER = Runtime.getSystemRuntime().getMemoryManager().newOpaquePointer(0L);

    @RubiniusPrimitive(name="pointer_write_int", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerWriteIntPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject address(DynamicObject pointer, int value) {
            Layouts.POINTER.getPointer(pointer).putInt(0L, value);
            return pointer;
        }
    }

    @RubiniusPrimitive(name="pointer_read_string_to_null", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerReadStringToNullPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isNullPointer(pointer)"})
        public DynamicObject readNullPointer(DynamicObject pointer) {
            return this.createString(RopeConstants.EMPTY_ASCII_8BIT_ROPE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isNullPointer(pointer)"})
        public DynamicObject readStringToNull(DynamicObject pointer) {
            return this.createString(new ByteList(MemoryIO.getInstance().getZeroTerminatedByteArray(Layouts.POINTER.getPointer(pointer).address())));
        }
    }

    @RubiniusPrimitive(name="pointer_write_string", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerWriteStringPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject address(DynamicObject pointer, DynamicObject string, int maxLength) {
            Rope rope = StringOperations.rope(string);
            int length = Math.min(rope.byteLength(), maxLength);
            Layouts.POINTER.getPointer(pointer).put(0L, rope.getBytes(), 0, length);
            return pointer;
        }
    }

    @RubiniusPrimitive(name="pointer_get_at_offset", unsafe={UnsafeGroup.MEMORY})
    @ImportStatic(value={RubiniusTypes.class})
    public static abstract class PointerGetAtOffsetPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        @Specialization(guards={"type == TYPE_CHAR"})
        public int getAtOffsetChar(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getByte((long)offset);
        }

        @Specialization(guards={"type == TYPE_UCHAR"})
        public int getAtOffsetUChar(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getByte((long)offset);
        }

        @Specialization(guards={"type == TYPE_INT"})
        public int getAtOffsetInt(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getInt((long)offset);
        }

        @Specialization(guards={"type == TYPE_SHORT"})
        public int getAtOffsetShort(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getShort((long)offset);
        }

        @Specialization(guards={"type == TYPE_USHORT"})
        public int getAtOffsetUShort(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getShort((long)offset);
        }

        @Specialization(guards={"type == TYPE_LONG"})
        public long getAtOffsetLong(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getLong((long)offset);
        }

        @Specialization(guards={"type == TYPE_ULONG"})
        public long getAtOffsetULong(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getLong((long)offset);
        }

        @Specialization(guards={"type == TYPE_ULL"})
        public long getAtOffsetULL(DynamicObject pointer, int offset, int type) {
            return Layouts.POINTER.getPointer(pointer).getLongLong((long)offset);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"type == TYPE_STRING"})
        public DynamicObject getAtOffsetString(DynamicObject pointer, int offset, int type) {
            return this.createString(StringOperations.encodeRope(Layouts.POINTER.getPointer(pointer).getString((long)offset), (Encoding)UTF8Encoding.INSTANCE));
        }

        @Specialization(guards={"type == TYPE_PTR"})
        public DynamicObject getAtOffsetPointer(DynamicObject pointer, int offset, int type) {
            Pointer readPointer;
            if (this.allocateObjectNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.allocateObjectNode = (AllocateObjectNode)this.insert(AllocateObjectNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null, null));
            }
            if ((readPointer = Layouts.POINTER.getPointer(pointer).getPointer((long)offset)) == null) {
                return this.nil();
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(pointer), readPointer);
        }
    }

    @RubiniusPrimitive(name="pointer_address", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerAddressPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public long address(DynamicObject pointer) {
            return Layouts.POINTER.getPointer(pointer).address();
        }
    }

    @RubiniusPrimitive(name="pointer_read_pointer", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerReadPointerPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public PointerReadPointerPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject readPointer(DynamicObject pointer) {
            Pointer readPointer = Layouts.POINTER.getPointer(pointer).getPointer(0L);
            if (readPointer == null) {
                readPointer = NULL_POINTER;
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(pointer), readPointer);
        }
    }

    @RubiniusPrimitive(name="pointer_set_at_offset", lowerFixnumParameters={0, 1}, unsafe={UnsafeGroup.MEMORY})
    @ImportStatic(value={RubiniusTypes.class})
    public static abstract class PointerSetAtOffsetPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"type == TYPE_INT"})
        public int setAtOffsetInt(DynamicObject pointer, int offset, int type, int value) {
            Layouts.POINTER.getPointer(pointer).putInt((long)offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_LONG"})
        public long setAtOffsetLong(DynamicObject pointer, int offset, int type, long value) {
            Layouts.POINTER.getPointer(pointer).putLong((long)offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_ULONG"})
        public long setAtOffsetULong(DynamicObject pointer, int offset, int type, long value) {
            Layouts.POINTER.getPointer(pointer).putLong((long)offset, value);
            return value;
        }

        @Specialization(guards={"type == TYPE_ULL"})
        public long setAtOffsetULL(DynamicObject pointer, int offset, int type, long value) {
            Layouts.POINTER.getPointer(pointer).putLongLong((long)offset, value);
            return value;
        }
    }

    @RubiniusPrimitive(name="pointer_set_autorelease", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerSetAutoreleasePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public boolean setAutorelease(DynamicObject pointer, boolean autorelease) {
            return autorelease;
        }
    }

    @RubiniusPrimitive(name="pointer_read_string", lowerFixnumParameters={0}, unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerReadStringPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject readString(DynamicObject pointer, int length) {
            byte[] bytes = new byte[length];
            Layouts.POINTER.getPointer(pointer).get(0L, bytes, 0, length);
            return this.createString(new ByteList(bytes));
        }
    }

    @RubiniusPrimitive(name="pointer_read_int", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerReadIntPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isSigned(signed)"})
        public int readInt(DynamicObject pointer, boolean signed) {
            return Layouts.POINTER.getPointer(pointer).getInt(0L);
        }

        protected boolean isSigned(boolean signed) {
            return signed;
        }
    }

    @RubiniusPrimitive(name="pointer_add", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerAddPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public PointerAddPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject add(DynamicObject a, int b) {
            return this.add(a, (long)b);
        }

        @Specialization
        public DynamicObject add(DynamicObject a, long b) {
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(a), this.memoryManager().newPointer(Layouts.POINTER.getPointer(a).address() + b));
        }
    }

    @RubiniusPrimitive(name="pointer_set_address", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerSetAddressPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public long setAddress(DynamicObject pointer, int address) {
            return this.setAddress(pointer, (long)address);
        }

        @Specialization
        public long setAddress(DynamicObject pointer, long address) {
            Layouts.POINTER.setPointer(pointer, this.memoryManager().newPointer(address));
            return address;
        }
    }

    @RubiniusPrimitive(name="pointer_free", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerFreePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject free(DynamicObject pointer) {
            UnsafeHolder.U.freeMemory(Layouts.POINTER.getPointer(pointer).address());
            return pointer;
        }
    }

    @RubiniusPrimitive(name="pointer_malloc", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerMallocPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public PointerMallocPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject malloc(DynamicObject pointerClass, int size) {
            return this.malloc(pointerClass, (long)size);
        }

        @Specialization
        public DynamicObject malloc(DynamicObject pointerClass, long size) {
            return this.allocateObjectNode.allocate(pointerClass, this.memoryManager().newPointer(UnsafeHolder.U.allocateMemory(size)));
        }
    }

    @RubiniusPrimitive(name="pointer_allocate", unsafe={UnsafeGroup.MEMORY})
    public static abstract class PointerAllocatePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public PointerAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject pointerClass) {
            return this.allocateObjectNode.allocate(pointerClass, NULL_POINTER);
        }
    }
}

