/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import jnr.ffi.Pointer;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rubinius.PointerLayout;

@GeneratedBy(value=PointerLayout.class)
public class PointerLayoutImpl
extends BasicObjectLayoutImpl
implements PointerLayout {
    public static final PointerLayout INSTANCE = new PointerLayoutImpl();
    protected static final Shape.Allocator POINTER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey POINTER_IDENTIFIER = new HiddenKey("pointer");
    protected static final Property POINTER_PROPERTY = Property.create((Object)POINTER_IDENTIFIER, (Location)POINTER_ALLOCATOR.locationForType(Pointer.class, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected PointerLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createPointerShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new PointerType(logicalClass, metaClass)).addProperty(POINTER_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createPointer(DynamicObjectFactory factory, Pointer pointer) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (PointerLayoutImpl.createsPointer(factory));
        assert (factory.getShape().hasProperty((Object)POINTER_IDENTIFIER));
        assert (pointer != null);
        return factory.newInstance(new Object[]{pointer});
    }

    @Override
    public boolean isPointer(DynamicObject object) {
        return PointerLayoutImpl.isPointer(object.getShape().getObjectType());
    }

    private static boolean isPointer(ObjectType objectType) {
        return objectType instanceof PointerType;
    }

    private static boolean createsPointer(DynamicObjectFactory factory) {
        return PointerLayoutImpl.isPointer(factory.getShape().getObjectType());
    }

    @Override
    public Pointer getPointer(DynamicObject object) {
        assert (this.isPointer(object));
        assert (object.getShape().hasProperty((Object)POINTER_IDENTIFIER));
        return (Pointer)POINTER_PROPERTY.get(object, this.isPointer(object));
    }

    @Override
    public void setPointer(DynamicObject object, Pointer value) {
        assert (this.isPointer(object));
        assert (object.getShape().hasProperty((Object)POINTER_IDENTIFIER));
        assert (value != null);
        try {
            POINTER_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class PointerType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public PointerType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public PointerType setLogicalClass(DynamicObject logicalClass) {
            return new PointerType(logicalClass, this.metaClass);
        }

        @Override
        public PointerType setMetaClass(DynamicObject metaClass) {
            return new PointerType(this.logicalClass, metaClass);
        }
    }
}

