/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.queue;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.queue.QueueNodes;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=QueueNodes.class)
public final class QueueNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), PushNodeFactory.getInstance(), PopNodeFactory.getInstance(), ReceiveTimeoutNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), SizeNodeFactory.getInstance(), ClearNodeFactory.getInstance(), MarshalDumpNodeFactory.getInstance(), NumWaitingNodeFactory.getInstance());
    }

    @GeneratedBy(value=QueueNodes.NumWaitingNode.class)
    public static final class NumWaitingNodeFactory
    extends NodeFactoryBase<QueueNodes.NumWaitingNode> {
        private static NumWaitingNodeFactory numWaitingNodeFactoryInstance;

        private NumWaitingNodeFactory() {
            super(QueueNodes.NumWaitingNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public QueueNodes.NumWaitingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return NumWaitingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<QueueNodes.NumWaitingNode> getInstance() {
            if (numWaitingNodeFactoryInstance == null) {
                numWaitingNodeFactoryInstance = new NumWaitingNodeFactory();
            }
            return numWaitingNodeFactoryInstance;
        }

        public static QueueNodes.NumWaitingNode create(RubyNode[] arguments) {
            return new NumWaitingNodeGen(arguments);
        }

        @GeneratedBy(value=QueueNodes.NumWaitingNode.class)
        public static final class NumWaitingNodeGen
        extends QueueNodes.NumWaitingNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private NumWaitingNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.num_waiting(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=QueueNodes.MarshalDumpNode.class)
    public static final class MarshalDumpNodeFactory
    extends NodeFactoryBase<QueueNodes.MarshalDumpNode> {
        private static MarshalDumpNodeFactory marshalDumpNodeFactoryInstance;

        private MarshalDumpNodeFactory() {
            super(QueueNodes.MarshalDumpNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public QueueNodes.MarshalDumpNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MarshalDumpNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<QueueNodes.MarshalDumpNode> getInstance() {
            if (marshalDumpNodeFactoryInstance == null) {
                marshalDumpNodeFactoryInstance = new MarshalDumpNodeFactory();
            }
            return marshalDumpNodeFactoryInstance;
        }

        public static QueueNodes.MarshalDumpNode create(RubyNode[] arguments) {
            return new MarshalDumpNodeGen(arguments);
        }

        @GeneratedBy(value=QueueNodes.MarshalDumpNode.class)
        public static final class MarshalDumpNodeGen
        extends QueueNodes.MarshalDumpNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private MarshalDumpNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.marshal_dump(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=QueueNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<QueueNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(QueueNodes.ClearNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public QueueNodes.ClearNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ClearNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<QueueNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        public static QueueNodes.ClearNode create(RubyNode[] arguments) {
            return new ClearNodeGen(arguments);
        }

        @GeneratedBy(value=QueueNodes.ClearNode.class)
        public static final class ClearNodeGen
        extends QueueNodes.ClearNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ClearNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.clear(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=QueueNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<QueueNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(QueueNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public QueueNodes.SizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<QueueNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static QueueNodes.SizeNode create(RubyNode[] arguments) {
            return new SizeNodeGen(arguments);
        }

        @GeneratedBy(value=QueueNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends QueueNodes.SizeNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SizeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.size(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=QueueNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<QueueNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(QueueNodes.EmptyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public QueueNodes.EmptyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EmptyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<QueueNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        public static QueueNodes.EmptyNode create(RubyNode[] arguments) {
            return new EmptyNodeGen(arguments);
        }

        @GeneratedBy(value=QueueNodes.EmptyNode.class)
        public static final class EmptyNodeGen
        extends QueueNodes.EmptyNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private EmptyNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.empty(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=QueueNodes.ReceiveTimeoutNode.class)
    public static final class ReceiveTimeoutNodeFactory
    extends NodeFactoryBase<QueueNodes.ReceiveTimeoutNode> {
        private static ReceiveTimeoutNodeFactory receiveTimeoutNodeFactoryInstance;

        private ReceiveTimeoutNodeFactory() {
            super(QueueNodes.ReceiveTimeoutNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        public QueueNodes.ReceiveTimeoutNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return ReceiveTimeoutNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<QueueNodes.ReceiveTimeoutNode> getInstance() {
            if (receiveTimeoutNodeFactoryInstance == null) {
                receiveTimeoutNodeFactoryInstance = new ReceiveTimeoutNodeFactory();
            }
            return receiveTimeoutNodeFactoryInstance;
        }

        public static QueueNodes.ReceiveTimeoutNode create(RubyNode queue, RubyNode duration) {
            return new ReceiveTimeoutNodeGen(queue, duration);
        }

        @GeneratedBy(value=QueueNodes.ReceiveTimeoutNode.class)
        public static final class ReceiveTimeoutNodeGen
        extends QueueNodes.ReceiveTimeoutNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode queue_;
            @Node.Child
            private RubyNode duration_;
            @CompilerDirectives.CompilationFinal
            private Class<?> durationType_;
            @Node.Child
            private BaseNode_ specialization_;

            private ReceiveTimeoutNodeGen(RubyNode queue, RubyNode duration) {
                this.queue_ = queue;
                this.duration_ = duration;
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="receiveTimeout(DynamicObject, double)", value=QueueNodes.ReceiveTimeoutNode.class)
            private static final class ReceiveTimeout1Node_
            extends BaseNode_ {
                private final Class<?> durationImplicitType;

                ReceiveTimeout1Node_(ReceiveTimeoutNodeGen root, Object durationValue) {
                    super(root, 2);
                    this.durationImplicitType = RubyTypesGen.getImplicitDoubleClass(durationValue);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.durationImplicitType == ((ReceiveTimeout1Node_)other).durationImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    double durationValue_;
                    DynamicObject queueValue_;
                    try {
                        queueValue_ = this.root.queue_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object durationValue = this.executeDuration_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), durationValue);
                    }
                    try {
                        if (this.durationImplicitType == Double.TYPE) {
                            durationValue_ = this.root.duration_.executeDouble(frameValue);
                        } else {
                            Object durationValue__ = this.executeDuration_((Frame)frameValue);
                            durationValue_ = RubyTypesGen.expectImplicitDouble(durationValue__, this.durationImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, queueValue_, ex.getResult());
                    }
                    return this.root.receiveTimeout(queueValue_, durationValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object durationValue) {
                    if (queueValue instanceof DynamicObject && RubyTypesGen.isImplicitDouble(durationValue, this.durationImplicitType)) {
                        DynamicObject queueValue_ = (DynamicObject)queueValue;
                        double durationValue_ = RubyTypesGen.asImplicitDouble(durationValue, this.durationImplicitType);
                        return this.root.receiveTimeout(queueValue_, durationValue_);
                    }
                    return this.getNext().execute_(frameValue, queueValue, durationValue);
                }

                static BaseNode_ create(ReceiveTimeoutNodeGen root, Object durationValue) {
                    return new ReceiveTimeout1Node_(root, durationValue);
                }
            }

            @GeneratedBy(methodName="receiveTimeout(DynamicObject, int)", value=QueueNodes.ReceiveTimeoutNode.class)
            private static final class ReceiveTimeout0Node_
            extends BaseNode_ {
                private final Class<?> durationImplicitType;

                ReceiveTimeout0Node_(ReceiveTimeoutNodeGen root, Object durationValue) {
                    super(root, 1);
                    this.durationImplicitType = RubyTypesGen.getImplicitIntegerClass(durationValue);
                }

                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.durationImplicitType == ((ReceiveTimeout0Node_)other).durationImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int durationValue_;
                    DynamicObject queueValue_;
                    try {
                        queueValue_ = this.root.queue_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object durationValue = this.executeDuration_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), durationValue);
                    }
                    try {
                        if (this.durationImplicitType == Integer.TYPE) {
                            durationValue_ = this.root.duration_.executeInteger(frameValue);
                        } else {
                            Object durationValue__ = this.executeDuration_((Frame)frameValue);
                            durationValue_ = RubyTypesGen.expectImplicitInteger(durationValue__, this.durationImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, queueValue_, ex.getResult());
                    }
                    return this.root.receiveTimeout(queueValue_, durationValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object durationValue) {
                    if (queueValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(durationValue, this.durationImplicitType)) {
                        DynamicObject queueValue_ = (DynamicObject)queueValue;
                        int durationValue_ = RubyTypesGen.asImplicitInteger(durationValue, this.durationImplicitType);
                        return this.root.receiveTimeout(queueValue_, durationValue_);
                    }
                    return this.getNext().execute_(frameValue, queueValue, durationValue);
                }

                static BaseNode_ create(ReceiveTimeoutNodeGen root, Object durationValue) {
                    return new ReceiveTimeout0Node_(root, durationValue);
                }
            }

            @GeneratedBy(value=QueueNodes.ReceiveTimeoutNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ReceiveTimeoutNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object queueValue, Object durationValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, queueValue, durationValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object durationValue) {
                    return this.getNext().execute_(frameValue, queueValue, durationValue);
                }

                static BaseNode_ create(ReceiveTimeoutNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=QueueNodes.ReceiveTimeoutNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ReceiveTimeoutNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object durationValue) {
                    return this.uninitialized((Frame)frameValue, queueValue, durationValue);
                }

                static BaseNode_ create(ReceiveTimeoutNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=QueueNodes.ReceiveTimeoutNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ReceiveTimeoutNodeGen root;

                BaseNode_(ReceiveTimeoutNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (ReceiveTimeoutNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.queue_, this.root.duration_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object queueValue, Object durationValue) {
                    return this.execute_((VirtualFrame)frameValue, queueValue, durationValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object queueValue_ = this.root.queue_.execute(frameValue);
                    Object durationValue_ = this.executeDuration_((Frame)frameValue);
                    return this.execute_(frameValue, queueValue_, durationValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object queueValue, Object durationValue) {
                    if (queueValue instanceof DynamicObject) {
                        if (RubyTypesGen.isImplicitInteger(durationValue)) {
                            return ReceiveTimeout0Node_.create(this.root, durationValue);
                        }
                        if (RubyTypesGen.isImplicitDouble(durationValue)) {
                            return ReceiveTimeout1Node_.create(this.root, durationValue);
                        }
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeDuration_(Frame frameValue) {
                    Object object;
                    Class durationType_ = this.root.durationType_;
                    if (durationType_ == Double.TYPE) {
                        return this.root.duration_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (durationType_ == Integer.TYPE) {
                        return this.root.duration_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (durationType_ != null) return this.root.duration_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.duration_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.durationType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.durationType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.durationType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=QueueNodes.PopNode.class)
    public static final class PopNodeFactory
    extends NodeFactoryBase<QueueNodes.PopNode> {
        private static PopNodeFactory popNodeFactoryInstance;

        private PopNodeFactory() {
            super(QueueNodes.PopNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        public QueueNodes.PopNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return PopNodeFactory.create((RubyNode)((Object)arguments[0]), (RubyNode)((Object)arguments[1]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<QueueNodes.PopNode> getInstance() {
            if (popNodeFactoryInstance == null) {
                popNodeFactoryInstance = new PopNodeFactory();
            }
            return popNodeFactoryInstance;
        }

        public static QueueNodes.PopNode create(RubyNode queue, RubyNode nonBlocking) {
            return new PopNodeGen(queue, nonBlocking);
        }

        @GeneratedBy(value=QueueNodes.PopNode.class)
        public static final class PopNodeGen
        extends QueueNodes.PopNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode queue_;
            @Node.Child
            private RubyNode nonBlocking_;
            @CompilerDirectives.CompilationFinal
            private Class<?> nonBlockingType_;
            @Node.Child
            private BaseNode_ specialization_;

            private PopNodeGen(RubyNode queue, RubyNode nonBlocking) {
                this.queue_ = queue;
                this.nonBlocking_ = this.coerceToBoolean(nonBlocking);
                this.specialization_ = UninitializedNode_.create(this);
            }

            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            public Node deepCopy() {
                return SpecializationNode.updateRoot((Node)super.deepCopy());
            }

            @GeneratedBy(methodName="popNonBlock(DynamicObject, boolean)", value=QueueNodes.PopNode.class)
            private static final class PopNonBlockNode_
            extends BaseNode_ {
                PopNonBlockNode_(PopNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean nonBlockingValue_;
                    DynamicObject queueValue_;
                    try {
                        queueValue_ = this.root.queue_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nonBlockingValue = this.executeNonBlocking_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nonBlockingValue);
                    }
                    try {
                        nonBlockingValue_ = this.root.nonBlocking_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, queueValue_, ex.getResult());
                    }
                    if (nonBlockingValue_) {
                        return this.root.popNonBlock(queueValue_, nonBlockingValue_);
                    }
                    return this.getNext().execute_(frameValue, queueValue_, nonBlockingValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object nonBlockingValue) {
                    if (queueValue instanceof DynamicObject && nonBlockingValue instanceof Boolean) {
                        DynamicObject queueValue_ = (DynamicObject)queueValue;
                        boolean nonBlockingValue_ = (Boolean)nonBlockingValue;
                        if (nonBlockingValue_) {
                            return this.root.popNonBlock(queueValue_, nonBlockingValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, queueValue, nonBlockingValue);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopNonBlockNode_(root);
                }
            }

            @GeneratedBy(methodName="popBlocking(DynamicObject, boolean)", value=QueueNodes.PopNode.class)
            private static final class PopBlockingNode_
            extends BaseNode_ {
                PopBlockingNode_(PopNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean nonBlockingValue_;
                    DynamicObject queueValue_;
                    try {
                        queueValue_ = this.root.queue_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nonBlockingValue = this.executeNonBlocking_((Frame)frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nonBlockingValue);
                    }
                    try {
                        nonBlockingValue_ = this.root.nonBlocking_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, queueValue_, ex.getResult());
                    }
                    if (!nonBlockingValue_) {
                        return this.root.popBlocking(queueValue_, nonBlockingValue_);
                    }
                    return this.getNext().execute_(frameValue, queueValue_, nonBlockingValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object nonBlockingValue) {
                    if (queueValue instanceof DynamicObject && nonBlockingValue instanceof Boolean) {
                        DynamicObject queueValue_ = (DynamicObject)queueValue;
                        boolean nonBlockingValue_ = (Boolean)nonBlockingValue;
                        if (!nonBlockingValue_) {
                            return this.root.popBlocking(queueValue_, nonBlockingValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, queueValue, nonBlockingValue);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopBlockingNode_(root);
                }
            }

            @GeneratedBy(value=QueueNodes.PopNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PopNodeGen root) {
                    super(root, 0);
                }

                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object queueValue, Object nonBlockingValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, queueValue, nonBlockingValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object nonBlockingValue) {
                    return this.getNext().execute_(frameValue, queueValue, nonBlockingValue);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=QueueNodes.PopNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PopNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object nonBlockingValue) {
                    return this.uninitialized((Frame)frameValue, queueValue, nonBlockingValue);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=QueueNodes.PopNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PopNodeGen root;

                BaseNode_(PopNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                protected final void setRoot(Node root) {
                    this.root = (PopNodeGen)root;
                }

                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.queue_, this.root.nonBlocking_};
                }

                public final Object acceptAndExecute(Frame frameValue, Object queueValue, Object nonBlockingValue) {
                    return this.execute_((VirtualFrame)frameValue, queueValue, nonBlockingValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object queueValue_ = this.root.queue_.execute(frameValue);
                    Object nonBlockingValue_ = this.executeNonBlocking_((Frame)frameValue);
                    return this.execute_(frameValue, queueValue_, nonBlockingValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                protected final SpecializationNode createNext(Frame frameValue, Object queueValue, Object nonBlockingValue) {
                    if (queueValue instanceof DynamicObject && nonBlockingValue instanceof Boolean) {
                        boolean nonBlockingValue_ = (Boolean)nonBlockingValue;
                        if (!nonBlockingValue_) {
                            return PopBlockingNode_.create(this.root);
                        }
                        return PopNonBlockNode_.create(this.root);
                    }
                    return null;
                }

                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeNonBlocking_(Frame frameValue) {
                    Object object;
                    Class nonBlockingType_ = this.root.nonBlockingType_;
                    if (nonBlockingType_ == Boolean.TYPE) {
                        return this.root.nonBlocking_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (nonBlockingType_ != null) return this.root.nonBlocking_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.nonBlocking_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.nonBlockingType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.nonBlockingType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.nonBlockingType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=QueueNodes.PushNode.class)
    public static final class PushNodeFactory
    extends NodeFactoryBase<QueueNodes.PushNode> {
        private static PushNodeFactory pushNodeFactoryInstance;

        private PushNodeFactory() {
            super(QueueNodes.PushNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyNode[].class}});
        }

        public QueueNodes.PushNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PushNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<QueueNodes.PushNode> getInstance() {
            if (pushNodeFactoryInstance == null) {
                pushNodeFactoryInstance = new PushNodeFactory();
            }
            return pushNodeFactoryInstance;
        }

        public static QueueNodes.PushNode create(RubyNode[] arguments) {
            return new PushNodeGen(arguments);
        }

        @GeneratedBy(value=QueueNodes.PushNode.class)
        public static final class PushNodeGen
        extends QueueNodes.PushNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PushNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return this.push(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
            }
        }
    }

    @GeneratedBy(value=QueueNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<QueueNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(QueueNodes.AllocateNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public QueueNodes.AllocateNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AllocateNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<QueueNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static QueueNodes.AllocateNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new AllocateNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=QueueNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends QueueNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }
}

