/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.hash.Entry;
import org.jruby.truffle.language.RubyGuards;

public abstract class HashGuards {
    public static boolean isNullHash(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getStore(hash) == null;
    }

    public static boolean isPackedHash(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        Object store = Layouts.HASH.getStore(hash);
        return store != null && store.getClass() == Object[].class;
    }

    public static boolean isBucketHash(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getStore(hash) instanceof Entry[];
    }

    public static boolean isEmptyHash(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getSize(hash) == 0;
    }

    public static boolean isCompareByIdentity(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getCompareByIdentity(hash);
    }

    public static boolean hasDefaultValue(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getDefaultValue(hash) != null;
    }

    public static boolean hasDefaultBlock(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        return Layouts.HASH.getDefaultBlock(hash) != null;
    }
}

