/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.TranscoderDB;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.Ruby;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;

@CoreClass(name="Encoding::Converter")
public abstract class EncodingConverterNodes {
    public static DynamicObject createEncodingConverter(DynamicObject rubyClass, EConv econv) {
        return Layouts.ENCODING_CONVERTER.createEncodingConverter(Layouts.CLASS.getInstanceFactory(rubyClass), econv);
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return EncodingConverterNodes.createEncodingConverter(rubyClass, null);
        }
    }

    @CoreMethod(names={"transcoding_map"}, onSingleton=true)
    public static abstract class TranscodingMapNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode upcaseNode;
        @Node.Child
        private CallDispatchHeadNode toSymNode;
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;
        @Node.Child
        private CallDispatchHeadNode newTranscodingNode;

        public TranscodingMapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.upcaseNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.toSymNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newLookupTableNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupTableWriteNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newTranscodingNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object transcodingMap(VirtualFrame frame) {
            Object ret = this.newLookupTableNode.call(frame, this.coreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            for (CaseInsensitiveBytesHash sourceEntry : TranscoderDB.transcoders) {
                Object key = null;
                Object value = this.newLookupTableNode.call(frame, this.coreLibrary().getLookupTableClass(), "new", null, new Object[0]);
                for (Hash.HashEntry destinationEntry : sourceEntry.entryIterator()) {
                    TranscoderDB.Entry e = (TranscoderDB.Entry)destinationEntry.value;
                    if (key == null) {
                        Object upcased = this.upcaseNode.call(frame, this.createString(new ByteList(e.getSource())), "upcase", null, new Object[0]);
                        key = this.toSymNode.call(frame, upcased, "to_sym", null, new Object[0]);
                    }
                    Object upcasedLookupTableKey = this.upcaseNode.call(frame, this.createString(new ByteList(e.getDestination())), "upcase", null, new Object[0]);
                    Object lookupTableKey = this.toSymNode.call(frame, upcasedLookupTableKey, "to_sym", null, new Object[0]);
                    Object lookupTableValue = this.newTranscodingNode.call(frame, this.coreLibrary().getTranscodingClass(), "create", null, key, lookupTableKey);
                    this.lookupTableWriteNode.call(frame, value, "[]=", null, lookupTableKey, lookupTableValue);
                }
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, key, value);
            }
            return ret;
        }
    }

    @CoreMethod(names={"initialize_jruby"}, required=2, optional=1, visibility=Visibility.PRIVATE)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject initialize(DynamicObject self, Object source, Object destination, Object unusedOptions) {
            Ruby runtime = this.getContext().getJRubyRuntime();
            Encoding[] encs = new Encoding[]{null, null};
            byte[][] encNames = new byte[][]{null, null};
            int[] ecflags = new int[]{0};
            IRubyObject[] ecopts = new IRubyObject[]{runtime.getNil()};
            IRubyObject sourceAsJRubyObj = this.toJRuby(source);
            IRubyObject destinationAsJRubyObj = this.toJRuby(destination);
            EncodingUtils.econvArgs((ThreadContext)runtime.getCurrentContext(), (IRubyObject[])new IRubyObject[]{sourceAsJRubyObj, destinationAsJRubyObj}, (byte[][])encNames, (Encoding[])encs, (int[])ecflags, (IRubyObject[])ecopts);
            ecflags[0] = this.rubiniusToJRubyFlags((Integer)self.get((Object)"@options", (Object)this.coreLibrary().getNilObject()));
            EConv econv = EncodingUtils.econvOpenOpts((ThreadContext)runtime.getCurrentContext(), (byte[])encNames[0], (byte[])encNames[1], (int)ecflags[0], (IRubyObject)ecopts[0]);
            if (econv == null) {
                throw new UnsupportedOperationException();
            }
            if (!EncodingUtils.DECORATOR_P((byte[])encNames[0], (byte[])encNames[1])) {
                if (encs[0] == null) {
                    encs[0] = EncodingDB.dummy((byte[])encNames[0]).getEncoding();
                }
                if (encs[1] == null) {
                    encs[1] = EncodingDB.dummy((byte[])encNames[1]).getEncoding();
                }
            }
            econv.sourceEncoding = encs[0];
            econv.destinationEncoding = encs[1];
            Layouts.ENCODING_CONVERTER.setEconv(self, econv);
            return this.nil();
        }

        private int rubiniusToJRubyFlags(int flags) {
            if ((flags & 0x4000) != 0) {
                flags |= 0x30;
            }
            if ((flags & 0x8000) != 0) {
                flags |= 0x30;
            }
            return flags;
        }

        private IRubyObject toJRuby(Object object) {
            if (RubyGuards.isRubyString(object)) {
                return this.getContext().getJRubyRuntime().newString(RopeOperations.toByteListCopy(StringOperations.rope((DynamicObject)object)));
            }
            if (RubyGuards.isRubyEncoding(object)) {
                return this.getContext().getJRubyRuntime().getEncodingService().rubyEncodingFromObject((IRubyObject)this.getContext().getJRubyRuntime().newString(Layouts.ENCODING.getName((DynamicObject)object)));
            }
            throw new UnsupportedOperationException();
        }
    }
}

