/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.array.ArrayAppendOneNode;
import org.jruby.truffle.core.array.ArrayAppendOneNodeGen;
import org.jruby.truffle.core.array.ArrayEnsureCapacityNode;
import org.jruby.truffle.core.array.ArrayGeneralizeNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="value", type=RubyNode.class)})
public abstract class ArrayWriteNormalizedNode
extends RubyNode {
    public ArrayWriteNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeWrite(DynamicObject var1, int var2, Object var3);

    @Specialization(guards={"isNullArray(array)", "index == 0", "strategy.specializesFor(value)"}, limit="ARRAY_STRATEGIES")
    public Object writeNull0(DynamicObject array, int index, Object value, @Cached(value="forValue(value)") ArrayStrategy strategy) {
        ArrayMirror storeMirror = strategy.newArray(1);
        storeMirror.set(0, value);
        ArrayHelpers.setStoreAndSize(array, storeMirror.getArray(), 1);
        return value;
    }

    @Specialization(guards={"isNullArray(array)", "index != 0"})
    public Object writeNullBeyond(DynamicObject array, int index, Object value) {
        Object[] store = new Object[index + 1];
        for (int n = 0; n < index; ++n) {
            store[n] = this.nil();
        }
        store[index] = value;
        ArrayHelpers.setStoreAndSize(array, store, store.length);
        return value;
    }

    @Specialization(guards={"isInBounds(array, index)", "strategy.matches(array)", "strategy.accepts(value)"}, limit="ARRAY_STRATEGIES")
    public Object writeWithin(DynamicObject array, int index, Object value, @Cached(value="of(array, value)") ArrayStrategy strategy) {
        strategy.newMirror(array).set(index, value);
        return value;
    }

    @Specialization(guards={"isInBounds(array, index)", "currentStrategy.matches(array)", "!currentStrategy.accepts(array)", "generalizedStrategy.accepts(value)"}, limit="ARRAY_STRATEGIES")
    public Object writeWithinGeneralize(DynamicObject array, int index, Object value, @Cached(value="of(array)") ArrayStrategy currentStrategy, @Cached(value="currentStrategy.generalizeFor(value)") ArrayStrategy generalizedStrategy) {
        int size = ArrayHelpers.getSize(array);
        ArrayMirror currentMirror = currentStrategy.newMirror(array);
        ArrayMirror storeMirror = generalizedStrategy.newArray(currentMirror.getLength());
        currentMirror.copyTo(storeMirror, 0, 0, size);
        storeMirror.set(index, value);
        Layouts.ARRAY.setStore(array, storeMirror.getArray());
        return value;
    }

    @Specialization(guards={"isExtendingByOne(array, index)"})
    public Object writeExtendByOne(DynamicObject array, int index, Object value, @Cached(value="createArrayAppendOneNode()") ArrayAppendOneNode appendNode) {
        appendNode.executeAppendOne(array, value);
        return value;
    }

    protected ArrayAppendOneNode createArrayAppendOneNode() {
        return ArrayAppendOneNodeGen.create(this.getContext(), this.getSourceSection(), null, null);
    }

    @Specialization(guards={"!isObjectArray(array)", "!isInBounds(array, index)", "!isExtendingByOne(array, index)"})
    public Object writeBeyondPrimitive(DynamicObject array, int index, Object value, @Cached(value="create(getContext())") ArrayGeneralizeNode generalizeNode) {
        int newSize = index + 1;
        Object[] objectStore = generalizeNode.executeGeneralize(array, newSize);
        for (int n = ArrayHelpers.getSize(array); n < index; ++n) {
            objectStore[n] = this.nil();
        }
        objectStore[index] = value;
        ArrayHelpers.setStoreAndSize(array, objectStore, newSize);
        return value;
    }

    @Specialization(guards={"isObjectArray(array)", "!isInBounds(array, index)", "!isExtendingByOne(array, index)"})
    public Object writeBeyondObject(DynamicObject array, int index, Object value, @Cached(value="create(getContext())") ArrayEnsureCapacityNode ensureCapacityNode) {
        ensureCapacityNode.executeEnsureCapacity(array, index + 1);
        Object[] objectStore = (Object[])Layouts.ARRAY.getStore(array);
        for (int n = ArrayHelpers.getSize(array); n < index; ++n) {
            objectStore[n] = this.nil();
        }
        objectStore[index] = value;
        Layouts.ARRAY.setSize(array, index + 1);
        return value;
    }

    protected static boolean isInBounds(DynamicObject array, int index) {
        return index >= 0 && index < ArrayHelpers.getSize(array);
    }

    protected static boolean isExtendingByOne(DynamicObject array, int index) {
        return index == ArrayHelpers.getSize(array);
    }
}

